/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringPrinter
implements Printable {
    private List<String> paragraphs = null;
    private List<TextLayout> lines = new ArrayList<TextLayout>();
    private Map<Integer, Integer> firstLines = new HashMap<Integer, Integer>();

    public StringPrinter() {
        this(new ArrayList<String>());
    }

    public StringPrinter(List<String> paragraphs) {
        this.firstLines.put(0, 0);
        this.setParagraphs(paragraphs);
    }

    public void setParagraphs(List<String> paragraphs) {
        this.paragraphs = paragraphs;
        if (this.paragraphs == null) {
            this.paragraphs = new ArrayList<String>();
        }
    }

    protected List<String> getParagraphs() {
        return this.paragraphs;
    }

    public void addParagraph(String paragraph) {
        if (paragraph != null) {
            this.paragraphs.add(paragraph);
        }
    }

    public void print() throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        if (job.printDialog()) {
            job.print();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g = (Graphics2D)graphics;
        g.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Font font = new Font("Monospaced", 0, 12);
        FontMetrics fm = g.getFontMetrics(font);
        if (pageIndex == 0) {
            this.lines.clear();
            for (String paragraph : this.getParagraphs()) {
                TextLayout layout;
                if (paragraph.equals("")) {
                    paragraph = " ";
                }
                AttributedString s = new AttributedString(paragraph);
                s.addAttribute(TextAttribute.FONT, font);
                FontRenderContext frc = new FontRenderContext(null, true, true);
                LineBreakMeasurer l = new LineBreakMeasurer(s.getIterator(), frc);
                while ((layout = l.nextLayout((float)pageFormat.getImageableWidth())) != null) {
                    this.lines.add(layout);
                }
            }
        }
        Point2D.Float p = new Point2D.Float(0.0f, 0.0f);
        int i = this.firstLines.get(pageIndex);
        if (i >= this.lines.size()) {
            return 1;
        }
        while ((double)p.y <= pageFormat.getImageableHeight() - (double)fm.getHeight() && i < this.lines.size()) {
            TextLayout layout = this.lines.get(i);
            p.y += layout.getAscent();
            layout.draw(g, p.x, p.y);
            p.y += layout.getDescent();
            p.y += layout.getLeading();
            ++i;
        }
        this.firstLines.put(pageIndex + 1, i);
        return 0;
    }
}

