/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.termutils;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import universalrouter.util.StringConvertor;

public class Display {
    private int displaySize = 10;
    private boolean clear;
    private boolean logout;
    private String[] displayValues = new String[this.displaySize];

    public void nullDisplay() {
        for (int i = 0; i < this.displayValues.length - 1; ++i) {
            this.displayValues[i] = null;
        }
    }

    public void setLogout(boolean lgo) {
        this.logout = lgo;
    }

    public boolean getLogout() {
        return this.logout;
    }

    public void setClear(boolean clr) {
        this.clear = clr;
    }

    public boolean getClear() {
        return this.clear;
    }

    public String getEXPosition(int x) {
        return this.displayValues[x];
    }

    public void setEXPosition(String Ex, int x) {
        this.setEXPosition(Ex, x, false);
    }

    public void setEXPosition(String Ex, int x, boolean oneByOne) {
        if (!oneByOne) {
            this.displayValues[x] = x + Ex;
        } else {
            char position;
            switch (x) {
                case 1: {
                    position = 'A';
                    break;
                }
                case 2: {
                    position = 'B';
                    break;
                }
                case 3: {
                    position = 'C';
                    break;
                }
                case 4: {
                    position = 'D';
                    break;
                }
                case 5: {
                    position = 'E';
                    break;
                }
                case 6: {
                    position = 'F';
                    break;
                }
                case 7: {
                    position = 'G';
                    break;
                }
                case 8: {
                    position = 'H';
                    break;
                }
                default: {
                    position = '3';
                }
            }
            this.displayValues[x] = position + Ex;
        }
    }

    public void setEXPositionBig(String Ex, int x) {
        char position;
        switch (x) {
            case 1: {
                position = ';';
                break;
            }
            case 2: {
                position = '<';
                break;
            }
            case 3: {
                position = '=';
                break;
            }
            case 4: {
                position = '>';
                break;
            }
            default: {
                position = '3';
            }
        }
        this.displayValues[x] = position + Ex;
    }

    public byte[] getFinalizedEXPosition(int x, boolean localChars) {
        try {
            if (localChars) {
                return Display.finalizeByteArray(this.displayValues[x].getBytes("Windows-1250"));
            }
            return Display.finalizeByteArray(StringConvertor.internationalToEnglish(this.displayValues[x]).getBytes("Windows-1250"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Display.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] finalizeByteArray(byte[] byteArray) {
        byte[] b1 = new byte[]{4};
        byte[] result = new byte[byteArray.length + 1];
        try {
            System.arraycopy(byteArray, 0, result, 0, byteArray.length);
            System.arraycopy(b1, 0, result, byteArray.length, b1.length);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            b1 = null;
            result = null;
        }
    }

    public int getDisplaySize() {
        return this.displaySize - 1;
    }
}

