/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import universalrouter.terminals.TerminalBase;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.MealOrder;
import universalrouter.util.StringConvertor;

public class TerminalVydej
extends TerminalBase
implements TerminalCommonInterface {
    private static final String terminalName = "V\u00fddejn\u00ed";

    public TerminalVydej(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setMealBeep('1');
        this.setMealOrder(new MealOrder(0, 0));
        this.setDisplay(new Display());
        this.setVolume(vol);
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setUser(null);
            this.setMealBeep('1');
            this.getMealOrder().setStatus(0);
            this.getDisplay().nullDisplay();
        }
        catch (Exception e) {
            LOGGER.fatal((Object)"!!!!! Chyba nulovani dat terminalu !!!!!");
        }
    }

    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2 && this.getStrReader().compareTo("01") == 0) {
            return smess;
        }
        int echk = this.extendedPrimaryCheck();
        if (echk != 1) {
            return echk;
        }
        this.hasUserOrdered(this.getChipID());
        switch (this.getMealOrder().getStatus()) {
            case -1: {
                this.setSegment((byte)0);
                this.setTempDisplayText("NEOBJEDN\u00c1NO");
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Vydej* StrID: " + this.getUser().getId() + " || NEOBJEDNANO"));
                this.setMealBeep('F');
                this.setInformationDisplay();
                return 0;
            }
            case -2: {
                this.setSegment((byte)15);
                this.setTempDisplayText("U\u017e vyd\u00e1no");
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Vydej* StrID: " + this.getUser().getId() + " || Uz vydano"));
                this.setMealBeep('F');
                this.setInformationDisplay();
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getMealOrder().getMealName()), 1);
                return 0;
            }
            case -3: {
                this.setSegment((byte)11);
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Vydej* StrID: " + this.getUser().getId() + " || Jiny terminal"));
                this.setTempDisplayText("Jin\u00fd termin\u00e1l");
                this.setMealBeep('F');
                this.setInformationDisplay();
                return 0;
            }
            case -99: {
                this.setSegment((byte)29);
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Vydej* StrID: " + this.getUser().getId() + " || Syst. chyba"));
                this.setTempDisplayText("Syst. chyba");
                this.setMealBeep('F');
                this.setInformationDisplay();
                return -1;
            }
        }
        LOGGER.info((Object)(this.getTerminalID() + " " + "*Vydej* StrID: " + this.getUser().getId() + " || Vydavam ObjId:" + this.getMealOrder().getOrderNumber()));
        this.setMealBeep(this.getMealBeep(this.getMealOrder().getOrderNumber()));
        this.requestMeal(this.getMealOrder().getOrderNumber());
        this.setInformationDisplay();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char getMealBeep(int objednavka) {
        char c;
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT moreBeep FROM rtr_meals LEFT JOIN tobjednavky ON rtr_meals.meal_id = tobjednavky.chod_id WHERE Objednavka_Id = " + objednavka + " AND rtr_meals.terminal_id= " + this.getTerminalID());
            if (!rs.next()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Nezjisten pocet piskani-nastavuje se na 1"));
                rs.close();
                char c2 = '1';
                return c2;
            }
            c = (char)(48 + rs.getInt("moreBeep"));
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            char c3 = 'F';
            return c3;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
        return c;
    }

    public String getTerminalName() {
        return terminalName;
    }
}

