/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import universalrouter.database.SQLParam;
import universalrouter.terminals.TerminalBase;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.MealOrder;

public class TerminalPevi
extends TerminalBase
implements TerminalCommonInterface {
    private static final String terminalName = "Pevi";
    private int mode;

    public TerminalPevi(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int mode, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.mode = mode;
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setMealOrder(new MealOrder(0, 0));
        this.setDisplay(new Display());
        this.setVolume(vol);
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setUser(null);
        }
        catch (Exception e) {
            System.out.println("Chyba nulovani dat terminalu");
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        LOGGER.info((Object)(this.getTerminalID() + " " + "Overuji cip"));
        if (this.isPeviChipInDatabase(this.getChipCode()) == -1) {
            this.setSegment((byte)14);
            return 0;
        }
        LOGGER.info((Object)(this.getTerminalID() + " " + "Cip overen"));
        String strTerminalMode = "";
        switch (this.getMode()) {
            case 1: {
                strTerminalMode = "01";
                break;
            }
            case 2: {
                strTerminalMode = "02";
            }
        }
        try {
            ArrayList<SQLParam> params = new ArrayList<SQLParam>();
            params.add(new SQLParam("ChipNumber", this.getChipCode(), "string"));
            params.add(new SQLParam("Type", strTerminalMode, "string"));
            params.add(new SQLParam("Reader", this.getStrReader(), "string"));
            this.dbmanager.doPreparedStatement("INSERT INTO tRequests (ChipNumber, Date, Type, Reader) Values (?,NOW(),?,?)", params);
            this.setSegment((byte)8);
            LOGGER.info((Object)(this.getTerminalID() + " " + "Pridavam pruchod do pozadavku"));
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v prepared statementu", (Throwable)ex);
            this.setSegment((byte)29);
            return -1;
        }
        this.setSegment((byte)8);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int isPeviChipInDatabase(String chipCode) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT ID FROM tChips WHERE ChipNumber = '" + chipCode + "'");
            rs.beforeFirst();
            if (!rs.next()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Cip: " + chipCode + " nebyl nalezen v databazi"));
                int n = -1;
                return n;
            }
            rs.getInt("Id");
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    public String getTerminalName() {
        return terminalName;
    }
}

