/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import universalrouter.terminals.TerminalBase;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.ChipEvent;
import universalrouter.termutils.ChipListener;
import universalrouter.termutils.Display;
import universalrouter.termutils.MealOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalOrbisStrip2Chip
extends TerminalBase
implements TerminalCommonInterface {
    private static final String terminalName = "OrbisStrip2Chip";
    List<ChipListener> chipListeners = new LinkedList<ChipListener>();

    public TerminalOrbisStrip2Chip(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int mode, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setMealOrder(new MealOrder(0, 0));
        this.setDisplay(new Display());
        this.setVolume(vol);
        LOGGER.info((Object)("Pridavam TerminalOrbisStrip2Chip s nastavenim: adress=" + adr + ", type=" + type + ", hasTerminalGraphicalDisplay=" + hasTerminalGraphicalDisplay + ", placeID=" + placeID + ", terminal_id=" + id + ", resetLockedTerminalAfter=" + this.resetLockedTerminalAfter + ", volume=" + vol));
    }

    @Override
    public int doAction(byte[] byteBuffer) {
        this.nullData();
        String icid = this.getChipCode();
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        boolean repeated = false;
        if (this.sendedTwice(this.adr)) {
            repeated = true;
            if (icid == this.getChipCode()) {
                LOGGER.debug((Object)"Cipy se rovnaji, opravdu poslat stara data");
                return -4;
            }
            LOGGER.debug((Object)"Cipy se nerovnaji, Neprijata data");
        }
        if (!repeated && !this.isForMe(this.adr)) {
            return -2;
        }
        if (this.command.compareTo("H") != 0) {
            this.setSegment((byte)14);
            this.nullData();
            LOGGER.error((Object)("Neznamy prikaz: " + this.command));
            return -1;
        }
        new Thread(){

            public void run() {
                TerminalOrbisStrip2Chip.this.fireChip(new ChipEvent(this, 0, TerminalOrbisStrip2Chip.this.getChipCode()));
            }
        }.start();
        LOGGER.info((Object)("Cip " + this.getChipCode() + " predan do GUI, strReader je " + this.getStrReader()));
        return 1;
    }

    @Override
    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setUser(null);
        }
        catch (Exception e) {
            System.out.println("Chyba nulovani dat terminalu");
        }
    }

    public void addChipListener(ChipListener l) {
        this.chipListeners.add(l);
    }

    public void removeChipListener(ChipListener l) {
        this.chipListeners.remove(l);
    }

    public List<ChipListener> getChipListeners() {
        return Collections.unmodifiableList(this.chipListeners);
    }

    public void fireChip(ChipEvent chipEvent) {
        for (ChipListener chipListener : this.chipListeners) {
            chipListener.dispatchChip(chipEvent);
        }
    }

    @Override
    public String getTerminalName() {
        return terminalName;
    }
}

