/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.terminals.TerminalOrbisPristup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalOrbisPristupKlub
extends TerminalOrbisPristup
implements TerminalCommonInterface {
    private static final String terminalName = "Pristup klub";

    public TerminalOrbisPristupKlub(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int mode, int id, int ra, String vol) {
        super(adr, type, hasTerminalGraphicalDisplay, placeID, mode, id, ra, vol);
        LOGGER.info((Object)("Pridavam TerminalOrbisPristupKlub s nastavenim: mode=" + mode + ", adress=" + adr + ", type=" + type + ", hasTerminalGraphicalDisplay=" + hasTerminalGraphicalDisplay + ", placeID=" + placeID + ", terminal_id=" + id + ", resetLockedTerminalAfter=" + this.resetLockedTerminalAfter + ", volume=" + vol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isPermitted(String chipCode) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT id, prezdivka, jmeno, prijmeni, vstup_do_arealu, vstup_do_klubu,  typ_cloveka, prijezd, odjezd, datum_narozeni, (UNIX_TIMESTAMP()-UNIX_TIMESTAMP(datum_narozeni)) AS vek  FROM clovek WHERE chip = '" + chipCode + "'");
            rs.beforeFirst();
            if (!rs.next()) {
                this.log(0, "Cip: " + chipCode + " nebyl nalezen v databazi", false);
                boolean bl = false;
                return bl;
            }
            LOGGER.info((Object)(this.getTerminalID() + " " + "Cip: " + chipCode + " nalezen v databazi, kontroluju prava"));
            String celeJmeno = rs.getInt("id") + ", " + rs.getString("prezdivka") + ": " + rs.getString("jmeno") + " " + rs.getString("prijmeni");
            Date currentDate = new Date();
            if (rs.getInt("vstup_do_arealu") < 0) {
                this.log(rs.getInt("id"), "Vstup/Vychod do/z klubu pro " + celeJmeno + " explicitne zakazan atibutem \"vstup_do_arealu\"", false);
                boolean bl = false;
                return bl;
            }
            if (rs.getInt("vstup_do_klubu") < 0) {
                this.log(rs.getInt("id"), "Vstup/Vychod do/z klubu pro " + celeJmeno + " explicitne zakazan atibutem \"vstup_do_klubu\"", false);
                boolean bl = false;
                return bl;
            }
            if (rs.getLong("vek") < 567993600L) {
                this.log(rs.getInt("id"), "Vstup/Vychod do/z klubu pro " + celeJmeno + " zakazan kvuli nizkemu veku", false);
                boolean bl = false;
                return bl;
            }
            if (this.getMode() == 2) {
                this.log(rs.getInt("id"), "Vychod z klubu pro " + celeJmeno + " povolen, proc ne?", true);
                boolean bl = true;
                return bl;
            }
            if (rs.getInt("typ_cloveka") == 5 && !this.isOtherGroupChiefOutside(rs.getInt("id"))) {
                this.log(rs.getInt("id"), "Vstup/Vychod do/z klubu pro " + celeJmeno + " zakazan, jeden clovek ze skupiny musi zustat venku", false);
                boolean bl = false;
                return bl;
            }
            if (rs.getInt("vstup_do_klubu") > 0) {
                this.log(rs.getInt("id"), "Vstup/Vychod do/z klubu casti pro " + celeJmeno + " povolen atibutem \"vstup_do_klubu\"", true);
                boolean bl = true;
                return bl;
            }
            this.log(rs.getInt("id"), "Vstup/Vychod do/z klubu pro " + celeJmeno + " povolen", true);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (SQLException e) {}
            rs = null;
            stm = null;
        }
    }

    private boolean isOtherGroupChiefOutside(int clovek) {
        List<Integer> groups = this.getGroups(clovek);
        for (Integer g : groups) {
            List<Integer> leaders = this.getLeaders(g, clovek);
            if (leaders.isEmpty()) {
                return false;
            }
            Map<Integer, SortedSet<LogEntry>> logMap = this.getLogs(leaders);
            if (this.groupOk(leaders, logMap)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getGroups(int clovek) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        String query = "SELECT vyprava FROM ucastnik WHERE clovek = ?";
        LinkedList<Integer> groups = new LinkedList<Integer>();
        try {
            ps = this.dbmanager.getPreparedStatement(query);
            ps.setInt(1, clovek);
            rs = ps.executeQuery();
            rs.beforeFirst();
            while (rs.next()) {
                groups.add(rs.getInt("vyprava"));
            }
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani vyprav v databazi.", (Throwable)ex);
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (SQLException e) {}
            rs = null;
            ps = null;
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getLeaders(int vyprava, int clovek) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        String query = "SELECT clovek FROM ucastnik WHERE vyprava = ? AND clovek <> ?";
        LinkedList<Integer> leaders = new LinkedList<Integer>();
        try {
            ps = this.dbmanager.getPreparedStatement(query);
            ps.setInt(1, vyprava);
            ps.setInt(2, clovek);
            rs = ps.executeQuery();
            rs.beforeFirst();
            while (rs.next()) {
                leaders.add(rs.getInt("clovek"));
            }
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani GC v databazi.", (Throwable)ex);
        }
        finally {
            try {
                rs.close();
                ps.close();
            }
            catch (SQLException e) {}
            rs = null;
            ps = null;
        }
        return leaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, SortedSet<LogEntry>> getLogs(List<Integer> leaders) {
        StringBuffer leadersSetString = new StringBuffer("( ");
        Iterator<Integer> i = leaders.iterator();
        while (i.hasNext()) {
            leadersSetString.append(i.next().toString());
            if (!i.hasNext()) continue;
            leadersSetString.append(", ");
        }
        leadersSetString.append(" )");
        ResultSet rs = null;
        Statement s = null;
        String query = "SELECT mode, cas, clovek_id FROM log_terminalu WHERE clovek_id IN " + leadersSetString + " AND " + "type = 1052 AND " + "result = 1 " + "ORDER BY cas DESC " + "LIMIT 0,100";
        TreeMap<Integer, SortedSet<LogEntry>> logMap = new TreeMap<Integer, SortedSet<LogEntry>>();
        try {
            s = this.dbmanager.getStatement();
            rs = s.executeQuery(query);
            rs.beforeFirst();
            while (rs.next()) {
                int clovek_id = rs.getInt("clovek_id");
                long cas = rs.getTimestamp("cas").getTime();
                if (logMap.containsKey(clovek_id)) {
                    ((SortedSet)logMap.get(clovek_id)).add(new LogEntry(clovek_id, rs.getInt("mode"), cas));
                    continue;
                }
                logMap.put(rs.getInt("clovek_id"), new TreeSet());
                ((SortedSet)logMap.get(clovek_id)).add(new LogEntry(clovek_id, rs.getInt("mode"), cas));
            }
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani ostatnich GC v databazi, nepoustim do klubu.", (Throwable)ex);
        }
        finally {
            try {
                rs.close();
                s.close();
            }
            catch (SQLException e) {}
            rs = null;
            s = null;
        }
        return logMap;
    }

    private boolean groupOk(List<Integer> leaders, Map<Integer, SortedSet<LogEntry>> logMap) {
        if (!logMap.keySet().containsAll(leaders)) {
            return true;
        }
        LOGGER.info(logMap);
        for (Integer leader : leaders) {
            if (!logMap.containsKey(leader)) {
                return true;
            }
            if (logMap.get((Object)leader).last().mode != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTerminalName() {
        return terminalName;
    }

    class LogEntry
    implements Comparable {
        public int clovek_id;
        public int mode;
        public long cas;

        public LogEntry(int clovek_id, int mode, long cas) {
            this.clovek_id = clovek_id;
            this.mode = mode;
            this.cas = cas;
        }

        public String toString() {
            return "LogEntry, mode: " + this.mode + ", clovek_id: " + this.clovek_id + ", cas: " + this.cas;
        }

        public int compareTo(Object o) {
            LogEntry l = (LogEntry)o;
            if (this.cas > l.cas) {
                return 1;
            }
            if (this.cas == l.cas) {
                return 0;
            }
            return -1;
        }
    }
}

