/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import universalrouter.terminals.TerminalBase;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.MealOrder;

public abstract class TerminalOrbisPristup
extends TerminalBase
implements TerminalCommonInterface {
    private int mode;

    public TerminalOrbisPristup(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int mode, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.setMode(mode);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setMealOrder(new MealOrder(0, 0));
        this.setDisplay(new Display());
        this.setVolume(vol);
    }

    protected abstract boolean isPermitted(String var1);

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setUser(null);
        }
        catch (Exception e) {
            System.out.println("Chyba nulovani dat terminalu");
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public int doAction(byte[] byteBuffer) {
        this.nullData();
        String icid = this.getChipCode();
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        boolean repeated = false;
        if (this.sendedTwice(this.adr)) {
            repeated = true;
            if (icid == this.getChipCode()) {
                LOGGER.debug((Object)"Cipy se rovnaji, opravdu poslat stara data");
                return -4;
            }
            LOGGER.debug((Object)"Cipy se nerovnaji, Neprijata data");
        }
        if (!repeated && !this.isForMe(this.adr)) {
            return -2;
        }
        if (this.command.compareTo("H") != 0) {
            this.setSegment((byte)14);
            this.nullData();
            LOGGER.error((Object)("Neznamy prikaz: " + this.command));
            return -1;
        }
        LOGGER.info((Object)(this.getTerminalID() + " " + "Overuji cip"));
        boolean permitted = this.isPermitted(this.getChipCode());
        if (permitted) {
            LOGGER.info((Object)(this.getTerminalID() + " " + "Cip " + this.getChipCode() + " povolen"));
        } else {
            LOGGER.info((Object)(this.getTerminalID() + " " + "Cip " + this.getChipCode() + " zakazan"));
        }
        LOGGER.debug((Object)(this.getTerminalID() + " " + "Potvrzuji zpracovani"));
        return permitted ? 1 : 0;
    }

    protected void log(int id_clovek, String popis, boolean result) {
        LOGGER.info((Object)(this.getTerminalID() + " " + popis));
        try {
            String query = "INSERT INTO log_terminalu (cas, chip, adress, type, place_id, mode, result, clovek_id, popis) Values (NOW(), ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement pstmt = this.dbmanager.getPreparedStatement(query);
            pstmt.setString(1, this.getChipCode());
            pstmt.setInt(2, this.getAdress());
            pstmt.setInt(3, this.getType());
            pstmt.setInt(4, this.getPlaceID());
            pstmt.setInt(5, this.getMode());
            pstmt.setInt(6, result ? 1 : 0);
            pstmt.setInt(7, id_clovek);
            pstmt.setString(8, popis);
            int rowCount = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v ukladani do logu", (Throwable)ex);
        }
    }
}

