/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import cz.zware.universalrouter.entity.Chod;
import cz.zware.universalrouter.entity.Dodavatel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.terminals.TerminalObjednavka;
import universalrouter.terminals.TerminalObjednavkaDao;
import universalrouter.util.StringConvertor;

public class TerminalObjednavkaPrinter
extends TerminalObjednavka
implements TerminalCommonInterface {
    private static final String terminalName = "Printer";
    private static final int TERMINAL_TYPE = 7;
    private static final char[] DOTTED_STYLE_WIDE_ON = new char[]{'\u001b', 'W', '1'};
    private static final char[] DOTTED_STYLE_WIDE_OFF = new char[]{'\u001b', 'W', '0'};
    private static final char[] DOTTED_STYLE_BOLD_ON = new char[]{'\u001b', 'E'};
    private static final char[] DOTTED_STYLE_BOLD_OFF = new char[]{'\u001b', 'F'};
    private static final char[] THERMAL_STYLE_WIDE_ON = new char[]{'\u001b', '!', '0'};
    private static final char[] THERMAL_STYLE_WIDE_OFF = new char[]{'\u001b', '!', '0', '\u001b', 'S', '\u001b', '@'};
    private static final char[] THERMAL_STYLE_BOLD_ON = new char[]{'\u001b', 'E', '1'};
    private static final char[] THERMAL_STYLE_BOLD_OFF = new char[]{'\u001b', 'E', '0'};
    private static final char[] THERMAL_STYLE_CUT = new char[]{'\u001d', 'V', 'B'};
    @Autowired
    private TerminalObjednavkaDao terminalObjednavkaDao;

    public TerminalObjednavkaPrinter(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int id, int ra, String vol) {
        super(adr, type, hasTerminalGraphicalDisplay, placeID, id, ra, vol);
        this.terminalType = 7;
    }

    public void init() {
        super.init();
        this.terminalObjednavkaDao = (TerminalObjednavkaDao)this.getApplicationContext().getBean("terminalObjednavkaDao");
    }

    public int doAction(byte[] byteBuffer) {
        this.print = false;
        int result = super.doAction(byteBuffer);
        if (result == 1 && this.print) {
            try {
                Chod chod = this.terminalObjednavkaDao.getMealById(this.getMealId());
                if (chod.getTiskTerminal() > 0) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(os);
                    ps.println("---------------------------------------");
                    Dodavatel dodavatel = this.terminalObjednavkaDao.getJidelnaInfo();
                    if (dodavatel != null) {
                        ps.println(StringConvertor.internationalToEnglish("Nazev: " + dodavatel.getNazev()));
                        ps.println(StringConvertor.internationalToEnglish("ICO: " + dodavatel.getIco()));
                        ps.println(StringConvertor.internationalToEnglish("Adresa: " + dodavatel.getUlice() + " " + dodavatel.getObec()));
                        if (dodavatel.getTelefon() != null) {
                            ps.println("Tel: " + dodavatel.getTelefon());
                        }
                        ps.println();
                    }
                    ps.print(THERMAL_STYLE_WIDE_ON);
                    ps.println(StringUtils.center((String)this.getDisplay().getEXPosition(3).substring(1).trim(), (int)24));
                    ps.println(StringConvertor.internationalToEnglish("Chod: \t" + chod.getChodTxt()));
                    ps.println(StringConvertor.internationalToEnglish("Cena: \t" + this.getMealPrice(this.getMealId(), this.getUser().getId(), 0, 1)));
                    ps.print(THERMAL_STYLE_WIDE_OFF);
                    ps.println();
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat formatter = new SimpleDateFormat("dd.MM. yyyy HH:mm:ss");
                    ps.println(formatter.format(cal.getTime()).toString());
                    ps.println(StringConvertor.internationalToEnglish("Stravnik: " + this.getUser().getName() + " Id:" + this.getUser().getId()));
                    ps.println(StringConvertor.internationalToEnglish("Cislo objednavky: " + this.getTerminalBaseDao().getObjednavkaIdByUserDateMeal(this.getPlaceID(), this.getUser().getId(), this.getMealId(), this.datumObjednavky)));
                    ps.println("---------------------------------------");
                    ps.println(THERMAL_STYLE_CUT);
                    this.doPrint(os);
                    ps.flush();
                    ps.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Nebylo mozne tisknout", (Throwable)e);
            }
        }
        return result;
    }

    public void doSpecialChipAction() {
        if (this.terminalObjednavkaDao.getCipByChipId(this.getChipID()).getCipStav() == 101) {
            this.setTempDisplayText("Tisknu po\u010dty");
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(os);
                SimpleDateFormat formatter1 = new SimpleDateFormat("dd.MM. yyyy");
                ps.println("---------------------------------------");
                ps.print(THERMAL_STYLE_WIDE_ON);
                ps.println(" Pocty " + formatter1.format(this.datumObjednavky).toString());
                ps.print(THERMAL_STYLE_WIDE_OFF);
                ps.println();
                ps.print(THERMAL_STYLE_BOLD_ON);
                ps.println(StringUtils.rightPad((String)"", (int)16) + StringUtils.leftPad((String)"Obj.", (int)8) + StringUtils.leftPad((String)"Vyd.", (int)8) + StringUtils.leftPad((String)"Nevyd.", (int)8));
                ps.print(THERMAL_STYLE_BOLD_OFF);
                List soucty = this.getTerminalBaseDao().getCountObjednavkyForDate(this.datumObjednavky);
                for (HashMap soucet : soucty) {
                    ps.println(StringConvertor.internationalToEnglish(StringUtils.rightPad((String)soucet.get("ChodTxt").toString(), (int)16)) + StringUtils.leftPad((String)("" + Double.valueOf(soucet.get("pocetObjednavek").toString()).intValue()), (int)8) + StringUtils.leftPad((String)("" + Double.valueOf(soucet.get("pocetVydanych").toString()).intValue()), (int)8) + StringUtils.leftPad((String)("" + Double.valueOf(soucet.get("pocetNevydanych").toString()).intValue()), (int)8));
                }
                ps.println();
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM. yyyy HH:mm:ss");
                ps.println("Vytisknuto: " + formatter.format(cal.getTime()).toString());
                ps.println("---------------------------------------");
                ps.println(THERMAL_STYLE_CUT);
                this.doPrint(os);
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Nebylo mozne tisknout", (Throwable)e);
            }
        }
    }

    public boolean isSpecialChip() {
        return this.terminalObjednavkaDao.getCipByChipId(this.getChipID()).getCipStav() > 100;
    }

    protected void doPrint(ByteArrayOutputStream os) {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PrintService[] pservices = PrintServiceLookup.lookupPrintServices(flavor, aset);
        SimpleDoc sd = new SimpleDoc(os.toByteArray(), flavor, null);
        int printnbr = 0;
        DocPrintJob pj = null;
        try {
            if (pservices[printnbr] != null) {
                pj = pservices[printnbr].createPrintJob();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.warn((Object)"Nebylo mozne najit tiskarnu na pozici: 0", (Throwable)e);
        }
        for (PrintService printService : pservices) {
            if (!printService.getName().equalsIgnoreCase("Epson")) continue;
            pj = printService.createPrintJob();
            break;
        }
        try {
            pj.print(sd, aset);
        }
        catch (PrintException e) {
            LOGGER.error((Object)"Nebylo mozne tisknout", (Throwable)e);
        }
    }

    public String getTerminalName() {
        return terminalName;
    }
}

