/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import universalrouter.comm.OrderLimit;
import universalrouter.terminals.TerminalBaseObjednavka;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.Relation;
import universalrouter.termutils.TerminalData;
import universalrouter.util.StringConvertor;

public class TerminalObjednavka
extends TerminalBaseObjednavka
implements TerminalCommonInterface {
    private static final String terminalName = "Objednavka";
    private static final int TERMINAL_TYPE = 5;
    protected int numberOfButtonTouched;
    protected int dayOfWeek = 0;
    protected int dayIncrement = 0;
    protected int messIncrement = 0;
    protected boolean print;
    protected Date datumObjednavky;

    public TerminalObjednavka(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setDisplay(new Display());
        this.setVolume(vol);
        this.datumObjednavky = new Date();
        this.terminalType = 5;
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setMealId(0);
            this.setChipReadedForObjednavkaTerminal(null);
            this.getDisplay().nullDisplay();
            this.dayOfWeek = 0;
            this.dayIncrement = 0;
            this.setMessIncrement(0);
            this.numberOfButtonTouched = 0;
            this.setUser(null);
            this.datumObjednavky = new Date();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Chyba nulovani dat terminalu");
        }
    }

    public boolean isSpecialChip() {
        return false;
    }

    public void doSpecialChipAction() {
    }

    public void countMoreMealsButton(int lbt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2 && this.getStrReader().compareTo("01") == 0) {
            return smess;
        }
        if (this.getStrReader().compareTo("01") == 0) {
            Calendar cal;
            if (this.getChipCode().substring(0, 2).compareTo("00") == 0) {
                this.nullData();
                this.getDisplay().setLogout(true);
                return -2;
            }
            if (this.getChipCode().substring(0, 2).compareTo("06") == 0 && !this.gs.isWeekends()) {
                return -2;
            }
            if (this.getChipReadedForObjednavkaTerminal() == null) {
                this.getDisplay().setClear(true);
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Prilo\u017ete \u010dip!"), 6);
                return -2;
            }
            int lbt = this.getLastButtonTouched();
            this.decodeLastButtonTouched(this.getChipCode().substring(0, 2));
            if (this.terminalType == 6) {
                this.countMoreMealsButton(lbt);
            } else if (this.getLastButtonTouched() == lbt) {
                this.incrementNumberOfButtonTouched();
            } else {
                this.setNumberOfButtonTouched(0);
            }
            if (this.setObjednavkaTerminal() > 0 && this.getDayOfWeek() != 0) {
                if (this.getLastButtonTouched() != 16 && this.getLastButtonTouched() != 26) {
                    this.getMealOnButton();
                    this.setTempDisplayText(this.getTempDisplayText() + ":" + this.getMessIncrement() + "ks");
                    if (this.getMealId() != 0) {
                        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.sumMealPriceString(this.getMessIncrement(), 0, this.getMealId()) + " K\u010d"), 7);
                    }
                }
            } else if (this.getDayOfWeek() == 0) {
                this.setTempDisplayText("Zvolte den");
            } else {
                this.setTempDisplayText("Zvolte j\u00eddlo");
            }
            try {
                int countZavislost;
                int subPocetHlavnich;
                boolean auto;
                boolean mainChod;
                boolean relChod;
                Relation tempRelation;
                Iterator<Relation> i;
                List<Relation> relations2;
                OrderLimit limit2;
                int interval;
                cal = Calendar.getInstance();
                int currentDayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
                if (this.getDayOfWeek() < currentDayOfWeek) {
                    cal.add(7, 7 - currentDayOfWeek + this.getDayOfWeek() + 7 * this.getDayIncrement());
                    interval = 7 - currentDayOfWeek + this.getDayOfWeek() + 7 * this.getDayIncrement();
                } else {
                    cal.add(7, this.getDayOfWeek() - currentDayOfWeek + 7 * this.getDayIncrement());
                    interval = this.getDayOfWeek() - currentDayOfWeek + 7 * this.getDayIncrement();
                }
                if (this.setObjednavkaTerminal() > 0 && this.getDayOfWeek() != 0 && this.getMealId() != 0) {
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.sumMealPriceString(this.getMessIncrement(), interval, this.getMealId()) + " K\u010d"), 7);
                }
                if (this.getUser() != null && this.hasUserSpecifiedOrdered(interval, -1) != -1 && this.getLastButtonTouched() < 10) {
                    String temp = this.getUserOrderes(interval);
                    if (temp.length() > 16) {
                        this.setTempDisplayText(temp.substring(0, temp.indexOf(";", 11)));
                        try {
                            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(temp.substring(temp.indexOf(";", 11) + 1, temp.length() - 1)), 7);
                        }
                        catch (Exception e) {}
                    } else {
                        this.setTempDisplayText(temp);
                    }
                }
                DateFormat df = DateFormat.getDateInstance(3);
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(TerminalData.getWeekDayName(this.getDayOfWeek()) + " " + df.format(cal.getTime())), 3);
                this.datumObjednavky = cal.getTime();
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getPlaceName() + "  *" + cal.get(3) + "*"), 4);
                this.setInformationDisplayNM(true);
                if (this.getLastButtonTouched() == 16) {
                    if (this.getDayOfWeek() == 0) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrId:" + this.getUser().getId() + " pri ruseni nevybral den a pokusil se zrusit"));
                        this.setTempDisplayText("Nevybr\u00e1n den");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int e = -2;
                        return e;
                    }
                    if (this.getMealId() == 0) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrId:" + this.getUser().getId() + " pri ruseni nevybral jidlo a pokusil se zrusit"));
                        this.setTempDisplayText("Nevybr\u00e1no j\u00eddlo");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int e = -2;
                        return e;
                    }
                    limit2 = this.getLimit(this.getMealId(), this.getPlaceID(), interval);
                    if (limit2 == null || limit2.isLimitTimeCancelExceeded(this.datumObjednavky, this.gs.isWeekends())) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrID: " + this.getUser().getId() + " || Po limitu"));
                        this.setTempDisplayText("Po limitu");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(false);
                        int n = -2;
                        return n;
                    }
                    if (this.gs.isUseRelations()) {
                        relations2 = this.getMealRelations(this.getMealId(), this.getPlaceID(), interval);
                        i = relations2.iterator();
                        tempRelation = null;
                        relChod = false;
                        mainChod = false;
                        auto = false;
                        subPocetHlavnich = 0;
                        countZavislost = 0;
                        while (i.hasNext()) {
                            tempRelation = i.next();
                            if (tempRelation.getRelationChod() == this.getMealId()) {
                                relChod = true;
                            } else {
                                auto = tempRelation.getPocetZavisly() - subPocetHlavnich > tempRelation.getPocetHlavni() * tempRelation.getCount() - this.getMessIncrement();
                                subPocetHlavnich += tempRelation.getPocetHlavni() * tempRelation.getCount();
                                mainChod = true;
                            }
                            ++countZavislost;
                        }
                        if (countZavislost == 0) {
                            mainChod = true;
                        }
                        if (!relChod && !mainChod) {
                            LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrID: " + this.getUser().getId() + " || Zavisly chod"));
                            this.setTempDisplayText("Z\u00e1visly chod");
                            this.setMealBeep('F');
                            this.setInformationDisplayNM(true);
                            int n = -2;
                            return n;
                        }
                        if (mainChod && auto && this.cancelSpecifiedDay(interval, tempRelation.getRelationChod(), this.getMessIncrement()) == -1) {
                            LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrID: " + this.getUser().getId() + " || Nelze zrusit"));
                            this.setTempDisplayText("Nelze zru\u0161it");
                            this.setMealBeep('F');
                            this.setInformationDisplayNM(true);
                            int n = -2;
                            return n;
                        }
                        i = null;
                        relations2.clear();
                        relations2 = null;
                    }
                    if (this.cancelSpecifiedDay(interval, this.getMealId(), this.getMessIncrement()) == -1) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrID: " + this.getUser().getId() + " || Nelze zrusit"));
                        this.setTempDisplayText("Nelze zru\u0161it");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int relations2 = -2;
                        return relations2;
                    }
                    LOGGER.info((Object)(this.getTerminalID() + " " + "***ZRUSENO*** dni:" + interval + " | ChdId:" + this.getMealId()));
                    this.setTempDisplayText("Zru\u0161eno " + this.getMessIncrement() + "ks");
                    this.setInformationDisplayNM(true);
                }
                if (this.getLastButtonTouched() == 26) {
                    if (this.getDayOfWeek() == 0) {
                        if (this.getUser() != null) {
                            LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrId:" + this.getUser().getId() + " pri objednavani nevybral den a pokusil se objednat"));
                        }
                        this.setTempDisplayText("Nevybr\u00e1n den");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int limit2 = -2;
                        return limit2;
                    }
                    if (this.getMealId() == 0) {
                        if (this.terminalType == 7 && this.getLastButtonTouched() == 26 && this.isSpecialChip()) {
                            this.doSpecialChipAction();
                            this.setInformationDisplayNM(true);
                            int limit2 = 1;
                            return limit2;
                        }
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrId:" + this.getUser().getId() + " pri objednavani nevybral jidlo a pokusil se objednat"));
                        this.setTempDisplayText("Nevybr\u00e1no j\u00eddlo");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int limit2 = -2;
                        return limit2;
                    }
                    if (this.hasUserTypeOrdered(interval, this.getMealId()) && this.getUser().isOnlyOneMessPerMeal() && !this.getUser().isHromadny()) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Jiz objednano"));
                        this.setTempDisplayText("Ji\u017e objedn\u00e1no");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int limit2 = -2;
                        return limit2;
                    }
                    if (this.getMessIncrement() > 1 && this.getUser().isOnlyOneMessPerMeal() && !this.getUser().isHromadny()) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Mnoho kusu"));
                        this.setTempDisplayText("Mnoho kusu");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int limit2 = -2;
                        return limit2;
                    }
                    if (this.isSpecifiedJidelnicek(interval, this.getMealId(), true) == -1 && this.gs.isCheckJidelnicek()) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Neni jidelnicek"));
                        this.setTempDisplayText("Nen\u00ed j\u00eddeln\u00ed\u010dek");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int limit2 = -2;
                        return limit2;
                    }
                    if (this.getOrderedMessesCount(interval, this.getMealId()) + this.getMessIncrement() > this.getMaxMesses(interval, this.getMealId()) && this.gs.isCheckJidelnicek()) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Vycerpan limit"));
                        this.setTempDisplayText("Vy\u010derp\u00e1n limit");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int limit2 = -2;
                        return limit2;
                    }
                    limit2 = this.getLimit(this.getMealId(), this.getPlaceID(), interval);
                    if (limit2 == null || limit2.isLimitTimeOrderExceeded(this.datumObjednavky, this.gs.isWeekends())) {
                        this.setTempDisplayText("Po limitu");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int relations2 = -2;
                        return relations2;
                    }
                    if (this.checkCredit(this.getMessIncrement(), interval, this.getMealId()) == -3) {
                        this.setTempDisplayText("Nen\u00ed kredit");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(true);
                        int relations2 = -2;
                        return relations2;
                    }
                    if (this.gs.isUseRelations()) {
                        relations2 = this.getMealRelations(this.getMealId(), this.getPlaceID(), interval);
                        i = relations2.iterator();
                        tempRelation = null;
                        relChod = false;
                        mainChod = false;
                        auto = false;
                        subPocetHlavnich = 0;
                        countZavislost = 0;
                        while (i.hasNext()) {
                            tempRelation = i.next();
                            if (tempRelation.getRelationChod() == this.getMealId()) {
                                if (tempRelation.getPocetZavisly() + this.getMessIncrement() - subPocetHlavnich <= tempRelation.getPocetHlavni() * tempRelation.getCount()) {
                                    relChod = true;
                                }
                                subPocetHlavnich += tempRelation.getPocetHlavni() * tempRelation.getCount();
                            }
                            if (tempRelation.getMainChod() == this.getMealId()) {
                                if (tempRelation.getAuto()) {
                                    auto = true;
                                }
                                mainChod = true;
                            }
                            ++countZavislost;
                        }
                        if (countZavislost == 0) {
                            mainChod = true;
                        }
                        if (!relChod && !mainChod) {
                            this.setTempDisplayText("Z\u00e1visl\u00fd chod");
                            this.setMealBeep('F');
                            this.setInformationDisplayNM(true);
                            int n = -2;
                            return n;
                        }
                        if (mainChod && auto) {
                            if (this.checkCredit(this.getMessIncrement(), interval, tempRelation.getRelationChod()) == -3) {
                                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Neni kredit"));
                                this.setTempDisplayText("Nen\u00ed kredit");
                                this.setMealBeep('F');
                                this.setInformationDisplayNM(true);
                                int n = -2;
                                return n;
                            }
                            if (this.orderSpecifiedDay(interval, tempRelation.getRelationChod(), this.getMessIncrement()) == -1) {
                                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Nelze objednat"));
                                this.setTempDisplayText("Nelze objednat");
                                this.setMealBeep('F');
                                this.setInformationDisplayNM(false);
                                int n = -2;
                                return n;
                            }
                        }
                        i = null;
                        relations2.clear();
                        relations2 = null;
                    }
                    if (this.orderSpecifiedDay(interval, this.getMealId(), this.getMessIncrement()) == -1) {
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Nelze objednat"));
                        this.setTempDisplayText("Nelze objednat");
                        this.setMealBeep('F');
                        this.setInformationDisplayNM(false);
                        int n = -2;
                        return n;
                    }
                    LOGGER.info((Object)(this.getTerminalID() + " " + "***OBJEDNANO*** dni:" + interval + " | ChdId:" + this.getMealId() + " | kusu:" + this.getMessIncrement()));
                    this.setTempDisplayText("Objedn\u00e1no " + this.getMessIncrement() + "ks");
                    this.setInformationDisplayNM(true);
                    this.print = true;
                }
            }
            finally {
                cal = null;
            }
            return 1;
        }
        if (this.getStrReader().compareTo("81") == 0) {
            int echk = this.extendedPrimaryCheck();
            if (echk != 1) {
                if (echk == 0) {
                    this.getDisplay().nullDisplay();
                    this.setTempDisplayText("\u010cip nenalezen");
                    this.setMealBeep('F');
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getChipCode()), 1);
                } else {
                    this.setMealBeep('F');
                    this.setTempDisplayText("Chybn\u00fd povel");
                }
                this.setInformationDisplayNM(true);
                return echk;
            }
            if (this.getChipReadedForObjednavkaTerminal() != null) {
                this.setChipReadedForObjednavkaTerminal(null);
                this.decodeLastButtonTouched("00");
                this.nullData();
                LOGGER.info((Object)(this.getTerminalID() + " " + "***KONEC OBJEDNAVANI***"));
                this.setTempDisplayText("U\u017eivatel odhl\u00e1\u0161en");
                this.getDisplay().setLogout(true);
                return 1;
            }
            this.setChipReadedForObjednavkaTerminal(this.getChipCode());
            this.getCredit(this.getUser().getId());
            this.setTempDisplayText("Zvolte den");
            this.setInformationDisplayNM(true);
        }
        return 1;
    }

    protected void incrementNumberOfButtonTouched() {
        ++this.numberOfButtonTouched;
    }

    protected void setNumberOfButtonTouched(int num) {
        this.numberOfButtonTouched = num;
    }

    public int getNumberOfButtonTouched() {
        return this.numberOfButtonTouched;
    }

    protected void setDayOfWeek(int day) {
        this.dayOfWeek = day;
    }

    protected int getDayOfWeek() {
        return this.dayOfWeek;
    }

    protected int getMessIncrement() {
        return this.messIncrement + 1;
    }

    public void decodeLastButtonTouched(String lastButtonTouched) {
        if (lastButtonTouched.equalsIgnoreCase("00")) {
            this.setLastButtonTouched(0);
        }
        if (lastButtonTouched.equalsIgnoreCase("01")) {
            this.setLastButtonTouched(1);
        }
        if (lastButtonTouched.equalsIgnoreCase("02")) {
            this.setLastButtonTouched(2);
        }
        if (lastButtonTouched.equalsIgnoreCase("03")) {
            this.setLastButtonTouched(3);
        }
        if (lastButtonTouched.equalsIgnoreCase("04")) {
            this.setLastButtonTouched(4);
        }
        if (lastButtonTouched.equalsIgnoreCase("05")) {
            this.setLastButtonTouched(5);
        }
        if (lastButtonTouched.equalsIgnoreCase("06")) {
            this.setLastButtonTouched(6);
        }
        if (lastButtonTouched.equalsIgnoreCase("07")) {
            this.setLastButtonTouched(7);
        }
        if (lastButtonTouched.equalsIgnoreCase("0a")) {
            this.setLastButtonTouched(11);
        }
        if (lastButtonTouched.equalsIgnoreCase("0b")) {
            this.setLastButtonTouched(12);
        }
        if (lastButtonTouched.equalsIgnoreCase("0c")) {
            this.setLastButtonTouched(13);
        }
        if (lastButtonTouched.equalsIgnoreCase("0d")) {
            this.setLastButtonTouched(14);
        }
        if (lastButtonTouched.equalsIgnoreCase("0e")) {
            this.setLastButtonTouched(15);
        }
        if (lastButtonTouched.equalsIgnoreCase("0f")) {
            this.setLastButtonTouched(16);
        }
        if (lastButtonTouched.equalsIgnoreCase("1a")) {
            this.setLastButtonTouched(21);
        }
        if (lastButtonTouched.equalsIgnoreCase("1b")) {
            this.setLastButtonTouched(22);
        }
        if (lastButtonTouched.equalsIgnoreCase("1c")) {
            this.setLastButtonTouched(23);
        }
        if (lastButtonTouched.equalsIgnoreCase("1d")) {
            this.setLastButtonTouched(24);
        }
        if (lastButtonTouched.equalsIgnoreCase("1e")) {
            this.setLastButtonTouched(25);
        }
        if (lastButtonTouched.equalsIgnoreCase("1f")) {
            this.setLastButtonTouched(26);
        }
        if (lastButtonTouched.equalsIgnoreCase("2a")) {
            this.setLastButtonTouched(31);
        }
        if (lastButtonTouched.equalsIgnoreCase("2b")) {
            this.setLastButtonTouched(32);
        }
        if (lastButtonTouched.equalsIgnoreCase("2c")) {
            this.setLastButtonTouched(33);
        }
        if (lastButtonTouched.equalsIgnoreCase("2d")) {
            this.setLastButtonTouched(34);
        }
        if (lastButtonTouched.equalsIgnoreCase("2e")) {
            this.setLastButtonTouched(35);
        }
        if (lastButtonTouched.equalsIgnoreCase("2f")) {
            this.setLastButtonTouched(36);
        }
        if (lastButtonTouched.equalsIgnoreCase("7a")) {
            this.setLastButtonTouched(100);
        }
        lastButtonTouched = null;
    }

    protected int getDayIncrement() {
        if (this.getDayOfWeek() >= 1 && this.getDayOfWeek() <= 5) {
            return this.dayIncrement;
        }
        if (this.getDayOfWeek() >= 6 && this.getDayOfWeek() <= 7) {
            return this.dayIncrement / 2;
        }
        return 0;
    }

    protected int setObjednavkaTerminal() {
        switch (this.getLastButtonTouched()) {
            case 1: {
                this.setDayOfWeek(1);
                this.dayIncrement = this.getNumberOfButtonTouched();
                break;
            }
            case 2: {
                this.setDayOfWeek(2);
                this.dayIncrement = this.getNumberOfButtonTouched();
                break;
            }
            case 3: {
                this.setDayOfWeek(3);
                this.dayIncrement = this.getNumberOfButtonTouched();
                break;
            }
            case 4: {
                this.setDayOfWeek(4);
                this.dayIncrement = this.getNumberOfButtonTouched();
                break;
            }
            case 5: {
                this.setDayOfWeek(5);
                this.dayIncrement = this.getNumberOfButtonTouched();
                break;
            }
            case 6: {
                this.dayIncrement = this.getNumberOfButtonTouched();
                if (this.getNumberOfButtonTouched() % 2 == 0) {
                    this.setDayOfWeek(6);
                }
                if (this.getNumberOfButtonTouched() % 2 != 1) break;
                this.setDayOfWeek(7);
                break;
            }
            case 11: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 12: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 13: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 14: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 15: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 16: {
                return this.getLastButtonTouched();
            }
            case 21: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 22: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 23: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 24: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 25: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 26: {
                return this.getLastButtonTouched();
            }
            case 31: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 32: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 33: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 34: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 35: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 36: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 111: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 112: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 113: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 114: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 115: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 121: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 122: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 123: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 124: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 125: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 211: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 212: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 213: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 214: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 215: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 221: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 222: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 223: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 224: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            case 225: {
                this.setMessIncrement(this.getNumberOfButtonTouched());
                return this.getLastButtonTouched();
            }
            default: {
                return -2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserOrderes(int interval) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            stm.execute("SET NAMES 'utf8'");
            String sql = "select * from tobjednavky,tchody WHERE Stravnik_Id = " + this.getUser().getId() + " AND Vydejna_Id = " + this.getPlaceID() + " " + "AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND tchody.chod_id=tobjednavky.chod_id and tobjednavky.platne >= 0";
            rs = stm.executeQuery(sql);
            sql = null;
            rs.beforeFirst();
            int pocetZaznamu = 0;
            while (rs.next()) {
                ++pocetZaznamu;
            }
            rs.beforeFirst();
            String result = "";
            while (rs.next()) {
                if (rs.getInt("Kusu") > rs.getInt("VydanoKusu")) {
                    if (pocetZaznamu <= 1) {
                        result = result + "" + StringConvertor.latin1ToUTF(rs.getString("chodtxt")) + " " + rs.getInt("Kusu") + "ks;";
                        continue;
                    }
                    result = result + "" + rs.getString("ZkratkaChodu") + ":" + rs.getInt("Kusu") + ";";
                    continue;
                }
                if (pocetZaznamu <= 1) {
                    result = result + "" + StringConvertor.latin1ToUTF(rs.getString("chodtxt")) + " *Vy*;";
                    continue;
                }
                result = result + "" + rs.getString("ZkratkaChodu") + ":*Vy*;";
            }
            String string = result;
            return string;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPlaceName() {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM tvydejny WHERE Vydejna_Id = " + this.getPlaceID() + "");
            rs.beforeFirst();
            if (!rs.next()) {
                LOGGER.error((Object)("Nebyla nalezena vydejna id: " + this.getPlaceID()));
                String string = "";
                return string;
            }
            String string = rs.getString("VydejnaTxt");
            return string;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            String string = "";
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSummedOrders() {
        Statement stm = this.dbmanager.getStatement();
        ResultSet rs = null;
        try {
            String ret = "S: ";
            rs = stm.executeQuery("SELECT SUM(Kusu) as PocetObjednavekCelkem FROM tobjednavky WHERE stravnik_id=" + this.getUser().getId() + " and platne >= 0 GROUP BY stravnik_id");
            if (rs.next()) {
                ret = rs.getString("PocetObjednavekCelkem") == null ? ret + "0* " : ret + rs.getString("PocetObjednavekCelkem") + "* ";
                rs.close();
            } else {
                ret = ret + "0* ";
            }
            ret = ret + "B: ";
            rs = stm.executeQuery("SELECT SUM((Kusu-VydanoKusu)) as PocetObjednavekBude FROM tobjednavky WHERE stravnik_id=" + this.getUser().getId() + " AND VydanoKusu<Kusu AND datum>CURDATE() " + "GROUP BY stravnik_id");
            if (rs.next()) {
                ret = rs.getString("PocetObjednavekBude") == null ? ret + "0* " : ret + rs.getString("PocetObjednavekBude") + "* ";
                rs.close();
            } else {
                ret = ret + "0* ";
            }
            String string = StringConvertor.addWhiteSpacesTo16(ret);
            return string;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Nepodarilo se sumarizovat objednavky", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore) {}
            }
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    public void setMessIncrement(int messIncrement) {
        this.messIncrement = messIncrement;
    }

    public String getTerminalName() {
        return terminalName;
    }
}

