/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import universalrouter.database.SQLParam;
import universalrouter.terminals.TerminalBaseButton;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.MealOrder;
import universalrouter.util.StringConvertor;

public class TerminalMinutka
extends TerminalBaseButton
implements TerminalCommonInterface {
    private static final String terminalName = "Minutka";
    private final boolean noOutputType;

    public TerminalMinutka(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int id, int ra, String vol, boolean orderType) {
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.noOutputType = orderType;
        this.setMealOrder(new MealOrder(0, 0));
        this.setDisplay(new Display());
        this.setVolume(vol);
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setMealId(0);
            this.setUser(null);
            this.getMealOrder().setStatus(0);
            this.getDisplay().nullDisplay();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Chyba nulovani dat terminalu");
        }
    }

    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2 && this.isSignalFromDisplay()) {
            return smess;
        }
        this.setMealBeep('1');
        if (this.isSignalFromDisplay()) {
            this.decodeLastButtonTouched(this.getChipCode().substring(0, 2));
            if (this.getLastButtonTouched() == 0) {
                this.getDisplay().nullDisplay();
            } else {
                this.getMealOnButton();
                this.getDisplay().nullDisplay();
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo14(this.getTempDisplayText()) + '\u0010' + '0' + '1', 3);
            }
            return -2;
        }
        if (this.isSignalFromReader()) {
            int echk = this.extendedPrimaryCheck();
            if (echk != 1) {
                return echk;
            }
            if (this.getLastButtonTouched() == 0 || this.getLastButtonTouched() == 100) {
                this.hasUserOrdered(this.getChipID());
                switch (this.getMealOrder().getStatus()) {
                    case -1: {
                        this.setSegment((byte)0);
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || NEOBJEDNANO"));
                        this.setTempDisplayText("NEOBJEDN\u00c1NO");
                        this.setMealBeep('F');
                        this.setInformationDisplay();
                        return 0;
                    }
                    case -2: {
                        this.setSegment((byte)15);
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || Uz vydano"));
                        this.setTempDisplayText("U\u017e vyd\u00e1no");
                        this.setMealBeep('F');
                        this.setInformationDisplay();
                        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getMealOrder().getMealName()), 1);
                        return 0;
                    }
                    case -3: {
                        this.setSegment((byte)11);
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || Jiny terminal"));
                        this.setTempDisplayText("Jin\u00fd termin\u00e1l");
                        this.setMealBeep('F');
                        this.setInformationDisplay();
                        return 0;
                    }
                    case -99: {
                        this.setSegment((byte)29);
                        LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || Syst. chyba"));
                        this.setTempDisplayText("Syst. chyba");
                        this.setMealBeep('F');
                        this.setInformationDisplay();
                        return -1;
                    }
                }
                if (this.getMealOrder().getStatus() > 0) {
                    this.setInformationDisplay();
                    this.requestMeal(this.getMealOrder().getOrderNumber());
                    if (this.printer) {
                        try {
                            FileOutputStream os = new FileOutputStream(this.printerDevice);
                            PrintStream ps = new PrintStream(os);
                            ps.println("-----------------");
                            Calendar cal = Calendar.getInstance();
                            DateFormat df = DateFormat.getDateInstance(0);
                            ps.println(StringConvertor.internationalToEnglish(df.format(cal.getTime()) + " " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13)));
                            ps.println(StringConvertor.internationalToEnglish(this.getUser().getName() + " " + this.getUser().getId()));
                            ps.println(StringConvertor.internationalToEnglish(this.getTempDisplayText() + " 1 ks"));
                            ps.println("Denni suma: " + this.getDayMoney() + " Kc");
                            ps.println(". ");
                            ps.println(". ");
                            ps.println(". ");
                            ps.println(". ");
                            ps.println(". ");
                            ps.println(". ");
                            ps.close();
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"Nebylo mozne tisknout", (Throwable)e);
                        }
                    }
                    return 1;
                }
                this.setInformationDisplay();
                return 1;
            }
            if (this.getMealId() == 0) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Nevybrano jidlo"));
                this.setTempDisplayText("Zvolte chod");
                this.setSegment((byte)0);
                this.setMealBeep('F');
                this.setInformationDisplay();
                return 0;
            }
            int checkCredit = this.checkCredit(1, 0, this.getMealId());
            if (checkCredit == -3) {
                this.setSegment((byte)0);
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || Neni kredit"));
                this.setTempDisplayText("Nen\u00ed kredit");
                this.setMealBeep('F');
                this.setInformationDisplay();
                this.decodeLastButtonTouched("00");
                return 0;
            }
            if (checkCredit != 1 && checkCredit != -3) {
                this.setSegment((byte)0);
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || Neni stravnik"));
                this.setTempDisplayText("Nen\u00ed str\u00e1vn\u00edk");
                this.setMealBeep('F');
                this.setInformationDisplay();
                this.decodeLastButtonTouched("00");
                return 0;
            }
            if (this.gs.isCheckJidelnicek() && this.isSpecifiedJidelnicek(0, this.getMealId(), false) == -1) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Neni jidelnicek"));
                this.setTempDisplayText("Nen\u00ed j\u00eddeln\u00ed\u010dek");
                this.setSegment((byte)0);
                this.setMealBeep('F');
                this.setInformationDisplay();
                return -2;
            }
            if (this.getMealOnButton() != 1) {
                return -2;
            }
            if (this.isMealForUserForbidden(this.getMealId())) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Zakazany chod"));
                this.setTempDisplayText("Zak\u00e1zan\u00fd chod");
                this.setSegment((byte)0);
                this.setMealBeep('F');
                this.setInformationDisplay();
                this.decodeLastButtonTouched("00");
                return -2;
            }
            if (this.hasUserTypeOrdered(0, this.getMealId()) && this.getUser().isOnlyOneMessPerMeal() && !this.getUser().isHromadny()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* StrID: " + this.getUser().getId() + " || Jiz objednano"));
                this.setTempDisplayText("Ji\u017e objedn\u00e1no");
                this.setSegment((byte)35);
                this.setMealBeep('F');
                this.setInformationDisplay();
                this.decodeLastButtonTouched("00");
                return -2;
            }
            if (this.getOrderedMessesCount(0, this.getMealId()) >= this.getMaxMesses(0, this.getMealId())) {
                this.setSegment((byte)0);
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Min* StrID: " + this.getUser().getId() + " || Vycerpan limit"));
                this.setTempDisplayText("Vy\u010derp\u00e1n limit");
                this.setMealBeep('F');
                this.setInformationDisplay();
                this.decodeLastButtonTouched("00");
                return 0;
            }
            int ret = this.orderSpecifiedMinutes(0, this.getChipID(), this.getMealId());
            if (this.printer) {
                try {
                    FileOutputStream os = new FileOutputStream(this.printerDevice);
                    PrintStream ps = new PrintStream(os);
                    ps.println("-----------------");
                    Calendar cal = Calendar.getInstance();
                    DateFormat df = DateFormat.getDateInstance(0);
                    ps.println(StringConvertor.internationalToEnglish(df.format(cal.getTime()) + " " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13)));
                    ps.println(StringConvertor.internationalToEnglish(this.getUser().getName() + " " + this.getUser().getId()));
                    ps.println(StringConvertor.internationalToEnglish(this.getTempDisplayText() + " 1 ks"));
                    ps.println("Denni suma: " + this.getDayMoney() + " Kc");
                    ps.println(". ");
                    ps.println(". ");
                    ps.println(". ");
                    ps.println(". ");
                    ps.println(". ");
                    ps.println(". ");
                    ps.close();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Nebylo mozne tisknout", (Throwable)e);
                }
            }
            return ret;
        }
        return 1;
    }

    private void decodeLastButtonTouched(String lastButtonTouched) {
        if (lastButtonTouched.equalsIgnoreCase("00")) {
            this.setLastButtonTouched(0);
            this.setSegment((byte)16);
        }
        if (lastButtonTouched.equalsIgnoreCase("01")) {
            this.setLastButtonTouched(1);
            this.setSegment((byte)1);
        }
        if (lastButtonTouched.equalsIgnoreCase("02")) {
            this.setLastButtonTouched(2);
            this.setSegment((byte)2);
        }
        if (lastButtonTouched.equalsIgnoreCase("03")) {
            this.setLastButtonTouched(3);
            this.setSegment((byte)3);
        }
        if (lastButtonTouched.equalsIgnoreCase("04")) {
            this.setLastButtonTouched(4);
        }
        if (lastButtonTouched.equalsIgnoreCase("05")) {
            this.setLastButtonTouched(5);
        }
        if (lastButtonTouched.equalsIgnoreCase("06")) {
            this.setLastButtonTouched(6);
        }
        if (lastButtonTouched.equalsIgnoreCase("0a")) {
            this.setLastButtonTouched(11);
            this.setSegment((byte)4);
        }
        if (lastButtonTouched.equalsIgnoreCase("0b")) {
            this.setLastButtonTouched(12);
            this.setSegment((byte)5);
        }
        if (lastButtonTouched.equalsIgnoreCase("0c")) {
            this.setLastButtonTouched(13);
            this.setSegment((byte)6);
        }
        if (lastButtonTouched.equalsIgnoreCase("0d")) {
            this.setLastButtonTouched(14);
        }
        if (lastButtonTouched.equalsIgnoreCase("0e")) {
            this.setLastButtonTouched(15);
        }
        if (lastButtonTouched.equalsIgnoreCase("0f")) {
            this.setLastButtonTouched(16);
        }
        if (lastButtonTouched.equalsIgnoreCase("1a")) {
            this.setLastButtonTouched(21);
            this.setSegment((byte)7);
        }
        if (lastButtonTouched.equalsIgnoreCase("1b")) {
            this.setLastButtonTouched(22);
            this.setSegment((byte)8);
        }
        if (lastButtonTouched.equalsIgnoreCase("1c")) {
            this.setLastButtonTouched(23);
            this.setSegment((byte)9);
        }
        if (lastButtonTouched.equalsIgnoreCase("1d")) {
            this.setLastButtonTouched(24);
        }
        if (lastButtonTouched.equalsIgnoreCase("1e")) {
            this.setLastButtonTouched(25);
        }
        if (lastButtonTouched.equalsIgnoreCase("1f")) {
            this.setLastButtonTouched(26);
        }
        if (lastButtonTouched.equalsIgnoreCase("7a")) {
            this.setLastButtonTouched(100);
        }
        lastButtonTouched = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int orderSpecifiedMinutes(int interval, int chipCode, int mealid) {
        Statement stm = this.dbmanager.getStatement();
        try {
            int hasUserSpecifiedOrdered = this.hasUserSpecifiedOrdered(interval, mealid);
            if (hasUserSpecifiedOrdered > 1 && this.noOutputType) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik: " + this.getUser().getId() + " jiz ma objednavku " + interval + " dni dopredu."));
                stm.executeUpdate("UPDATE tobjednavky SET VydanoKusu=VydanoKusu+1, VydejPrvniDatum = CURDATE(), vydejPrvniCas = CURTIME(),VydejPosledniDatum = CURDATE(), vydejPosledniCas = CURTIME(), VydanoZdroj = 4 WHERE Objednavka_Id=" + hasUserSpecifiedOrdered);
            }
            if (hasUserSpecifiedOrdered < -1 && this.noOutputType && !this.getUser().isOnlyOneMessPerMeal()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik jiz ma objednavku " + interval + " dni dopredu."));
                stm.executeUpdate("UPDATE tobjednavky, tchody SET VydanoKusu=VydanoKusu+1, Kusu=Kusu+1, VydejPrvniDatum = CURDATE(), vydejPrvniCas = CURTIME(),VydejPosledniDatum = CURDATE(), vydejPosledniCas = CURTIME(), VydanoZdroj = 4 WHERE tchody.Chod_Id = tobjednavky.Chod_Id AND Objednavka_Id=" + -hasUserSpecifiedOrdered);
            }
            if (hasUserSpecifiedOrdered == -1) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik: " + this.getUser().getId() + " jeste nema na nasledujici den."));
                ArrayList<SQLParam> params = new ArrayList<SQLParam>();
                params.add(new SQLParam("Stravnik_Id", "" + this.getUser().getId(), "int"));
                params.add(new SQLParam("Vydejna_Id", "" + this.getPlaceID(), "int"));
                params.add(new SQLParam("Chod_Id", "" + mealid, "int"));
                LOGGER.info((Object)(this.getTerminalID() + " " + "Objednavam " + interval + " dni dopredu ChodId:" + mealid + "."));
                if (this.noOutputType) {
                    this.dbmanager.doPreparedStatement("INSERT into tobjednavky (Stravnik_Id, Jidelna_Id, Vydejna_Id, Datum, Chod_Id,Kusu, CasObj, ZdrojObj_Id, DatumObj, VydanoKusu, VydejPrvniDatum, VydejPosledniDatum, VydejPrvniCas, VydejPosledniCas, VydanoZdroj) VALUES (?,0,?,DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY)," + "?,1,CURTIME(),4,CURDATE(), 1,CURDATE(),CURDATE(),CURTIME(),CURTIME(), 4)", params);
                } else {
                    this.dbmanager.doPreparedStatement("INSERT into tobjednavky (Stravnik_Id, Jidelna_Id, Vydejna_Id, Datum, Chod_Id,Kusu, CasObj, ZdrojObj_Id, DatumObj) VALUES (?,0,?,DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY)," + "?,1,CURTIME(),4,CURDATE())", params);
                }
                params.clear();
                params = null;
            }
            if (!this.rewritePrices(interval)) {
                int n = -1;
                return n;
            }
            this.setInformationDisplay();
            this.decodeLastButtonTouched("00");
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    private double getDayMoney() throws SQLException {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        String getDayMoney = "select sum(ifnull(tobj.vydanokusu,0) * tcen.cena1vcetnedph) as celkem from tcenik as tcen left join tstravnici as ts on (ts.kategorie_id = tcen.kategorie_id) left join tobjednavky as tobj on (ts.stravnik_id = tobj.stravnik_id) and (tcen.chod_id = tobj.chod_id) left join tchody as tch on (tch.chod_id = tobj.chod_id) where  (tobj.datum = CURDATE()) and (((tobj.datum <=ts.platnostdo) or (ts.platnostdo is null) or (ts.platnostdo = \"0000-00-00\") ) and (tobj.datum >=ts.platnostod)) and ((tcen.platnostcenyod <= tobj.datum) and  ((tcen.platnostcenydo >= tobj.datum) or (tcen.platnostcenydo is null ))) and (tcen.pocetkusu = 1) and tobj.platne >= 0 and tobj.vydejna_id = " + this.getPlaceID();
        try {
            rs = stm.executeQuery(getDayMoney);
            if (rs.next()) {
                if (rs.getObject("celkem") != null) {
                    double d = rs.getDouble("celkem");
                    return d;
                }
                double d = 0.0;
                return d;
            }
            throw new SQLException("Nepodarilo se vypocitat denni sumu.");
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            getDayMoney = null;
            stm.close();
            stm = null;
        }
    }

    public String getTerminalName() {
        return terminalName;
    }
}

