/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import universalrouter.terminals.TerminalBase;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.MealOrder;
import universalrouter.util.StringConvertor;

public class TerminalInformacniNoLimit
extends TerminalBase
implements TerminalCommonInterface {
    private static final String terminalName = "NoLimit";

    public TerminalInformacniNoLimit(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setMealOrder(new MealOrder(0, 0));
        this.setDisplay(new Display());
        this.setVolume(vol);
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setUser(null);
            this.getMealOrder().setStatus(0);
            this.getDisplay().nullDisplay();
        }
        catch (Exception e) {
            LOGGER.fatal((Object)"!!!!! Chyba nulovani dat terminalu !!!!!");
        }
    }

    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2 && this.getStrReader().compareTo("01") == 0) {
            return smess;
        }
        int echk = this.extendedPrimaryCheck();
        if (echk != 1) {
            return echk;
        }
        this.hasUserOrdered(this.getChipID(), false, 0);
        switch (this.getMealOrder().getStatus()) {
            case -1: {
                this.setSegment((byte)0);
                this.setTempDisplayText("NEOBJEDN\u00c1NO");
                this.setInformationDisplay();
                return 0;
            }
            case -2: {
                this.setSegment((byte)15);
                this.setTempDisplayText("U\u017e vyd\u00e1no");
                this.setInformationDisplay();
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getMealOrder().getMealName()), 1);
                return 0;
            }
            case -3: {
                this.setSegment((byte)11);
                this.setTempDisplayText("Jin\u00fd termin\u00e1l");
                this.setInformationDisplay();
                return 0;
            }
            case -99: {
                this.setSegment((byte)29);
                this.setTempDisplayText("Syst. chyba");
                this.setInformationDisplay();
                return -1;
            }
        }
        if (this.getMealOrder().getStatus() > 0) {
            this.setInformationDisplay();
            return 1;
        }
        this.setInformationDisplay();
        return 1;
    }

    public String getTerminalName() {
        return terminalName;
    }
}

