/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import universalrouter.database.DBManager;
import universalrouter.database.SQLParam;
import universalrouter.terminals.TerminalBaseButton;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.termutils.TerminalData;
import universalrouter.util.StringConvertor;

public class TerminalDochazkaMarkTime
extends TerminalBaseButton
implements TerminalCommonInterface {
    private static final String terminalName = "MarkTime";
    private TerminalData terminalData;
    private int numberOfButtonTouched;
    private int state = 1;
    private int typPruchodu = 0;
    private DBManager dbMSSQL;
    private int userID;

    public TerminalDochazkaMarkTime(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int id, int ra, String vol) {
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.setDisplay(new Display());
        this.setVolume(vol);
        this.terminalData = new TerminalData();
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setMealId(0);
            this.numberOfButtonTouched = 0;
            this.typPruchodu = 0;
            this.setUser(null);
            this.userID = -1;
        }
        catch (Exception e) {
            System.out.println("Chyba nulovani dat terminalu");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2) {
            return smess;
        }
        if (this.getStrReader().compareTo("01") == 0) {
            if (this.getChipCode().substring(0, 2).compareTo("00") == 0) {
                this.nullData();
                this.getDisplay().setLogout(true);
                return -2;
            }
            int lbt = this.getLastButtonTouched();
            this.decodeLastButtonTouched(this.getChipCode().substring(0, 2));
            this.setNumberOfButtonTouched(0);
            this.state = this.getState();
            if (this.state == 0) {
                this.setTempDisplayText("P\u0159\u00edchod/odchod");
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 1);
            } else if (this.getTypeOnButtonFromMarkTime() != -1) {
                this.typPruchodu = this.getTypeOnButtonFromMarkTime();
            }
        }
        if (this.getStrReader().compareTo("81") == 0) {
            int echk = this.extendedPrimaryCheckForMarkTime();
            if (echk != 1) {
                this.setTempDisplayText("Chybn\u00fd povel");
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 1);
                return echk;
            }
            this.userID = this.getUserIDFromMarkTime();
            if (this.userID == -1) {
                this.setTempDisplayText("\u010cip nenalezen");
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 1);
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo14(this.getChipCode()), 2);
                return 0;
            }
            if (this.state == 0) {
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("P\u0159\u00edchod/odchod"), 1);
            } else {
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getUserNameFromMarkTime()), 1);
                ArrayList<SQLParam> params = new ArrayList<SQLParam>();
                params.add(new SQLParam("inOut", "" + this.state, "int"));
                params.add(new SQLParam("type_id", "" + this.typPruchodu, "int"));
                params.add(new SQLParam("chipCode", "" + this.getChipCode(), "string"));
                params.add(new SQLParam("user_id", "" + this.userID, "int"));
                try {
                    this.dbMSSQL.doPreparedStatement("INSERT into zw_commes (date, inOut, type_id, chipCode, user_id) VALUES (getdate(),?,?,?,?)", params);
                }
                catch (SQLException e) {
                }
                finally {
                    params.clear();
                    params = null;
                }
                this.nullData();
            }
        }
        return 1;
    }

    private void setNumberOfButtonTouched(int num) {
        this.numberOfButtonTouched = num;
    }

    private int getState() {
        switch (this.getLastButtonTouched()) {
            case 1: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        return this.state;
    }

    private void decodeLastButtonTouched(String lastButtonTouched) {
        if (lastButtonTouched.equalsIgnoreCase("00")) {
            this.setLastButtonTouched(0);
        }
        if (lastButtonTouched.equalsIgnoreCase("01")) {
            this.setLastButtonTouched(1);
        }
        if (lastButtonTouched.equalsIgnoreCase("02")) {
            this.setLastButtonTouched(2);
        }
        if (lastButtonTouched.equalsIgnoreCase("03")) {
            this.setLastButtonTouched(3);
        }
        if (lastButtonTouched.equalsIgnoreCase("04")) {
            this.setLastButtonTouched(4);
        }
        if (lastButtonTouched.equalsIgnoreCase("05")) {
            this.setLastButtonTouched(5);
        }
        if (lastButtonTouched.equalsIgnoreCase("06")) {
            this.setLastButtonTouched(6);
        }
        if (lastButtonTouched.equalsIgnoreCase("07")) {
            this.setLastButtonTouched(7);
        }
        if (lastButtonTouched.equalsIgnoreCase("0a")) {
            this.setLastButtonTouched(11);
        }
        if (lastButtonTouched.equalsIgnoreCase("0b")) {
            this.setLastButtonTouched(12);
        }
        if (lastButtonTouched.equalsIgnoreCase("0c")) {
            this.setLastButtonTouched(13);
        }
        if (lastButtonTouched.equalsIgnoreCase("0d")) {
            this.setLastButtonTouched(14);
        }
        if (lastButtonTouched.equalsIgnoreCase("0e")) {
            this.setLastButtonTouched(15);
        }
        if (lastButtonTouched.equalsIgnoreCase("0f")) {
            this.setLastButtonTouched(16);
        }
        if (lastButtonTouched.equalsIgnoreCase("1a")) {
            this.setLastButtonTouched(21);
        }
        if (lastButtonTouched.equalsIgnoreCase("1b")) {
            this.setLastButtonTouched(22);
        }
        if (lastButtonTouched.equalsIgnoreCase("1c")) {
            this.setLastButtonTouched(23);
        }
        if (lastButtonTouched.equalsIgnoreCase("1d")) {
            this.setLastButtonTouched(24);
        }
        if (lastButtonTouched.equalsIgnoreCase("1e")) {
            this.setLastButtonTouched(25);
        }
        if (lastButtonTouched.equalsIgnoreCase("1f")) {
            this.setLastButtonTouched(26);
        }
        if (lastButtonTouched.equalsIgnoreCase("2a")) {
            this.setLastButtonTouched(31);
        }
        if (lastButtonTouched.equalsIgnoreCase("2b")) {
            this.setLastButtonTouched(32);
        }
        if (lastButtonTouched.equalsIgnoreCase("2c")) {
            this.setLastButtonTouched(33);
        }
        if (lastButtonTouched.equalsIgnoreCase("2d")) {
            this.setLastButtonTouched(34);
        }
        if (lastButtonTouched.equalsIgnoreCase("2e")) {
            this.setLastButtonTouched(35);
        }
        if (lastButtonTouched.equalsIgnoreCase("2f")) {
            this.setLastButtonTouched(36);
        }
        if (lastButtonTouched.equalsIgnoreCase("7a")) {
            this.setLastButtonTouched(100);
        }
        lastButtonTouched = null;
    }

    private String getStateStringValue(int stVal) {
        switch (stVal) {
            case 1: {
                return ">>\u00a0Prichod";
            }
            case 2: {
                return "Odchod >>";
            }
        }
        return "! Neznamy !";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTypeStringValueFromMarkTime(int btn) {
        ResultSet rs = null;
        Statement stm = this.dbMSSQL.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM zw_types WHERE type_id =" + btn);
            if (rs.next()) {
                String string = rs.getString("typeText");
                return string;
            }
            LOGGER.info((Object)("Neexistuje platn\u00e9 propojen\u00ed s MarkTimem " + btn));
            String string = "Neznamy";
            return string;
        }
        catch (SQLException e) {
            LOGGER.warn((Object)"Chyba pri parovani tlacitka s typem pruchodu. Pravdepodobne neni nastaveno");
            String string = "";
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTypeOnButtonFromMarkTime() {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM rtr_buttons WHERE terminal_id =" + this.getTerminalID() + " AND" + " button =" + this.getLastButtonTouched());
            rs.beforeFirst();
            if (!rs.next()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Neni nadefinovana zadna akce na tlacitku " + this.getLastButtonTouched()));
                int n = -1;
                return n;
            }
            int n = rs.getInt("meal_id");
            return n;
        }
        catch (SQLException e) {
            LOGGER.warn((Object)"Chyba pri parovani tlacitka s typem pruchodu. Pravdepodobne neni nastaveno");
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserNameFromMarkTime() {
        ResultSet rs = null;
        Statement stm = this.dbMSSQL.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM j03user WHERE j03chipcode = '" + this.getChipCode() + "'");
            if (rs.next()) {
                String string = rs.getString("j03Name");
                return string;
            }
            LOGGER.info((Object)("Nebyl nalezen \u017e\u00e1dn\u00fd u\u017eivatel s t\u00edmto \u010dipem " + this.getChipCode()));
            String string = "";
            return string;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            String string = "";
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserIDFromMarkTime() {
        ResultSet rs = null;
        Statement stm = this.dbMSSQL.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM j03user WHERE upper(j03chipcode) = upper('" + this.getChipCode() + "')");
            if (rs.next()) {
                int n = rs.getInt("j03ID");
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.info((Object)("Nebyl nalezen \u017e\u00e1dn\u00fd u\u017eivatel s t\u00edmto \u010dipem " + this.getChipCode() + " " + ex));
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    public String getTerminalName() {
        return terminalName;
    }
}

