/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import universalrouter.comm.GlobalSetting;
import universalrouter.database.DBManager;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.user.User;

public abstract class TerminalCommonModel
implements TerminalCommonInterface {
    protected String printerDevice = "/dev/lp0";
    protected int resetLockedTerminalAfter = 20;
    protected int adress;
    protected int type;
    private boolean hasAnswer = false;
    private boolean lock = false;
    protected int lockedCycles = 0;
    protected int placeID;
    private User user = null;
    private String volume = "-1";
    private boolean requestOldData = false;
    private byte[] commByte = null;
    private long lastClockSetTime;
    protected boolean hasTerminalGraphicalDisplay;
    private Display display;
    private byte segment = 0;
    private char mealBeep;
    private byte beepLength;
    private String strReader;
    private String chipCode;
    private int chipID = 0;
    protected int sourceAdress;
    protected int terminal_id;
    protected DBManager dbmanager;
    protected GlobalSetting gs;
    protected boolean printer = false;
    private boolean sendVersion = true;

    public void setUser(User user) {
        this.user = null;
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public int getAdress() {
        return this.adress;
    }

    public void setHasAnswer(boolean ans) {
        this.hasAnswer = ans;
    }

    public boolean getHasAnswer() {
        return this.hasAnswer;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getCommByte() {
        return this.commByte;
    }

    public void setCommByte(byte[] commOrder) {
        this.commByte = commOrder;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public boolean getLock() {
        return this.lock;
    }

    public int getLockedCycles() {
        return this.lockedCycles;
    }

    public void addCycles() {
        if (this.lockedCycles > this.resetLockedTerminalAfter) {
            this.lockedCycles = 0;
            this.lock = false;
        } else {
            ++this.lockedCycles;
        }
    }

    public void setResetAfter(int ra) {
        this.resetLockedTerminalAfter = ra;
    }

    public void setLastClockSetTime(long timeInMillis) {
        this.lastClockSetTime = timeInMillis;
    }

    public long getLastClockSetTime() {
        return this.lastClockSetTime;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setSegment(byte seg) {
        this.segment = seg;
    }

    public byte getSegment() {
        return this.segment;
    }

    public boolean getHasTerminalDisplay() {
        return this.hasTerminalGraphicalDisplay;
    }

    public void setRequestOldData(boolean rqOldData) {
        this.requestOldData = rqOldData;
    }

    public boolean getRequestOldData() {
        return this.requestOldData;
    }

    public void setMealBeep(char num) {
        this.mealBeep = num;
    }

    public char getMealBeep() {
        return this.mealBeep;
    }

    public void setVolume(String vol) {
        this.volume = vol;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setBeepLength(byte bl) {
        this.beepLength = bl;
    }

    public byte getBeepLength() {
        return this.beepLength;
    }

    public void setStrReader(String reader) {
        this.strReader = reader;
    }

    public String getStrReader() {
        return this.strReader;
    }

    public boolean isSignalFromDisplay() {
        return this.getStrReader().compareTo("01") == 0;
    }

    public boolean isSignalFromReader() {
        return this.getStrReader().compareTo("81") == 0;
    }

    public void setChipCode(String cc) {
        this.chipCode = cc;
    }

    public String getChipCode() {
        return this.chipCode;
    }

    public void setChipID(int id) {
        this.chipID = id;
    }

    public int getChipID() {
        return this.chipID;
    }

    public void setSourceAddress(int src) {
        this.sourceAdress = src;
    }

    public int getSourceAdress() {
        return this.sourceAdress;
    }

    public int getTerminalID() {
        return this.terminal_id;
    }

    public int getPlaceID() {
        return this.placeID;
    }

    public void setGlobalSetting(GlobalSetting globalSetting) {
        this.gs = globalSetting;
    }

    public void setDBManager(DBManager db) {
        this.dbmanager = db;
    }

    public void setPrinter(boolean printer, String printerDevice) {
        this.printer = printer;
        this.printerDevice = printerDevice;
    }

    public boolean isSendVersion() {
        return this.sendVersion;
    }

    public void setSendVersion(boolean sendVersion) {
        this.sendVersion = sendVersion;
    }
}

