/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import universalrouter.comm.OrderLimit;
import universalrouter.database.SQLParam;
import universalrouter.terminals.NoSuchButton;
import universalrouter.terminals.TerminalBaseObjednavka;
import universalrouter.termutils.Display;
import universalrouter.user.Vydejna;
import universalrouter.util.StringConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalClassicalServery
extends TerminalBaseObjednavka {
    private static final String TERMINAL_NAME = "Policie";
    private static int MAX_SYMBOLS = 12;
    private int vydejnaId;
    private int chodId;
    private int chodNumber;
    Calendar composeCalendar;
    protected int impliciteWeek;
    protected int weekNumber;
    protected int requestedDayNumber;
    protected String[][] chodSymbol;
    protected String configuration;
    protected int numberOfButtonTouched;

    public TerminalClassicalServery(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int impliciteWeek, int id, int ra, String vol, String configuration) {
        this.weekNumber = this.impliciteWeek = 0;
        this.numberOfButtonTouched = 0;
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.impliciteWeek = impliciteWeek;
        this.weekNumber = impliciteWeek % 10;
        this.configuration = configuration;
        this.setDisplay(new Display());
        this.setVolume(vol);
        this.requestedDayNumber = this.computeRequestedDayNumber();
    }

    @Override
    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setMealId(0);
            this.setUser(null);
            this.vydejnaId = 0;
            this.setChipReadedForObjednavkaTerminal(null);
            this.getDisplay().nullDisplay();
            this.weekNumber = this.impliciteWeek % 10;
            this.numberOfButtonTouched = 0;
            this.init();
            this.requestedDayNumber = this.computeRequestedDayNumber();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Chyba nulovani dat terminalu", (Throwable)e);
        }
    }

    @Override
    public void init() {
        if (this.getUser() != null) {
            this.vydejnaId = this.getUser().getVydejna();
        }
        this.chodSymbol = new String[MAX_SYMBOLS][4];
        this.chodSymbol[0][0] = "S";
        this.chodSymbol[3][0] = "O";
        this.chodSymbol[6][0] = "V";
        this.chodSymbol[9][0] = "X";
        this.chodSymbol[0][2] = "disable";
        this.chodSymbol[3][2] = "enable";
        this.chodSymbol[6][2] = "disable";
        this.chodSymbol[9][2] = "disable";
        StringTokenizer tempStringTokenizer = new StringTokenizer(this.configuration);
        for (int i = 0; tempStringTokenizer.hasMoreTokens() && i < MAX_SYMBOLS; i += 3) {
            this.chodSymbol[i][0] = tempStringTokenizer.nextToken(",");
            this.chodSymbol[i][2] = this.getUser() != null ? (this.chodSymbol[i][0].equalsIgnoreCase("X") || !this.existsCenik(this.chodSymbol[i][0]) ? "disable" : "enable") : (this.chodSymbol[i][0].equalsIgnoreCase("X") ? "disable" : "enable");
        }
        this.init("true", "true", "true", "true");
        this.composeCalendar = Calendar.getInstance();
        if (!this.gs.isWeekends()) {
            if (this.composeCalendar.get(7) == 7) {
                this.composeCalendar.add(7, 2);
                this.requestedDayNumber = 1;
            } else if (this.composeCalendar.get(7) == 1) {
                this.composeCalendar.add(7, 1);
                this.requestedDayNumber = 1;
            }
        }
    }

    private void init(String sn, String sd, String ob, String so) {
        this.chodSymbol[0][1] = sn;
        this.chodSymbol[3][1] = sd;
        this.chodSymbol[6][1] = ob;
        this.chodSymbol[9][1] = so;
    }

    @Override
    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2 && this.getStrReader().compareTo("01") == 0) {
            return smess;
        }
        if (this.getStrReader().compareTo("01") == 0) {
            try {
                this.decodeLastButtonTouched(this.getChipCode().substring(0, 2));
            }
            catch (NoSuchButton ex) {
                return -2;
            }
            if (this.getLastButtonTouched() == 0) {
                this.nullData();
                this.getDisplay().setLogout(true);
                return -2;
            }
            if (this.getChipReadedForObjednavkaTerminal() == null) {
                this.getDisplay().setClear(true);
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Prilozte cip!"), 6);
                return -2;
            }
            if (this.getLastButtonTouched() >= 1 && this.getLastButtonTouched() <= 6) {
                Calendar cal = Calendar.getInstance();
                cal.add(7, this.getTimeInterval());
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.");
                String formatedDate = formatter.format(cal.getTime());
                this.setTempDisplayText(StringConvertor.addWhiteSpacesTo16(formatedDate + " " + StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())) + "Kc"));
            }
            if (this.getLastButtonTouched() == 15 && !this.getUser().isFixVydejna()) {
                if ("true".equalsIgnoreCase(this.chodSymbol[0][1]) && "enable".equalsIgnoreCase(this.chodSymbol[0][2])) {
                    return this.switchVydejna(0, this.getAllowedVydejnaForSymbol(this.chodSymbol[0][0], this.chodNumber));
                }
                return -2;
            }
            if (this.getLastButtonTouched() == 25 && !this.getUser().isFixVydejna()) {
                if ("true".equalsIgnoreCase(this.chodSymbol[3][1]) && "enable".equalsIgnoreCase(this.chodSymbol[3][2])) {
                    return this.switchVydejna(3, this.getAllowedVydejnaForSymbol(this.chodSymbol[3][0], this.chodNumber));
                }
                return -2;
            }
            if (this.getLastButtonTouched() == 35 && !this.getUser().isFixVydejna()) {
                if ("true".equalsIgnoreCase(this.chodSymbol[6][1]) && "enable".equalsIgnoreCase(this.chodSymbol[6][2])) {
                    return this.switchVydejna(6, this.getAllowedVydejnaForSymbol(this.chodSymbol[6][0], this.chodNumber));
                }
                return -2;
            }
            int interval = this.getTimeInterval();
            if (this.getLastButtonTouched() == 11) {
                if ("true".equalsIgnoreCase(this.chodSymbol[0][1]) && "enable".equalsIgnoreCase(this.chodSymbol[0][2])) {
                    return this.cancelLocal(this.chodSymbol[0][0], interval, this.getVydejnaId(this.chodSymbol[0][3]));
                }
                return -2;
            }
            if (this.getLastButtonTouched() == 21) {
                if ("true".equalsIgnoreCase(this.chodSymbol[3][1]) && "enable".equalsIgnoreCase(this.chodSymbol[3][2])) {
                    return this.cancelLocal(this.chodSymbol[3][0], interval, this.getVydejnaId(this.chodSymbol[3][3]));
                }
                return -2;
            }
            if (this.getLastButtonTouched() == 31) {
                if ("true".equalsIgnoreCase(this.chodSymbol[6][1]) && "enable".equalsIgnoreCase(this.chodSymbol[6][2])) {
                    return this.cancelLocal(this.chodSymbol[6][0], interval, this.getVydejnaId(this.chodSymbol[6][3]));
                }
                return -2;
            }
            if (this.getLastButtonTouched() > 11 && this.getLastButtonTouched() < 15) {
                if ("true".equalsIgnoreCase(this.chodSymbol[0][1]) && "enable".equalsIgnoreCase(this.chodSymbol[0][2])) {
                    return this.checkOrder(this.chodSymbol[0][0], interval, this.getVydejnaId(this.chodSymbol[0][3]));
                }
                return -2;
            }
            if (this.getLastButtonTouched() > 21 && this.getLastButtonTouched() < 25) {
                if ("true".equalsIgnoreCase(this.chodSymbol[3][1]) && "enable".equalsIgnoreCase(this.chodSymbol[3][2])) {
                    return this.checkOrder(this.chodSymbol[3][0], interval, this.getVydejnaId(this.chodSymbol[3][3]));
                }
                return -2;
            }
            if (this.getLastButtonTouched() > 31 && this.getLastButtonTouched() < 35) {
                if ("true".equalsIgnoreCase(this.chodSymbol[6][1]) && "enable".equalsIgnoreCase(this.chodSymbol[6][2])) {
                    return this.checkOrder(this.chodSymbol[6][0], interval, this.getVydejnaId(this.chodSymbol[6][3]));
                }
                return -2;
            }
            this.refreshDisplayOrders(false);
            if (this.getTempDisplayText() != null) {
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 8);
            }
        }
        if (this.getStrReader().compareTo("81") == 0) {
            int echk = this.extendedPrimaryCheck();
            if (echk != 1) {
                if (echk == 0) {
                    String chipCode = this.getChipCode();
                    this.nullData();
                    this.getDisplay().nullDisplay();
                    this.setTempDisplayText("Cip nenalezen");
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(chipCode), 1);
                } else {
                    this.nullData();
                    this.setTempDisplayText("Chybny povel");
                }
                this.setInformationDisplayNM(true);
                return echk;
            }
            if (this.getChipReadedForObjednavkaTerminal() != null) {
                this.setChipReadedForObjednavkaTerminal(null);
                try {
                    this.decodeLastButtonTouched("00");
                }
                catch (NoSuchButton ex) {
                    return -2;
                }
                this.nullData();
                this.setTempDisplayText("Uzivatel odhlasen");
                this.getDisplay().setLogout(true);
                return 1;
            }
            this.setChipReadedForObjednavkaTerminal(this.getChipCode());
            this.init();
            this.refreshDisplayOrders(true);
        }
        return 1;
    }

    private int getTimeInterval() {
        int interval = 0;
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
        interval = this.requestedDayNumber - currentDayOfWeek + this.weekNumber * 7;
        return interval;
    }

    protected void refreshWeeks(Calendar weekCalendar) {
        if (this.weekNumber == 0) {
            this.setTempDisplayText("Tento tyden");
        } else if (this.weekNumber == 1) {
            this.setTempDisplayText("Pristi tyden");
        } else {
            this.setTempDisplayText("Tyden " + weekCalendar.get(5) + ". " + (weekCalendar.get(2) + 1) + ". ");
        }
    }

    protected int checkOrder(String symbolChodu, int interval, int vydejna) {
        int result = 0;
        LOGGER.debug((Object)"Kontroluji jidelnicky");
        if (this.gs.isCheckJidelnicek() && this.isSpecifiedJidelnicek(interval, this.chodId, true) == -1) {
            this.setTempDisplayText("Neni jidelnicek");
            result = -2;
        }
        LOGGER.debug((Object)"Kontroluji limity");
        if (this.gs.isCheckJidelnicek() && this.getOrderedMessesCount(interval, this.chodId) >= this.getMaxMesses(interval, this.chodId)) {
            this.setTempDisplayText("Vycerpan limit");
            result = -2;
        }
        LOGGER.debug((Object)"Kontroluji casy");
        Calendar cal = Calendar.getInstance();
        cal.add(7, interval);
        OrderLimit limit = this.getLimit(this.chodId, vydejna, interval);
        if (limit == null || limit.isLimitTimeOrderExceeded(cal.getTime(), this.gs.isWeekends())) {
            this.setTempDisplayText("Po limitu");
            result = -2;
        }
        if (this.isForbidenOrder(interval, symbolChodu)) {
            LOGGER.debug((Object)"Snaha o zruseni hvezdicky, nebude povoleno.");
            result = -2;
        }
        LOGGER.debug((Object)"Odhlasuji predchozi objednavky");
        if (result == 0) {
            this.cancelLocal(symbolChodu, interval, vydejna);
        }
        LOGGER.debug((Object)"Kontroluji kredit");
        if (result == 0 && this.checkCredit(1, interval, this.chodId) == -3) {
            this.setTempDisplayText("Neni kredit");
            result = -2;
        }
        LOGGER.debug((Object)"Zapisuji objednavky");
        if (result == 0) {
            result = this.makeOrder(interval, this.chodId, vydejna);
            this.setTempDisplayText(StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())) + " Kc");
        }
        this.refreshDisplayOrders(false);
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 8);
        return result;
    }

    private int cancelLocal(String symbol, int interval, int vydejna) {
        Calendar cal = Calendar.getInstance();
        cal.add(7, interval);
        int result = 0;
        OrderLimit limit = this.getLimit(this.getMealId(symbol, -1), vydejna, interval);
        if (limit == null || limit.isLimitTimeCancelExceeded(cal.getTime(), this.gs.isWeekends())) {
            this.setTempDisplayText("Po limitu");
            result = -2;
        } else {
            int orderId = this.hasUserOrderedWithoutVydejna(interval, symbol, -1);
            if (orderId > 0) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "***ZRUSENO*** dni:" + interval + " | ChdId:" + this.getMealId()));
                result = this.deleteOrder(interval, orderId);
                this.setTempDisplayText(StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())) + " Kc");
            } else {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* StrID: " + this.getUser().getId() + " || Nelze zrusit"));
                this.setTempDisplayText("Nelze zrusit");
                this.setMealBeep('F');
                result = -2;
            }
        }
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 8);
        this.refreshDisplayOrders(false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOrder(int interval, int orderId) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            stm.executeUpdate("DELETE FROM tobjednavky WHERE objednavka_id = " + orderId + " " + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY)" + " AND platne >= 0 AND VydanoKusu = 0 AND kusu > 0");
            if (!this.rewritePrices(interval)) {
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
            }
            catch (NullPointerException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {
            }
            catch (NullPointerException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeOrder(int interval, int chodId, int vydejna) {
        Statement stm = this.dbmanager.getStatement();
        try {
            LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik jeste nema na nasledujici den."));
            ArrayList<SQLParam> params = new ArrayList<SQLParam>();
            params.add(new SQLParam("Stravnik_Id", "" + this.getUser().getId(), "int"));
            params.add(new SQLParam("Vydejna_Id", "" + vydejna, "int"));
            params.add(new SQLParam("Chod_Id", "" + chodId, "int"));
            this.dbmanager.doPreparedStatement("INSERT into tobjednavky (Stravnik_Id, Jidelna_Id, Vydejna_Id, Datum, Chod_Id,Kusu, CasObj, ZdrojObj_Id, DatumObj) VALUES (?,0,?,DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY)," + "?,1,CURTIME(),4,CURDATE()) ON DUPLICATE KEY UPDATE kusu=1", params);
            params.clear();
            params = null;
            LOGGER.debug((Object)"Prepocitavam kusy");
            if (!this.rewritePrices(interval)) {
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    protected void refreshDisplayOrders(boolean lastLine) {
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(TerminalClassicalServery.getDayName(this.getWeekIncrement(this.composeCalendar.get(7), true)) + ": " + this.composeDayOrders(this.getTimeInterval() + this.getWeekIncrement(this.composeCalendar.get(7), false), true)), 3);
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(TerminalClassicalServery.getDayName(this.getWeekIncrement(this.composeCalendar.get(7) + 1, true)) + ": " + this.composeDayOrders(1 + this.getTimeInterval() + this.getWeekIncrement(this.composeCalendar.get(7) + 1, false), false)), 6);
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(TerminalClassicalServery.getDayName(this.getWeekIncrement(this.composeCalendar.get(7) + 2, true)) + ": " + this.composeDayOrders(2 + this.getTimeInterval() + this.getWeekIncrement(this.composeCalendar.get(7) + 2, false), false)), 7);
        if (lastLine) {
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(StringConvertor.internationalToEnglish(this.getUser().getName())), 8);
        }
    }

    private int getWeekIncrement(int day, boolean alsoIncrement) {
        if (!(day != 0 && day != 1 && day != 7 && day != 8 || this.gs.isWeekends())) {
            return alsoIncrement ? day + 2 : 2;
        }
        return alsoIncrement ? day + 0 : 0;
    }

    private static String getDayName(int day) {
        switch (day) {
            case 0: {
                return "So";
            }
            case 1: {
                return "Ne";
            }
            case 2: {
                return "Po";
            }
            case 3: {
                return "Ut";
            }
            case 4: {
                return "St";
            }
            case 5: {
                return "Ct";
            }
            case 6: {
                return "Pa";
            }
            case 7: {
                return "So";
            }
            case 8: {
                return "Ne";
            }
            case 9: {
                return "Po";
            }
            case 10: {
                return "Ut";
            }
            case 11: {
                return "St";
            }
        }
        return "XX";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isForbidenOrder(int interval, String symbol) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT CisloChodu, SymbolTerminalu, VybranySymbol, VydanoKusu FROM tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE stravnik_id=" + this.getUser().getId() + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "AND vydejna_id = " + this.getPlaceID() + " AND Kusu = 0 AND Platne >= 0 AND SymbolTerminalu = '" + symbol + "' " + "ORDER BY PoradiChodu, CisloChodu");
            rs.beforeFirst();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String composeDayOrders(int interval, boolean setVydejna) {
        int i;
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        char[] ret = new char[MAX_SYMBOLS];
        for (i = 0; i < MAX_SYMBOLS; i += 3) {
            if ("enable".equals(this.chodSymbol[i][2])) {
                List<Vydejna> vydejny = this.getAllowedVydejnaForSymbol(this.chodSymbol[i][0], -1);
                if (vydejny.size() > 0) {
                    ret[i] = 48;
                    if (this.chodSymbol[i][3] == null) {
                        this.chodSymbol[i][3] = vydejny.get(0).getVydejnaZkratka();
                    }
                    ret[i + 1] = this.chodSymbol[i][3].charAt(0);
                    ret[i + 2] = 32;
                    continue;
                }
                ret[i] = 32;
                ret[i + 1] = 32;
                ret[i + 2] = 32;
                continue;
            }
            ret[i] = 32;
            ret[i + 1] = 32;
            ret[i + 2] = 32;
        }
        try {
            rs = stm.executeQuery("SELECT Kusu, CisloChodu, SymbolTerminalu, VybranySymbol, VydanoKusu, ZkrV FROM tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id LEFT JOIN tvydejny ON tobjednavky.vydejna_id = tvydejny.vydejna_id WHERE stravnik_id=" + this.getUser().getId() + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "AND Platne >= 0 " + "ORDER BY PoradiChodu, CisloChodu");
            rs.beforeFirst();
            while (rs.next()) {
                for (i = 0; i < MAX_SYMBOLS; i += 3) {
                    if (!rs.getString("SymbolTerminalu").equalsIgnoreCase(this.chodSymbol[i][0])) continue;
                    if (rs.getInt("Kusu") == 0) {
                        ret[i] = 42;
                        ret[i + 1] = rs.getString("ZkrV").charAt(0);
                        continue;
                    }
                    if (rs.getInt("VydanoKusu") > 0) {
                        ret[i] = rs.getString("VybranySymbol").charAt(0);
                        ret[i + 1] = rs.getString("ZkrV").charAt(0);
                    } else {
                        ret[i] = rs.getString("CisloChodu").charAt(0);
                        ret[i + 1] = rs.getString("ZkrV").charAt(0);
                    }
                    if (!setVydejna) continue;
                    this.chodSymbol[i][3] = rs.getString("ZkrV");
                }
            }
            String i2 = new String(ret);
            return i2;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            ret = null;
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Vydejna> getAllowedVydejnaForSymbol(String symbol, int chodNumber) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        ArrayList<Vydejna> vydejny = new ArrayList<Vydejna>();
        try {
            String sql = "SELECT DISTINCT vydejna_id, ZkrV, vydejnaTxt FROM rtr_sablony JOIN tvydejny ON rtr_sablony.id_misto = tvydejny.vydejna_id JOIN tchody ON rtr_sablony.variant = tchody.chod_id WHERE (id_kategorie is null OR id_kategorie = 0 OR id_kategorie = " + this.getUser().getKategorie() + ") AND " + "platiOd <= CURDATE() AND (platiDo >= CURDATE() or platiDo is null) ";
            if (chodNumber > 0) {
                sql = sql + "AND CisloChodu = " + chodNumber + " ";
            }
            sql = sql + " AND SymbolTerminalu = '" + symbol + "'";
            rs = stm.executeQuery(sql);
            rs.beforeFirst();
            while (rs.next()) {
                vydejny.add(new Vydejna(rs.getInt("vydejna_Id"), rs.getString("ZkrV"), rs.getString("VydejnaTxt")));
            }
            ArrayList<Vydejna> arrayList = vydejny;
            return arrayList;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            List<Vydejna> list = null;
            return list;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int hasUserOrderedWithoutVydejna(int interval, String symbol, int number) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "select * from tobjednavky JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE Stravnik_Id = " + this.getUser().getId() + " " + "AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND platne >= 0 " + "AND symbolTerminalu = '" + symbol + "' ";
            if (number > 0) {
                sql = sql + " AND cisloChodu = " + number;
            }
            rs = stm.executeQuery(sql);
            sql = null;
            if (!rs.next()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik StrId:" + this.getUser().getId() + " nema objednavku na vydejne" + " VydId:" + this.vydejnaId + " " + interval + " dni dopredu"));
                int n = -1;
                return n;
            }
            if (rs.getInt("Kusu") > rs.getInt("VydanoKusu")) {
                int n = rs.getInt("Objednavka_Id");
                return n;
            }
            int n = -rs.getInt("Objednavka_Id");
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)(this.getTerminalID() + "Chyba v SQL dotazu. Prosim overte jeho spravnost."), (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int switchVydejna(int poradiNastaveniChodu, List<Vydejna> vydejny) {
        String vydejnaName = "";
        boolean seted = false;
        for (int i = 0; i < vydejny.size(); ++i) {
            if (vydejny.get(i).getVydejnaId() != this.vydejnaId || vydejny.size() <= i + 1) continue;
            this.vydejnaId = vydejny.get(i + 1).getVydejnaId();
            vydejnaName = vydejny.get(i + 1).getVydejnaName();
            this.chodSymbol[poradiNastaveniChodu][3] = vydejny.get(i + 1).getVydejnaZkratka();
            seted = true;
            break;
        }
        if (!seted) {
            this.vydejnaId = vydejny.get(0).getVydejnaId();
            vydejnaName = vydejny.get(0).getVydejnaName();
            this.chodSymbol[poradiNastaveniChodu][3] = vydejny.get(0).getVydejnaZkratka();
        }
        Calendar cal = Calendar.getInstance();
        cal.add(7, this.getTimeInterval());
        int result = 0;
        OrderLimit limit = this.getLimit(this.getMealId(this.chodSymbol[poradiNastaveniChodu][0], -1), this.vydejnaId, this.getTimeInterval());
        if (limit == null || limit.isLimitTimeOrderExceeded(cal.getTime(), this.gs.isWeekends())) {
            this.setTempDisplayText("Po limitu");
            result = -2;
        } else {
            Statement stm = this.dbmanager.getStatement();
            int objednavkaId = this.hasUserOrderedWithoutVydejna(this.getTimeInterval(), this.chodSymbol[poradiNastaveniChodu][0], -1);
            if (objednavkaId > 0) {
                try {
                    String sql = "UPDATE tobjednavky set Vydejna_Id = " + this.vydejnaId + " WHERE Objednavka_id = " + objednavkaId;
                    stm.execute(sql);
                    this.setTempDisplayText(StringConvertor.internationalToEnglish(vydejnaName));
                    result = 1;
                }
                catch (SQLException ex) {
                    LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
                    result = -99;
                }
                finally {
                    try {
                        stm.close();
                    }
                    catch (SQLException e) {}
                    stm = null;
                }
            } else if (objednavkaId == -1) {
                this.setTempDisplayText(StringConvertor.internationalToEnglish(vydejnaName));
            } else {
                this.setTempDisplayText("Nelze zmenit");
            }
        }
        this.refreshDisplayOrders(false);
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 8);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void decodeLastButtonTouched(String lastButtonTouched) throws NoSuchButton {
        if (lastButtonTouched.equalsIgnoreCase("00")) {
            this.setLastButtonTouched(0);
        } else if (lastButtonTouched.equalsIgnoreCase("01")) {
            this.setLastButtonTouched(1);
            this.requestedDayNumber = 1;
            this.composeCalendar.set(7, 2);
        } else if (lastButtonTouched.equalsIgnoreCase("02")) {
            this.setLastButtonTouched(2);
            this.requestedDayNumber = 2;
            this.composeCalendar.set(7, 3);
        } else if (lastButtonTouched.equalsIgnoreCase("03")) {
            this.setLastButtonTouched(3);
            this.requestedDayNumber = 3;
            this.composeCalendar.set(7, 4);
        } else if (lastButtonTouched.equalsIgnoreCase("04")) {
            this.setLastButtonTouched(4);
            this.requestedDayNumber = 4;
            this.composeCalendar.set(7, 5);
        } else if (lastButtonTouched.equalsIgnoreCase("05")) {
            this.setLastButtonTouched(5);
            this.requestedDayNumber = 5;
            this.composeCalendar.set(7, 6);
        } else if (lastButtonTouched.equalsIgnoreCase("06")) {
            if (this.gs.isWeekends()) {
                if (this.getLastButtonTouched() == 6 && this.numberOfButtonTouched == 0) {
                    this.requestedDayNumber = 7;
                    this.composeCalendar.set(7, 1);
                    this.numberOfButtonTouched = 1;
                } else {
                    this.requestedDayNumber = 6;
                    this.composeCalendar.set(7, 7);
                    this.numberOfButtonTouched = 0;
                }
                this.setLastButtonTouched(6);
            }
        } else if (lastButtonTouched.equalsIgnoreCase("0a")) {
            this.setLastButtonTouched(11);
        } else if (lastButtonTouched.equalsIgnoreCase("0b")) {
            this.setLastButtonTouched(12);
            if (this.getLimit(this.getMealId(this.chodSymbol[0][0], 1), this.getVydejnaId(this.chodSymbol[0][3]), this.getTimeInterval()) == null) {
                LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                throw new NoSuchButton();
            }
            this.chodNumber = 1;
            this.chodId = this.getMealId(this.chodSymbol[0][0], this.chodNumber);
        } else if (lastButtonTouched.equalsIgnoreCase("0c")) {
            this.setLastButtonTouched(13);
            if (this.getLimit(this.getMealId(this.chodSymbol[0][0], 2), this.getVydejnaId(this.chodSymbol[0][3]), this.getTimeInterval()) == null) {
                LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                throw new NoSuchButton();
            }
            this.chodNumber = 2;
            this.chodId = this.getMealId(this.chodSymbol[0][0], this.chodNumber);
        } else if (lastButtonTouched.equalsIgnoreCase("0d")) {
            if (this.chodNumber > 1 && this.getLastButtonTouched() == 14) {
                if (this.getLimit(this.getMealId(this.chodSymbol[0][0], this.chodNumber + 1), this.getVydejnaId(this.chodSymbol[0][3]), this.getTimeInterval()) == null) {
                    LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                    throw new NoSuchButton();
                }
                ++this.chodNumber;
                this.chodId = this.getMealId(this.chodSymbol[0][0], this.chodNumber);
            } else {
                if (this.getLimit(this.getMealId(this.chodSymbol[0][0], 3), this.getVydejnaId(this.chodSymbol[0][3]), this.getTimeInterval()) == null) {
                    LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                    throw new NoSuchButton();
                }
                this.chodNumber = 3;
                this.chodId = this.getMealId(this.chodSymbol[0][0], this.chodNumber);
            }
            this.setLastButtonTouched(14);
        } else if (lastButtonTouched.equalsIgnoreCase("0e")) {
            this.setLastButtonTouched(15);
            this.vydejnaId = this.getVydejnaId(this.chodSymbol[0][3]);
        } else if (lastButtonTouched.equalsIgnoreCase("0f")) {
            this.setLastButtonTouched(16);
            ++this.weekNumber;
            this.weekNumber = this.impliciteWeek < 10 ? (this.weekNumber %= 2) : (this.weekNumber %= 4);
            Calendar cal = Calendar.getInstance();
            cal.add(7, this.getTimeInterval());
            this.refreshWeeks(cal);
        } else if (lastButtonTouched.equalsIgnoreCase("1a")) {
            this.setLastButtonTouched(21);
        } else if (lastButtonTouched.equalsIgnoreCase("1b")) {
            if (this.getLimit(this.getMealId(this.chodSymbol[3][0], 1), this.getVydejnaId(this.chodSymbol[3][3]), this.getTimeInterval()) == null) {
                LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                throw new NoSuchButton();
            }
            this.chodNumber = 1;
            this.chodId = this.getMealId(this.chodSymbol[3][0], this.chodNumber);
            this.setLastButtonTouched(22);
        }
        if (lastButtonTouched.equalsIgnoreCase("1c")) {
            if (this.getLimit(this.getMealId(this.chodSymbol[3][0], 2), this.getVydejnaId(this.chodSymbol[3][3]), this.getTimeInterval()) == null) {
                LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                throw new NoSuchButton();
            }
            this.chodNumber = 2;
            this.chodId = this.getMealId(this.chodSymbol[3][0], this.chodNumber);
            this.setLastButtonTouched(23);
        }
        if (lastButtonTouched.equalsIgnoreCase("1d")) {
            if (this.chodNumber > 1 && this.getLastButtonTouched() == 24) {
                if (this.getLimit(this.getMealId(this.chodSymbol[3][0], this.chodNumber + 1), this.getVydejnaId(this.chodSymbol[3][3]), this.getTimeInterval()) == null) {
                    LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                    throw new NoSuchButton();
                }
                ++this.chodNumber;
                this.chodId = this.getMealId(this.chodSymbol[3][0], this.chodNumber);
            } else {
                if (this.getLimit(this.getMealId(this.chodSymbol[3][0], 3), this.getVydejnaId(this.chodSymbol[3][3]), this.getTimeInterval()) == null) {
                    LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                    throw new NoSuchButton();
                }
                this.chodNumber = 3;
                this.chodId = this.getMealId(this.chodSymbol[3][0], this.chodNumber);
            }
            this.setLastButtonTouched(24);
        }
        if (lastButtonTouched.equalsIgnoreCase("1e")) {
            this.setLastButtonTouched(25);
            this.vydejnaId = this.getVydejnaId(this.chodSymbol[3][3]);
        }
        if (lastButtonTouched.equalsIgnoreCase("1f")) {
            this.setLastButtonTouched(26);
        }
        if (lastButtonTouched.equalsIgnoreCase("2a")) {
            this.setLastButtonTouched(31);
        }
        if (lastButtonTouched.equalsIgnoreCase("2b")) {
            this.setLastButtonTouched(32);
            if (this.getLimit(this.getMealId(this.chodSymbol[6][0], 1), this.getVydejnaId(this.chodSymbol[6][3]), this.getTimeInterval()) == null) {
                LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                throw new NoSuchButton();
            }
            this.chodNumber = 1;
            this.chodId = this.getMealId(this.chodSymbol[6][0], this.chodNumber);
        }
        if (lastButtonTouched.equalsIgnoreCase("2c")) {
            this.setLastButtonTouched(33);
            if (this.getLimit(this.getMealId(this.chodSymbol[6][0], 2), this.getVydejnaId(this.chodSymbol[6][3]), this.getTimeInterval()) == null) {
                LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                throw new NoSuchButton();
            }
            this.chodNumber = 2;
            this.chodId = this.getMealId(this.chodSymbol[6][0], this.chodNumber);
        }
        if (lastButtonTouched.equalsIgnoreCase("2d")) {
            this.setLastButtonTouched(34);
            if (this.chodNumber > 1 && this.getLastButtonTouched() == 34) {
                if (this.getLimit(this.getMealId(this.chodSymbol[6][0], this.chodNumber + 1), this.getVydejnaId(this.chodSymbol[6][3]), this.getTimeInterval()) == null) {
                    LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                    throw new NoSuchButton();
                }
                ++this.chodNumber;
                this.chodId = this.getMealId(this.chodSymbol[6][0], this.chodNumber);
            } else {
                if (this.getLimit(this.getMealId(this.chodSymbol[6][0], 3), this.getVydejnaId(this.chodSymbol[6][3]), this.getTimeInterval()) == null) {
                    LOGGER.warn((Object)"Na tlacitku neni nastaveny zadny chod");
                    throw new NoSuchButton();
                }
                this.chodNumber = 3;
                this.chodId = this.getMealId(this.chodSymbol[6][0], this.chodNumber);
            }
        }
        if (lastButtonTouched.equalsIgnoreCase("2e")) {
            this.setLastButtonTouched(35);
            this.vydejnaId = this.getVydejnaId(this.chodSymbol[6][3]);
        }
        if (lastButtonTouched.equalsIgnoreCase("2f")) {
            this.setLastButtonTouched(36);
        }
    }

    @Override
    public String getTerminalName() {
        return TERMINAL_NAME;
    }

    @Override
    public int getPlaceID() {
        if (this.vydejnaId == 0) {
            return this.placeID;
        }
        return this.vydejnaId;
    }

    private int computeRequestedDayNumber() {
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
        return currentDayOfWeek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMealId(String symbol, int chodNumber) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "SELECT chod_id FROM tchody WHERE SymbolTerminalu = '" + symbol + "' ";
            if (chodNumber > -1) {
                sql = sql + "AND CisloChodu = " + chodNumber + " ";
            }
            rs = stm.executeQuery(sql);
            rs.beforeFirst();
            if (rs.next()) {
                int n = rs.getInt("chod_id");
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVydejnaId(String symbol) {
        if (this.getUser() != null && this.getUser().isFixVydejna() && this.getUser().getVydejna() > 0) {
            return this.getUser().getVydejna();
        }
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "SELECT vydejna_id FROM tvydejny WHERE ZkrV = '" + symbol + "'";
            rs = stm.executeQuery(sql);
            rs.beforeFirst();
            if (rs.next()) {
                int n = rs.getInt("vydejna_id");
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }
}

