/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.util.Calendar;
import java.util.StringTokenizer;
import universalrouter.terminals.TerminalClassical;
import universalrouter.util.StringConvertor;

public class TerminalClassicalBonap
extends TerminalClassical {
    private static final String terminalName = "Class.Graf.";
    protected MEALS zvoleneJidlo;

    public TerminalClassicalBonap(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int impliciteWeek, int id, int ra, String vol, String configuration) {
        super(adr, type, hasTerminalGraphicalDisplay, placeID, impliciteWeek, id, ra, vol, configuration);
    }

    public void init() {
        super.init();
        this.zvoleneJidlo = MEALS.DEFAULT;
        this.chodSymbol = new String[5][3];
        this.chodSymbol[0][0] = "S";
        this.chodSymbol[1][0] = "O";
        this.chodSymbol[2][0] = "V";
        this.chodSymbol[3][0] = "Sd";
        this.chodSymbol[4][0] = "So";
        this.chodSymbol[0][2] = "disable";
        this.chodSymbol[1][2] = "enable";
        this.chodSymbol[2][2] = "disable";
        this.chodSymbol[3][2] = "disable";
        this.chodSymbol[4][2] = "disable";
        StringTokenizer tempStringTokenizer = new StringTokenizer(this.configuration);
        int i = 0;
        while (tempStringTokenizer.hasMoreTokens()) {
            this.chodSymbol[i][0] = tempStringTokenizer.nextToken(",");
            this.chodSymbol[i][2] = this.getUser() != null ? (this.chodSymbol[i][0].equalsIgnoreCase("X") || !this.existsCenik(this.chodSymbol[i][0]) ? "disable" : "enable") : (this.chodSymbol[i][0].equalsIgnoreCase("X") ? "disable" : "enable");
            ++i;
        }
        this.init("false", "true", "false", "false", "false");
    }

    protected void refreshDisplayOrders(boolean lastLine) {
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
        this.getDisplay().setClear(true);
        this.getDisplay().setEXPositionBig(StringConvertor.addWhiteSpacesTo16("Po " + this.composeDayOrders(1 - currentDayOfWeek + 7 * this.weekNumber) + "\u010ct " + this.composeDayOrders(4 - currentDayOfWeek + 7 * this.weekNumber) + ""), 1);
        this.getDisplay().setEXPositionBig(StringConvertor.addWhiteSpacesTo16("\u00dat " + this.composeDayOrders(2 - currentDayOfWeek + 7 * this.weekNumber) + "P\u00e1 " + this.composeDayOrders(5 - currentDayOfWeek + 7 * this.weekNumber) + ""), 2);
        this.getDisplay().setEXPositionBig(StringConvertor.addWhiteSpacesTo16("St " + this.composeDayOrders(3 - currentDayOfWeek + 7 * this.weekNumber) + "" + StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())) + " K\u010d"), 3);
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getSelectedWeek(cal)), 7, true);
        if (lastLine) {
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getUser().getName()), 8, true);
        }
    }

    protected int processMealButtons(int result, int interval, Calendar cal) {
        int res = super.processMealButtons(result, interval, cal);
        if (this.getLastButtonTouched() == 61) {
            this.setDisplayLastLine(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()));
        }
        return res;
    }

    protected void setDisplayLastLine(String text) {
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(text), 8, true);
        LOGGER.debug((Object)("*Display* dpos:8 " + this.getTempDisplayText()));
    }

    protected void setDisplayWeekLine(String text) {
        this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(text), 7, true);
        LOGGER.debug((Object)("*Display* dpos:7 " + this.getTempDisplayText()));
    }

    protected void switchZvoleneJidlo() {
        switch (this.zvoleneJidlo) {
            case DEFAULT: {
                this.init("true", "true", "true", "true", "false");
                this.setTempDisplayText("V\u0161e");
                this.zvoleneJidlo = MEALS.VSE;
                break;
            }
            case VSE: {
                this.init("true", "false", "false", "false", "false");
                this.setTempDisplayText("Sn\u00eddan\u011b");
                this.zvoleneJidlo = MEALS.SNIDANE;
                break;
            }
            case SNIDANE: {
                this.init("false", "true", "false", "false", "false");
                this.setTempDisplayText("Ob\u011bdy");
                this.zvoleneJidlo = MEALS.OBEDY;
                break;
            }
            case OBEDY: {
                this.init("false", "false", "true", "false", "false");
                this.setTempDisplayText("Ve\u010de\u0159e");
                this.zvoleneJidlo = MEALS.VECERE;
                break;
            }
            case VECERE: {
                this.init("true", "true", "true", "true", "false");
                this.setTempDisplayText("V\u0161e");
                this.zvoleneJidlo = MEALS.VSE;
            }
        }
    }

    protected void decodeLastButtonTouched(String lastButtonTouched) {
        LOGGER.debug((Object)("Posledni stisknute tlacitko: " + lastButtonTouched));
        if (lastButtonTouched.equalsIgnoreCase("00")) {
            this.setLastButtonTouched(0);
        } else if (lastButtonTouched.equalsIgnoreCase("01")) {
            this.setLastButtonTouched(1);
            this.requestedDayNumber = 1;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0a")) {
            this.setLastButtonTouched(2);
            this.requestedDayNumber = 2;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("1a")) {
            this.setLastButtonTouched(3);
            this.requestedDayNumber = 3;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("04")) {
            this.setLastButtonTouched(4);
            this.requestedDayNumber = 4;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0d")) {
            this.setLastButtonTouched(5);
            this.requestedDayNumber = 5;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("1d")) {
            this.switchZvoleneJidlo();
            this.setLastButtonTouched(61);
        } else if (lastButtonTouched.equalsIgnoreCase("02")) {
            this.setLastButtonTouched(11);
            this.requestedDayNumber = 1;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0b")) {
            this.setLastButtonTouched(12);
            this.requestedDayNumber = 2;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("1b")) {
            this.setLastButtonTouched(13);
            this.requestedDayNumber = 3;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("05")) {
            this.setLastButtonTouched(14);
            this.requestedDayNumber = 4;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0e")) {
            this.setLastButtonTouched(15);
            this.requestedDayNumber = 5;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("1e")) {
            this.setLastButtonTouched(16);
            ++this.weekNumber;
            this.weekNumber = this.impliciteWeek < 10 ? (this.weekNumber %= 2) : (this.weekNumber %= 4);
        } else if (lastButtonTouched.equalsIgnoreCase("03")) {
            this.requestedDayNumber = 1;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 21 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.setLastButtonTouched(21);
        } else if (lastButtonTouched.equalsIgnoreCase("0c")) {
            this.requestedDayNumber = 2;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 22 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.setLastButtonTouched(22);
        } else if (lastButtonTouched.equalsIgnoreCase("1c")) {
            this.requestedDayNumber = 3;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 23 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.setLastButtonTouched(23);
        } else if (lastButtonTouched.equalsIgnoreCase("06")) {
            this.requestedDayNumber = 4;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 24 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.setLastButtonTouched(24);
        } else if (lastButtonTouched.equalsIgnoreCase("0f")) {
            this.requestedDayNumber = 5;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 25 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.setLastButtonTouched(25);
        } else if (lastButtonTouched.equalsIgnoreCase("1f")) {
            this.setLastButtonTouched(26);
        } else if (lastButtonTouched.equalsIgnoreCase("2a")) {
            this.setLastButtonTouched(31);
        } else if (lastButtonTouched.equalsIgnoreCase("2b")) {
            this.setLastButtonTouched(32);
        } else if (lastButtonTouched.equalsIgnoreCase("2c")) {
            this.setLastButtonTouched(33);
        } else if (lastButtonTouched.equalsIgnoreCase("2d")) {
            this.setLastButtonTouched(34);
        } else if (lastButtonTouched.equalsIgnoreCase("2e")) {
            this.setLastButtonTouched(35);
        } else if (lastButtonTouched.equalsIgnoreCase("2f")) {
            this.setLastButtonTouched(36);
        }
    }

    public String getTerminalName() {
        return terminalName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MEALS {
        SNIDANE,
        OBEDY,
        VECERE,
        VSE,
        BALENE,
        DEFAULT;

    }
}

