/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import universalrouter.comm.OrderLimit;
import universalrouter.database.SQLParam;
import universalrouter.terminals.TerminalBaseObjednavka;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Display;
import universalrouter.util.StringConvertor;

public class TerminalClassical
extends TerminalBaseObjednavka
implements TerminalCommonInterface {
    private static final String terminalName = "Classical ";
    protected static final int maxSymbols = 5;
    protected static final int maxChodNumber = 8;
    protected int impliciteWeek;
    protected int chodNumber;
    protected int weekNumber;
    protected int requestedDayNumber;
    protected String[][] chodSymbol;
    protected String configuration;
    protected int numberOfButtonTouched;

    public TerminalClassical(int adr, int type, boolean hasTerminalGraphicalDisplay, int placeID, int impliciteWeek, int id, int ra, String vol, String configuration) {
        this.weekNumber = this.impliciteWeek = 0;
        this.requestedDayNumber = 1;
        this.numberOfButtonTouched = 0;
        this.setHasAnswer(false);
        this.adress = adr;
        this.type = type;
        this.hasTerminalGraphicalDisplay = hasTerminalGraphicalDisplay;
        this.placeID = placeID;
        this.terminal_id = id;
        this.resetLockedTerminalAfter = ra;
        this.impliciteWeek = impliciteWeek;
        this.weekNumber = impliciteWeek % 10;
        this.configuration = configuration;
        this.setDisplay(new Display());
        this.setVolume(vol);
    }

    public void nullData() {
        try {
            this.setHasAnswer(false);
            this.setChipCode(null);
            this.setStrReader(null);
            this.setTempDisplayText(null);
            this.setMealId(0);
            this.setUser(null);
            this.setChipReadedForObjednavkaTerminal(null);
            this.getDisplay().nullDisplay();
            this.weekNumber = this.impliciteWeek % 10;
            this.numberOfButtonTouched = 0;
            this.init();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Chyba nulovani dat terminalu", (Throwable)e);
        }
    }

    public void init() {
        super.init();
        this.chodSymbol = new String[5][3];
        this.chodSymbol[0][0] = "S";
        this.chodSymbol[1][0] = "Sd";
        this.chodSymbol[2][0] = "O";
        this.chodSymbol[3][0] = "So";
        this.chodSymbol[4][0] = "V";
        this.chodSymbol[0][2] = "disable";
        this.chodSymbol[1][2] = "disable";
        this.chodSymbol[2][2] = "enable";
        this.chodSymbol[3][2] = "disable";
        this.chodSymbol[4][2] = "disable";
        StringTokenizer tempStringTokenizer = new StringTokenizer(this.configuration);
        int i = 0;
        while (tempStringTokenizer.hasMoreTokens()) {
            this.chodSymbol[i][0] = tempStringTokenizer.nextToken(",");
            this.chodSymbol[i][2] = this.getUser() != null ? (this.chodSymbol[i][0].equalsIgnoreCase("X") || !this.existsCenik(this.chodSymbol[i][0]) ? "disable" : "enable") : (this.chodSymbol[i][0].equalsIgnoreCase("X") ? "disable" : "enable");
            ++i;
        }
        this.init("false", "false", "true", "false", "false");
    }

    protected void init(String sn, String sd, String ob, String so, String ve) {
        if (this.getUser() != null && this.getUser().getSpecialniPravidlo() == 8) {
            this.chodSymbol[0][1] = "true";
            this.chodSymbol[1][1] = "true";
            this.chodSymbol[2][1] = "true";
            this.chodSymbol[3][1] = "true";
            this.chodSymbol[4][1] = "true";
        } else {
            this.chodSymbol[0][1] = sn;
            this.chodSymbol[1][1] = sd;
            this.chodSymbol[2][1] = ob;
            this.chodSymbol[3][1] = so;
            this.chodSymbol[4][1] = ve;
        }
    }

    public int doAction(byte[] byteBuffer) {
        int pchk = this.basePrimaryCheck(byteBuffer);
        if (pchk != 1) {
            return pchk;
        }
        int smess = this.sendMessesIgnoreVolume();
        if (smess == -2 && this.getStrReader().compareTo("01") == 0) {
            return smess;
        }
        if (this.getStrReader().compareTo("01") == 0) {
            this.setTempDisplayText(null);
            this.decodeLastButtonTouched(this.getChipCode().substring(0, 2));
            if (this.getLastButtonTouched() == 0) {
                this.nullData();
                this.getDisplay().setLogout(true);
                return -2;
            }
            if (this.getChipReadedForObjednavkaTerminal() == null) {
                this.getDisplay().setClear(true);
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Prilozte cip!"), 6);
                return -2;
            }
            Calendar cal = Calendar.getInstance();
            int currentDayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
            int interval = this.requestedDayNumber - currentDayOfWeek + this.weekNumber * 7;
            cal.add(7, interval);
            int result = 0;
            if (this.getUser().getSpecialniPravidlo() == 9) {
                LOGGER.debug((Object)"Nezle odhl\u00e1sit z d\u016fvodu speci\u00e1ln\u00edho pravidla SPEC_NEMOZNOST_ODHLASEK");
                this.setTempDisplayText("Nelze odhl\u00e1sit");
            } else {
                result = this.deleteOrderAndChcekButton(result, interval, cal);
            }
            result = this.processMealButtons(result, interval, cal);
        }
        if (this.getStrReader().compareTo("81") == 0) {
            int echk = this.extendedPrimaryCheck();
            if (echk != 1) {
                if (echk == 0) {
                    String chipCode = this.getChipCode();
                    this.nullData();
                    this.getDisplay().nullDisplay();
                    this.setTempDisplayText("\u010cip nenalezen");
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(chipCode), 1);
                } else {
                    this.nullData();
                    this.setTempDisplayText("Chybn\u00fd povel");
                }
                this.setInformationDisplayNM(true);
                return echk;
            }
            if (this.getChipReadedForObjednavkaTerminal() != null) {
                this.setChipReadedForObjednavkaTerminal(null);
                this.decodeLastButtonTouched("00");
                this.nullData();
                this.setTempDisplayText("U\u017eivatel odhl\u00e1\u0161en");
                this.getDisplay().setLogout(true);
                return 1;
            }
            this.setChipReadedForObjednavkaTerminal(this.getChipCode());
            this.init();
            this.refreshDisplayOrders(true);
        }
        return 1;
    }

    protected int processMealButtons(int result, int interval, Calendar cal) {
        if (this.getLastButtonTouched() > 10 && this.getLastButtonTouched() < 16 || this.getLastButtonTouched() > 20 && this.getLastButtonTouched() < 26) {
            result = this.checkAndMakeOrder(result, interval, cal);
        }
        if (this.getLastButtonTouched() > 30 && this.getLastButtonTouched() <= 36) {
            this.setDisplayLastLine(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()));
        } else {
            this.refreshDisplayOrders(false);
            if (result != 0) {
                if (this.gs.isWeekends()) {
                    this.setInformationDisplayNM(true);
                } else {
                    this.setDisplayLastLine(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()));
                }
            } else {
                this.setDisplayLastLine(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()));
                this.setDisplayWeekLine(this.getSelectedWeek(cal));
            }
        }
        return result;
    }

    private int deleteOrder(int result, int interval, Calendar cal) {
        for (int i = 0; i < 5; ++i) {
            int meal;
            if (this.getUser().getSpecialniPravidlo() != 2 && !"true".equalsIgnoreCase(this.chodSymbol[i][1]) || !"enable".equalsIgnoreCase(this.chodSymbol[i][2]) || (meal = this.getChodId(this.chodSymbol[i][0], this.chodNumber)) <= 0) continue;
            OrderLimit limit = this.getLimit(meal, this.getPlaceID(), interval);
            if (limit == null || limit.isLimitTimeCancelExceeded(cal.getTime(), this.gs.isWeekends())) {
                LOGGER.debug((Object)("Nelze zrusit objednavku, chodId: " + meal + " je po limitu"));
                this.setTempDisplayText("Po limitu");
                if (this.gs.isWeekends()) {
                    this.setInformationDisplayNM(true);
                } else {
                    this.setDisplayLastLine(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()));
                }
                result = -2;
            }
            if (result != 0) continue;
            this.cancelSpecifiedDay(interval, i);
        }
        LOGGER.debug((Object)"Odhlasky probehly v poradku");
        return result;
    }

    protected int deleteOrderAndChcekButton(int result, int interval, Calendar cal) {
        if (this.getLastButtonTouched() > 0 && this.getLastButtonTouched() <= 6) {
            result = this.deleteOrder(result, interval, cal);
        }
        return result;
    }

    protected int checkBeforeDelete(int result, int interval, int i, Calendar cal, int chodId) {
        LOGGER.debug((Object)"Kontroluji jidelnicky");
        if (this.gs.isCheckJidelnicek() && this.isSpecifiedJidelnicek(interval, chodId, true) == -1) {
            this.setTempDisplayText("Nen\u00ed j\u00eddeln\u00ed\u010dek");
            LOGGER.debug((Object)("Nelze objednat: " + this.getTempDisplayText()));
            result = -2;
        }
        LOGGER.debug((Object)"Kontroluji limity");
        if (this.gs.isCheckJidelnicek() && this.getOrderedMessesCount(interval, chodId) >= this.getMaxMesses(interval, chodId)) {
            this.setTempDisplayText("Vy\u010derp\u00e1n limit");
            LOGGER.debug((Object)("Nelze objednat: " + this.getTempDisplayText()));
            result = -2;
        }
        LOGGER.debug((Object)"Kontroluji casy");
        OrderLimit limit = this.getLimit(chodId, this.getPlaceID(), interval);
        if (limit == null || limit.isLimitTimeOrderExceeded(cal.getTime(), this.gs.isWeekends())) {
            this.setTempDisplayText("Po limitu");
            LOGGER.debug((Object)("Nelze objednat: " + this.getTempDisplayText()));
            result = -2;
        }
        if (this.isForbidenOrder(interval, this.chodSymbol[i][0])) {
            LOGGER.debug((Object)"Snaha o zruseni hvezdicky, nebude povoleno.");
            result = -2;
        }
        return result;
    }

    protected int checkAndMakeOrder(int result, int interval, Calendar cal) {
        for (int i = 0; i < 5; ++i) {
            int chodId = this.getChodId(this.chodSymbol[i][0], this.chodNumber);
            if (chodId <= 0) {
                chodId = this.getChodId(this.chodSymbol[i][0], 1);
            }
            if (!"true".equalsIgnoreCase(this.chodSymbol[i][1]) || !"enable".equalsIgnoreCase(this.chodSymbol[i][2]) || chodId <= 0) continue;
            result = this.checkBeforeDelete(result, interval, i, cal, chodId);
            LOGGER.debug((Object)"Odhlasuji predchozi objednavky");
            if (result == 0) {
                this.cancelSpecifiedDay(interval, i);
            }
            if (this.getUser().getSpecialniPravidlo() == 2 && this.hasUserAnyOrdered(interval) && result == 0) {
                LOGGER.debug((Object)"Mohou m\u00edt jedin\u00e9 j\u00eddlo na cel\u00fd den, m\u011bn\u00edm chod za nov\u00fd.");
                result = this.deleteOrder(0, interval, cal);
                if (result == 0) {
                    this.orderSpecifiedDay(interval, i, chodId);
                }
            } else if (this.userHasTypeOrdered(interval, this.chodSymbol[i][0])) {
                if (this.getUser().getSpecialniPravidlo() == 9 || this.getUser().getSpecialniPravidlo() == 8) {
                    LOGGER.debug((Object)"Nen\u00ed mo\u017en\u00e9 odhla\u0161ovat, m\u011bn\u00edm chod za nov\u00fd.");
                    if (result == 0) {
                        this.cancelSpecifiedDay(interval, i);
                        this.orderSpecifiedDay(interval, i, chodId);
                    }
                } else {
                    this.setTempDisplayText("Objednan\u00fd typ");
                    LOGGER.debug((Object)"Snaha o objednani chodu, jehoz typ ji\u017e existuje na jin\u00e9 v\u00fddejn\u011b.");
                }
                result = -2;
            }
            LOGGER.debug((Object)"Kontroluji kredit");
            if (result == 0 && this.checkCredit(1, interval, chodId) == -3) {
                this.setTempDisplayText("Nen\u00ed kredit");
                LOGGER.debug((Object)("Nelze objednat: " + this.getTempDisplayText()));
                result = -2;
            }
            if (result != 0) continue;
            LOGGER.debug((Object)"Zapisuji objednavky");
            this.orderSpecifiedDay(interval, i, chodId);
        }
        return result;
    }

    protected String getSelectedWeek(Calendar weekCalendar) {
        if (this.weekNumber == 0) {
            return "Tento t\u00fdden";
        }
        if (this.weekNumber == 1) {
            return "P\u0159\u00ed\u0161t\u00ed t\u00fdden";
        }
        Calendar showCalendar = Calendar.getInstance();
        showCalendar.setTime(weekCalendar.getTime());
        showCalendar.set(7, 2);
        return "T\u00fdden " + showCalendar.get(5) + ". " + (showCalendar.get(2) + 1) + ". ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int cancelSpecifiedDay(int interval, int i) {
        Statement stm = this.dbmanager.getStatement();
        try {
            if ((this.getUser().getSpecialniPravidlo() == 2 || this.chodSymbol[i][1].equalsIgnoreCase("true")) && this.chodSymbol[i][2].equalsIgnoreCase("enable")) {
                stm.executeUpdate("DELETE tobjednavky FROM tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE SymbolTerminalu = '" + this.chodSymbol[i][0] + "' AND " + "stravnik_id=" + this.getUser().getId() + " AND " + "datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND " + "VydanoKusu = 0 AND Kusu > 0");
                if (!this.rewritePrices(interval)) {
                    int n = -1;
                    return n;
                }
            }
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int orderSpecifiedDay(int interval, int i, int chodId) {
        Statement stm = this.dbmanager.getStatement();
        try {
            if (this.chodSymbol[i][1].equalsIgnoreCase("true") && this.chodSymbol[i][2].equalsIgnoreCase("enable")) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik jeste nema na nasledujici den."));
                if (chodId > 0) {
                    ArrayList<SQLParam> params = new ArrayList<SQLParam>();
                    params.add(new SQLParam("Stravnik_Id", "" + this.getUser().getId(), "int"));
                    params.add(new SQLParam("Vydejna_Id", "" + this.getPlaceID(), "int"));
                    params.add(new SQLParam("Chod_Id", "" + chodId, "int"));
                    this.dbmanager.doPreparedStatement("INSERT into tobjednavky (Stravnik_Id, Jidelna_Id, Vydejna_Id, Datum, Chod_Id,Kusu, CasObj, ZdrojObj_Id, DatumObj) VALUES (?,0,?,DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY)," + "?,1,CURTIME(),4,CURDATE()) ON DUPLICATE KEY UPDATE kusu=1", params);
                    params.clear();
                    params = null;
                }
                LOGGER.debug((Object)"Prepocitavam kusy");
                if (!this.rewritePrices(interval)) {
                    int params = -1;
                    return params;
                }
            }
            int params = 1;
            return params;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChodId(String symbol, int chod) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM tchody WHERE SymbolTerminalu = '" + symbol + "' " + "AND CisloChodu = " + chod);
            rs.beforeFirst();
            if (rs.next()) {
                int n = rs.getInt("chod_id");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    protected void refreshDisplayOrders(boolean lastLine) {
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
        if (this.gs.isWeekends()) {
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Po" + this.composeDayOrders(1 - currentDayOfWeek + 7 * this.weekNumber) + " Pa" + this.composeDayOrders(5 - currentDayOfWeek + 7 * this.weekNumber) + " "), 3);
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Ut" + this.composeDayOrders(2 - currentDayOfWeek + 7 * this.weekNumber) + " So" + this.composeDayOrders(6 - currentDayOfWeek + 7 * this.weekNumber) + " "), 6);
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("St" + this.composeDayOrders(3 - currentDayOfWeek + 7 * this.weekNumber) + " Ne" + this.composeDayOrders(7 - currentDayOfWeek + 7 * this.weekNumber) + " "), 7);
            if (lastLine) {
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Ct" + this.composeDayOrders(4 - currentDayOfWeek + 7 * this.weekNumber) + " " + StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())) + " Kc"), 8);
            }
        } else {
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Po " + this.composeDayOrders(1 - currentDayOfWeek + 7 * this.weekNumber) + "Ct " + this.composeDayOrders(4 - currentDayOfWeek + 7 * this.weekNumber) + ""), 3);
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("Ut " + this.composeDayOrders(2 - currentDayOfWeek + 7 * this.weekNumber) + "Pa " + this.composeDayOrders(5 - currentDayOfWeek + 7 * this.weekNumber) + ""), 6);
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16("St " + this.composeDayOrders(3 - currentDayOfWeek + 7 * this.weekNumber) + "" + StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())) + " Kc"), 7);
            if (lastLine) {
                this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(StringConvertor.internationalToEnglish(this.getUser().getName())), 8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean userHasTypeOrdered(int interval, String symbol) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT CisloChodu, SymbolTerminalu, VybranySymbol, VydanoKusu FROM tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE stravnik_id=" + this.getUser().getId() + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "AND Kusu > 0 AND Platne >= 0 AND TypChodu = (SELECT TypChodu FROM tchody WHERE SymbolTerminalu ='" + symbol + "' LIMIT 1) " + "ORDER BY PoradiChodu, CisloChodu");
            rs.beforeFirst();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isForbidenOrder(int interval, String symbol) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT CisloChodu, SymbolTerminalu, VybranySymbol, VydanoKusu FROM tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE stravnik_id=" + this.getUser().getId() + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "AND vydejna_id = " + this.getPlaceID() + " AND Kusu = 0 AND Platne >= 0 AND SymbolTerminalu = '" + symbol + "' " + "ORDER BY PoradiChodu, CisloChodu");
            rs.beforeFirst();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String composeDayOrders(int interval) {
        int i;
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        char[] ret = new char[5];
        for (i = 0; i < 5; ++i) {
            ret[i] = this.chodSymbol[i][2].equals("enable") ? 48 : 32;
        }
        try {
            rs = stm.executeQuery("SELECT Kusu, CisloChodu, SymbolTerminalu, VybranySymbol, VydanoKusu FROM tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE stravnik_id=" + this.getUser().getId() + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "AND vydejna_id = " + this.getPlaceID() + " AND Platne >= 0 " + "ORDER BY PoradiChodu, CisloChodu");
            rs.beforeFirst();
            while (rs.next()) {
                for (i = 0; i < 5; ++i) {
                    if (!rs.getString("SymbolTerminalu").equalsIgnoreCase(this.chodSymbol[i][0])) continue;
                    ret[i] = rs.getInt("Kusu") == 0 ? 42 : (rs.getInt("VydanoKusu") > 0 ? rs.getString("VybranySymbol").charAt(0) : rs.getString("CisloChodu").charAt(0));
                }
            }
            String i2 = new String(ret);
            return i2;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    protected void decodeLastButtonTouched(String lastButtonTouched) {
        if (lastButtonTouched.equalsIgnoreCase("00")) {
            this.setLastButtonTouched(0);
        } else if (lastButtonTouched.equalsIgnoreCase("01")) {
            this.setLastButtonTouched(1);
            this.requestedDayNumber = 1;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("02")) {
            this.setLastButtonTouched(2);
            this.requestedDayNumber = 2;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("03")) {
            this.setLastButtonTouched(3);
            this.requestedDayNumber = 3;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("04")) {
            this.setLastButtonTouched(4);
            this.requestedDayNumber = 4;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("05")) {
            this.setLastButtonTouched(5);
            this.requestedDayNumber = 5;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("06")) {
            if (this.gs.isWeekends()) {
                this.setLastButtonTouched(6);
                this.requestedDayNumber = 6;
                this.chodNumber = 1;
            }
        } else if (lastButtonTouched.equalsIgnoreCase("0a")) {
            this.setLastButtonTouched(11);
            this.requestedDayNumber = 1;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0b")) {
            this.setLastButtonTouched(12);
            this.requestedDayNumber = 2;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0c")) {
            this.setLastButtonTouched(13);
            this.requestedDayNumber = 3;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0d")) {
            this.setLastButtonTouched(14);
            this.requestedDayNumber = 4;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0e")) {
            this.setLastButtonTouched(15);
            this.requestedDayNumber = 5;
            this.chodNumber = 1;
        } else if (lastButtonTouched.equalsIgnoreCase("0f")) {
            this.setLastButtonTouched(16);
            ++this.weekNumber;
            this.weekNumber = this.impliciteWeek < 10 ? (this.weekNumber %= 2) : (this.weekNumber %= 4);
        } else if (lastButtonTouched.equalsIgnoreCase("1a")) {
            this.requestedDayNumber = 1;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 21 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.chodNumber = 2;
            this.setLastButtonTouched(21);
        } else if (lastButtonTouched.equalsIgnoreCase("1b")) {
            this.requestedDayNumber = 2;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 22 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.chodNumber = 2;
            this.setLastButtonTouched(22);
        } else if (lastButtonTouched.equalsIgnoreCase("1c")) {
            this.requestedDayNumber = 3;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 23 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.chodNumber = 2;
            this.setLastButtonTouched(23);
        } else if (lastButtonTouched.equalsIgnoreCase("1d")) {
            this.requestedDayNumber = 4;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 24 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.chodNumber = 2;
            this.setLastButtonTouched(24);
        } else if (lastButtonTouched.equalsIgnoreCase("1e")) {
            this.requestedDayNumber = 5;
            this.chodNumber = this.chodNumber > 1 && this.getLastButtonTouched() == 25 && this.chodNumber < 8 && this.existsCenikByNumber(this.chodNumber + 1) ? ++this.chodNumber : 2;
            this.chodNumber = 2;
            this.setLastButtonTouched(25);
        } else if (lastButtonTouched.equalsIgnoreCase("1f")) {
            this.setLastButtonTouched(26);
        } else if (lastButtonTouched.equalsIgnoreCase("2a")) {
            this.setLastButtonTouched(31);
            this.init("true", "true", "true", "true", "true");
            this.setTempDisplayText("Vse");
        } else if (lastButtonTouched.equalsIgnoreCase("2b")) {
            this.setLastButtonTouched(32);
            this.init("true", "false", "false", "false", "false");
            this.setTempDisplayText("Snidane");
        } else if (lastButtonTouched.equalsIgnoreCase("2c")) {
            this.setLastButtonTouched(33);
            this.init("false", "false", "true", "false", "false");
            this.setTempDisplayText("Obedy");
        } else if (lastButtonTouched.equalsIgnoreCase("2d")) {
            this.setLastButtonTouched(34);
            this.init("false", "false", "false", "false", "true");
            this.setTempDisplayText("Vecere");
        } else if (lastButtonTouched.equalsIgnoreCase("2e")) {
            if (this.getLastButtonTouched() == 35 && this.numberOfButtonTouched == 1) {
                this.init("false", "false", "false", "true", "false");
                this.setTempDisplayText("Zakusky");
                this.numberOfButtonTouched = 0;
            } else {
                this.init("false", "true", "false", "false", "false");
                this.setTempDisplayText("Svaciny");
                this.numberOfButtonTouched = 1;
            }
            this.setLastButtonTouched(35);
        } else if (lastButtonTouched.equalsIgnoreCase("2f")) {
            this.setLastButtonTouched(36);
        }
    }

    protected void setDisplayLastLine(String text) {
        this.getDisplay().setEXPosition(StringConvertor.internationalToEnglish(StringConvertor.addWhiteSpacesTo16(text)), 8);
        LOGGER.debug((Object)("*Display* dpos:8 " + this.getTempDisplayText()));
    }

    protected void setDisplayWeekLine(String text) {
        this.getDisplay().setEXPosition(StringConvertor.internationalToEnglish(StringConvertor.addWhiteSpacesTo16(text)), 8);
        LOGGER.debug((Object)("*Display* dpos:8 " + this.getTempDisplayText()));
    }

    public String getTerminalName() {
        return terminalName;
    }
}

