/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import universalrouter.comm.OrderLimit;
import universalrouter.database.SQLParam;
import universalrouter.terminals.TerminalBaseButton;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.termutils.Relation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TerminalBaseObjednavka
extends TerminalBaseButton
implements TerminalCommonInterface {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ENABLED = "enable";
    public static final String DISABLED = "disable";
    private String chipReadedForObjednavkaTerminal;
    protected static final char ZAKAZANY_SYMBOL = '*';

    protected void setChipReadedForObjednavkaTerminal(String chip) {
        this.chipReadedForObjednavkaTerminal = null;
        this.chipReadedForObjednavkaTerminal = chip;
    }

    protected String getChipReadedForObjednavkaTerminal() {
        return this.chipReadedForObjednavkaTerminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OrderLimit getLimit(int meal, int placeId, int interval) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT *, TIME(objednatdo) as objednatDo, TIME(zrusitdo) as zrusitDo FROM  rtr_sablony WHERE rtr_sablony.variant =" + meal + " AND " + " id_misto = " + placeId + " and (id_kategorie = 0 or id_kategorie = " + this.getUser().getKategorie() + ")" + " AND platiOd <= DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND platiDo >= DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) ORDER BY Priority DESC LIMIT 1");
            rs.beforeFirst();
            if (!rs.next()) {
                LOGGER.error((Object)"Nebyl nalezen limit");
                OrderLimit orderLimit = null;
                return orderLimit;
            }
            OrderLimit orderLimit = new OrderLimit(rs.getInt("daysObjednat"), rs.getInt("daysZrusit"), rs.getTime("objednatDo"), rs.getTime("zrusitDo"), rs.getBoolean("absolutelimitobjednat"), rs.getBoolean("absolutelimitzrusit"));
            return orderLimit;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            OrderLimit orderLimit = null;
            return orderLimit;
        }
        catch (NullPointerException ex) {
            OrderLimit orderLimit = null;
            return orderLimit;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
                rs = null;
            }
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (SQLException e) {}
                stm = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int orderSpecifiedDay(int interval, int mealid, int messes) {
        Statement stm = this.dbmanager.getStatement();
        try {
            int hasUserSpecifiedOrdered = this.hasUserSpecifiedOrdered(interval, mealid);
            if (hasUserSpecifiedOrdered > 1) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* Existuje objednavka StrID: " + this.getUser().getId() + " " + interval + " dni dopredu " + "ChdId:" + mealid + " objednavam +" + messes + "ks"));
                stm.executeUpdate("UPDATE tobjednavky, tchody SET Kusu=Kusu+" + messes + " " + "WHERE tchody.Chod_Id = tobjednavky.Chod_Id  AND " + "Objednavka_Id=" + hasUserSpecifiedOrdered);
                if (!this.rewritePrices(interval)) {
                    int n = -1;
                    return n;
                }
                int n = 1;
                return n;
            }
            if (hasUserSpecifiedOrdered == -1) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Obj* Neexistuje objednavka StrID: " + this.getUser().getId() + " " + interval + " dni dopredu " + "ChdId:" + mealid + " objednavam " + messes + "ks"));
                ArrayList<SQLParam> params = new ArrayList<SQLParam>();
                params.add(new SQLParam("Stravnik_Id", "" + this.getUser().getId(), "int"));
                params.add(new SQLParam("Vydejna_Id", "" + this.getPlaceID(), "int"));
                params.add(new SQLParam("Chod_Id", "" + mealid, "int"));
                params.add(new SQLParam("Kusu", "" + messes, "int"));
                params.add(new SQLParam("VlastChodu_Id", "" + this.getUser().getVlastnostChodu(), "int"));
                this.dbmanager.doPreparedStatement("INSERT into tobjednavky (Stravnik_Id, Jidelna_Id, Vydejna_Id, Datum, Chod_Id,Kusu, CasObj, ZdrojObj_Id, DatumObj, VlastChodu_Id) VALUES (?,0,?,DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY)," + "?, ?, CURTIME(), 4, CURDATE(), ?)", params);
                params.clear();
                if (!this.rewritePrices(interval)) {
                    int e = -1;
                    return e;
                }
                int e = 1;
                return e;
            }
            int n = -1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int cancelSpecifiedDay(int interval, int mealid, int messes) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            int hasUserSpecifiedOrdered = this.hasUserSpecifiedOrdered(interval, mealid);
            if (hasUserSpecifiedOrdered > 1) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "*Rus* Existuje objednavka StrID: " + this.getUser().getId() + " " + interval + " dni dopredu " + "ChdId:" + mealid + " rusim -" + messes + "ks"));
                rs = stm.executeQuery("SELECT * FROM tobjednavky WHERE Objednavka_Id = " + hasUserSpecifiedOrdered);
                rs.beforeFirst();
                if (!rs.next()) {
                    int n = -1;
                    return n;
                }
                if (rs.getInt("Kusu") > messes) {
                    stm.executeUpdate("UPDATE tobjednavky, tchody SET Kusu=Kusu-" + messes + " " + "WHERE tchody.Chod_Id = tobjednavky.Chod_Id  AND " + "Objednavka_Id=" + hasUserSpecifiedOrdered);
                    if (this.gs.isUseDonation() && !this.rewritePrices(interval)) {
                        int n = -1;
                        return n;
                    }
                } else {
                    stm.executeUpdate("DELETE FROM tobjednavky WHERE Stravnik_Id =" + this.getUser().getId() + " AND Objednavka_id = " + hasUserSpecifiedOrdered);
                    if (!this.rewritePrices(interval)) {
                        int n = -1;
                        return n;
                    }
                }
            } else {
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
            }
            catch (NullPointerException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {
            }
            catch (NullPointerException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Relation> getMealRelations(int meal, int placeId, int interval) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT hlavni_chod_id, zavisly_chod_id,automat,chody_cnt,  (SELECT SUM(kusu) FROM tobjednavky where vydejna_id = " + placeId + " AND chod_id = rtr_relace.hlavni_chod_id AND stravnik_id = " + this.getUser().getId() + " " + " AND platne >= 0 AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) GROUP BY stravnik_id) as pocetHlavni, " + " (SELECT SUM(kusu) FROM tobjednavky where vydejna_id = " + placeId + " AND chod_id = " + " rtr_relace.zavisly_chod_id AND stravnik_id = " + this.getUser().getId() + " AND datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND platne >= 0 " + " GROUP BY stravnik_id) as pocetZavisly FROM " + " rtr_sablony, rtr_relace WHERE rtr_sablony.relace_id=rtr_relace.relace_id " + " AND rtr_sablony.variant =" + meal + " AND " + " id_misto = " + placeId + " AND platiOd <= DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND platiDo >= DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) GROUP BY rtr_sablony.id, hlavni_chod_id, zavisly_chod_id, " + " rtr_relace.relace_id ORDER BY Priority");
            ArrayList<Relation> resultList = new ArrayList<Relation>();
            rs.beforeFirst();
            while (rs.next()) {
                resultList.add(new Relation(rs.getInt("hlavni_chod_id"), rs.getInt("zavisly_chod_id"), rs.getBoolean("automat"), rs.getInt("chody_cnt"), rs.getInt("pocetHlavni"), rs.getInt("pocetZavisly")));
            }
            ArrayList<Relation> arrayList = resultList;
            return arrayList;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            List<Relation> list = null;
            return list;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsCenik(String symbol) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT count(*) as pocet FROM tcenik JOIN tchody ON tchody.chod_id = tcenik.chod_id WHERE tcenik.kategorie_id = " + this.getUser().getKategorie() + " " + "AND ((tcenik.platnostcenydo >= CURDATE()) OR (tcenik.platnostcenydo IS NULL)) " + "AND SymbolTerminalu = '" + symbol + "' ");
            if (rs.next()) {
                boolean bl = rs.getInt("pocet") > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsCenikByNumber(int number) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT count(*) as pocet FROM tcenik JOIN tchody ON tchody.chod_id = tcenik.chod_id WHERE tcenik.kategorie_id = " + this.getUser().getKategorie() + " " + "AND ((tcenik.platnostcenydo >= CURDATE()) OR (tcenik.platnostcenydo IS NULL)) " + "AND CisloChodu = " + number);
            if (rs.next()) {
                boolean bl = rs.getInt("pocet") > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }
}

