/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Calendar;
import universalrouter.terminals.TerminalBase;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.util.StringConvertor;

public abstract class TerminalBaseButton
extends TerminalBase
implements TerminalCommonInterface {
    private int mealId = 0;
    private int lastButtonTouched;

    protected void setMealId(int meal) {
        this.mealId = meal;
    }

    protected int getMealId() {
        return this.mealId;
    }

    public int getLastButtonTouched() {
        return this.lastButtonTouched;
    }

    protected void setLastButtonTouched(int lbt) {
        this.lastButtonTouched = lbt;
    }

    protected String sumMealPriceString(int numberOfMeals, int interval, int meal) {
        if (this.getUser() == null) {
            return "000.00";
        }
        DecimalFormat myFormatter = new DecimalFormat("###.##");
        return myFormatter.format(this.sumMealPrice(numberOfMeals, interval, meal));
    }

    protected double sumMealPrice(int numberOfMeals, int interval, int meal) {
        double mealPrice = 0.0;
        for (int i = 0; i < numberOfMeals; ++i) {
            mealPrice += this.getMealPrice(meal, this.getUser().getId(), interval, i);
        }
        return mealPrice;
    }

    protected double getMealPrice(int cid, int idStravnik, int interval, int numberOfMeals) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, interval);
        return this.getSelectDao().getMealPriceByChod(calendar.getTime(), idStravnik, cid, numberOfMeals);
    }

    protected int checkCredit(int numberOfMeals, int interval, int meal) {
        double mealPrice;
        if (this.getUser().isKontrolovatKredit()) {
            mealPrice = this.sumMealPrice(numberOfMeals, interval, meal);
        } else {
            try {
                mealPrice = this.sumMealPrice(numberOfMeals, interval, meal) + this.getUser().getMaxKredit();
            }
            catch (Exception e) {
                mealPrice = -100000.0;
                LOGGER.error((Object)(this.getTerminalID() + "Nepodarilo se zjistit limit kreditu pro konkretniho stravnika, nastaven na 100000"));
            }
        }
        if (this.getCredit(this.getUser().getId()) >= mealPrice) {
            return 1;
        }
        LOGGER.info((Object)(this.getTerminalID() + " " + "Uzivatel UsrID: " + this.getUser().getId() + "nema dostatek kreditu na objednani tohoto jidla ChID:" + meal));
        return -3;
    }

    protected int getMealOnButton() {
        return this.getMealOnButtonByTerminal(this.getLastButtonTouched(), this.getTerminalID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMealOnButtonByTerminal(int buttonId, int terminalId) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            stm.execute("SET NAMES 'utf8'");
            rs = stm.executeQuery("SELECT *, tchody.ChodTxt, tchody.CisloChodu, tchody.Chod_Id FROM rtr_buttons, tchody WHERE terminal_id =" + terminalId + " AND" + " button =" + buttonId + " AND rtr_buttons.meal_id = tchody.chod_id ");
            rs.beforeFirst();
            if (!rs.next()) {
                LOGGER.warn((Object)(this.getTerminalID() + " " + "Neni nadefinovane zadne jidlo na tlacitku " + this.getLastButtonTouched()));
                this.getDisplay().nullDisplay();
                this.setSegment((byte)0);
                this.setMealId(0);
                this.setTempDisplayText("\u0160patn\u00e9 tla\u010d\u00edtko");
                int n = -1;
                return n;
            }
            this.setMealId(rs.getInt("meal_id"));
            this.setSegment(rs.getByte("CisloChodu"));
            this.setTempDisplayText(StringConvertor.latin1ToUTF(rs.getString("ChodTxt")));
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            LOGGER.error((Object)(this.getTerminalID() + "Chyba pri parovani tlacitka s jidlem"));
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isMealForUserForbidden(int meal) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "select * from tzasji WHERE Stravnik_Id = " + this.getUser().getId() + " " + "AND chod_id = " + meal + "";
            rs = stm.executeQuery(sql);
            sql = null;
            if (!rs.next()) {
                LOGGER.debug((Object)(this.getTerminalID() + " " + "Stravnik nema chod " + meal + " zakazany"));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUserTypeOrdered(int interval, int meal) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "select * from tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id=tchody.chod_id WHERE Stravnik_Id = " + this.getUser().getId() + " " + "AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND " + "tchody.SymbolTerminalu = " + "(SELECT SymbolTerminalu FROM tchody WHERE chod_id = " + meal + " LIMIT 1) " + "AND platne >= 0";
            rs = stm.executeQuery(sql);
            sql = null;
            if (!rs.next()) {
                LOGGER.debug((Object)(this.getTerminalID() + " " + "Stravnik jeste nema tento typ objednavky"));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUserAnyOrdered(int interval) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "select * from tobjednavky LEFT JOIN tchody ON tobjednavky.chod_id=tchody.chod_id WHERE Stravnik_Id = " + this.getUser().getId() + " " + "AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "AND platne >= 0";
            rs = stm.executeQuery(sql);
            if (!rs.next()) {
                LOGGER.debug((Object)(this.getTerminalID() + " " + "Stravnik jeste nema tento typ objednavky"));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMaxMesses(int interval, int meal) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("select jidel_max from jidlo LEFT JOIN tchody ON jidlo.cid=tchody.Chod_Id WHERE Id_misto = " + this.getPlaceID() + " AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND cid = " + meal);
            if (!rs.next()) {
                LOGGER.warn((Object)(this.getTerminalID() + " " + "Nezjisten maximalni pocet jidel"));
                int n = 0;
                return n;
            }
            int n = rs.getInt("jidel_max");
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)(this.getTerminalID() + "Chyba v SQL dotazu. Prosim overte jeho spravnost."), (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int hasUserSpecifiedOrdered(int interval, int meal) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "select * from tobjednavky WHERE Stravnik_Id = " + this.getUser().getId() + " AND Vydejna_Id = " + this.getPlaceID() + " " + "AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND platne >= 0";
            if (meal > 0) {
                sql = sql + " AND chod_id = " + meal;
            }
            rs = stm.executeQuery(sql);
            sql = null;
            if (!rs.next()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Stravnik StrId:" + this.getUser().getId() + " nema objednavku na vydejne" + " VydId:" + this.getPlaceID() + " " + interval + " dni dopredu"));
                int n = -1;
                return n;
            }
            if (rs.getInt("Kusu") > rs.getInt("VydanoKusu")) {
                int n = rs.getInt("Objednavka_Id");
                return n;
            }
            int n = -rs.getInt("Objednavka_Id");
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)(this.getTerminalID() + "Chyba v SQL dotazu. Prosim overte jeho spravnost."), (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getOrderedMessesCount(int interval, int meal) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT SUM(Kusu) as ks FROM tobjednavky JOIN tchody ON tobjednavky.chod_id = tchody.chod_id WHERE (tobjednavky.Chod_Id=" + meal + " OR tchody.SkupChodu_id = (SELECT SkupChodu_id from tchody where chod_id = " + meal + ")) AND " + "Datum=DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND platne >= 0 AND tobjednavky.vydejna_Id = " + this.getPlaceID());
            if (!rs.next()) {
                LOGGER.warn((Object)(this.getTerminalID() + " " + "Nezjisten pocet objednanych jidel"));
                int n = 0;
                return n;
            }
            int n = rs.getInt("ks");
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)(this.getTerminalID() + "Chyba v SQL dotazu. Prosim overte jeho spravnost."), (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int isSpecifiedJidelnicek(int interval, int meal, boolean checkVisibility) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = "select * from jidlo LEFT JOIN tchody ON jidlo.cid=tchody.Chod_Id WHERE Id_misto = " + this.getPlaceID() + " AND Datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) AND schvaleno = 1 AND cid = " + meal;
            if (checkVisibility) {
                sql = sql + " AND ZobrazitChod=1 ";
            }
            if (!(rs = stm.executeQuery(sql)).next()) {
                LOGGER.error((Object)(this.getTerminalID() + " " + "Neni vypsan jidelnicek a je zapnuta jeho kontrola"));
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }
}

