/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import universalrouter.terminals.JdbcSelectDao;
import universalrouter.terminals.TerminalBaseDao;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.terminals.TerminalCommonModel;
import universalrouter.termutils.MealOrder;
import universalrouter.user.User;
import universalrouter.util.StringConvertor;

@Configurable
public abstract class TerminalBase
extends TerminalCommonModel
implements TerminalCommonInterface {
    public static final char BEEP_SHORT = '1';
    public static final char BEEP_LONG = 'F';
    public static final char ADDITIONAL_DISPLAY_SHOW = '0';
    public static final char ADDITIONAL_DISPLAY_DONT_SHOW = '1';
    @Autowired
    private JdbcSelectDao selectDao;
    @Autowired
    private TerminalBaseDao terminalBaseDao;
    private ApplicationContext applicationContext;
    protected static final Logger LOGGER = Logger.getLogger(TerminalBase.class);
    protected String command;
    private int myAddress = 1;
    private MealOrder mealOrder;
    private String tempDisplayText;
    protected byte adr;
    protected int terminalType;
    private static final String NON_MESSES = "0000";

    public void init() {
        if (this.applicationContext != null) {
            this.setSelectDao((JdbcSelectDao)((Object)this.applicationContext.getBean("selectDao")));
            this.setTerminalBaseDao((TerminalBaseDao)((Object)this.applicationContext.getBean("terminalBaseDao")));
        }
    }

    protected void setMealOrder(MealOrder mealOrder) {
        this.mealOrder = mealOrder;
    }

    protected MealOrder getMealOrder() {
        return this.mealOrder;
    }

    protected void setTempDisplayText(String t) {
        this.tempDisplayText = t;
    }

    public String getTempDisplayText() {
        return this.tempDisplayText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int basePrimaryCheck(byte[] byteBuffer) {
        String ord;
        byte[] b3;
        try {
            LOGGER.debug((Object)"zahajuji basePrimaryCheck");
            this.adr = byteBuffer[0];
            this.command = new String(byteBuffer, 2, 1);
            int length = new Integer(byteBuffer[1]);
            b3 = new byte[length];
            System.arraycopy(byteBuffer, 0, b3, 0, length);
            ord = StringConvertor.hexToString(b3);
            if (ord.length() <= 14) {
                LOGGER.fatal((Object)("Nastala kriticka chyba pri komunikaci. Byl ocekavan kod cipu, ale pravdepodobne nebyl v retezci prijat. Zkontrolujte prosim delku retezce: " + ord));
                this.setTempDisplayText(null);
                this.getDisplay().nullDisplay();
                int n = -1;
                return n;
            }
            this.setChipCode(ord.substring(6, 14));
            if (this.gs.isWatchTerminals()) {
                this.updateWatchDatabase(this.getTerminalID());
            }
            int n = 1;
            return n;
        }
        finally {
            b3 = null;
            ord = null;
            byteBuffer = null;
        }
    }

    protected int sendMessesIgnoreVolume() {
        if (this.isSignalFromDisplay()) {
            if (this.getChipCode().substring(0, 2).compareTo("7a") == 0) {
                this.getDisplay().nullDisplay();
                LOGGER.debug((Object)"Pocitam porce - zacatek");
                this.getDisplay().setClear(true);
                this.getDisplay().setEXPosition(this.getRestMess(1), 4);
                this.getDisplay().setEXPosition(this.getRestMess(2), 5);
                LOGGER.debug((Object)"Pocitam porce - konec");
                return -2;
            }
            if (this.getChipCode().substring(0, 2).compareTo("7b") == 0 || this.getChipCode().substring(0, 2).compareTo("7c") == 0) {
                LOGGER.debug((Object)"Hledam cip podle cisla uzivatele");
                Integer evidenceNumber = new Integer(this.getChipCode().substring(2));
                try {
                    this.setChipCode(this.terminalBaseDao.getChipCodeByUserEvidenceNumber(evidenceNumber));
                }
                catch (IncorrectResultSizeDataAccessException ex) {
                    this.setChipCode(null);
                }
                if (this.getChipCode() == null) {
                    this.setChipCode("#" + evidenceNumber);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int extendedPrimaryCheck() {
        try {
            LOGGER.debug((Object)"Zahajujui extendedPrimaryCheck:");
            int icid = this.isChipInDatabase(this.getChipCode());
            if (icid == -1) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Cip: " + this.getChipCode() + " nebyl nalezen v databazi"));
            } else {
                LOGGER.debug((Object)(this.getTerminalID() + " " + "Cip: " + this.getChipCode() + " nalezen v databazi"));
            }
            boolean repeated = false;
            if (this.sendedTwice(this.adr)) {
                repeated = true;
                if (icid == this.getChipID()) {
                    LOGGER.warn((Object)"Cipy se rovnaji, opravdu musim poslat stara data");
                    int n = -4;
                    return n;
                }
                LOGGER.warn((Object)"Cipy se nerovnaji, Neprijata data");
            }
            this.setTempDisplayText(null);
            this.getDisplay().nullDisplay();
            if (!repeated && !this.isForMe(this.adr)) {
                int n = -2;
                return n;
            }
            this.setChipID(icid);
            if (this.getChipID() == -1) {
                this.setSegment((byte)14);
                String chipCode = this.getChipCode();
                char segment = (char)this.getSegment();
                this.nullData();
                this.setChipCode(chipCode);
                if (this.getHasTerminalDisplay()) {
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getChipCode()), 1);
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo14("\u010cip nenalezen") + (char)this.getSegment() + '0' + 'F', 3);
                }
                LOGGER.info((Object)"Neznamy cip");
                int n = 0;
                return n;
            }
            if (this.command.compareTo("H") != 0) {
                this.setSegment((byte)14);
                this.nullData();
                LOGGER.error((Object)("Neznamy prikaz: " + this.command));
                int n = -1;
                return n;
            }
            if (this.createUser(icid) != 1) {
                this.setSegment((byte)14);
                if (this.getHasTerminalDisplay()) {
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getChipCode()), 1);
                    this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo14("Cip nenalezen") + (char)this.getSegment() + '0' + 'F', 3);
                }
                LOGGER.info((Object)"Nebylo mozne vytvorit objekt uzivatele. Pravdepodobne nastala nekonzistence v programu");
                int n = 0;
                return n;
            }
            LOGGER.debug((Object)"Uzivatel uspesne vytvoren");
            this.setMealBeep('1');
            int n = 1;
            return n;
        }
        finally {
            this.command = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int extendedPrimaryCheckForMarkTime() {
        try {
            boolean repeated = false;
            if (this.sendedTwice(this.adr)) {
                repeated = true;
            }
            if (!repeated && !this.isForMe(this.adr)) {
                int n = -2;
                return n;
            }
            if (this.command.compareTo("H") != 0) {
                this.setSegment((byte)14);
                this.nullData();
                LOGGER.error((Object)("Neznamy prikaz: " + this.command));
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            this.command = null;
        }
    }

    protected boolean isForMe(byte adress) {
        return this.myAddress == adress;
    }

    protected boolean sendedTwice(byte adress) {
        return this.myAddress == adress - 50;
    }

    public String getRestMess(int order) {
        return this.getRestMess(this.getTerminalID(), this.getPlaceID(), order);
    }

    protected void setInformationDisplay() {
        this.getDisplay().nullDisplay();
        if (this.getUser() != null) {
            this.getDisplay().setEXPosition(StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())), 2);
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getUser().getName()), 1);
            LOGGER.debug((Object)(this.getTerminalID() + " *Display* dpos:1 " + StringConvertor.addWhiteSpacesTo16(this.getUser().getName())));
        }
        String str = StringConvertor.addWhiteSpacesTo14(this.getTempDisplayText()) + (char)this.getSegment() + '0' + this.getMealBeep();
        this.getDisplay().setEXPosition(str, 3);
        LOGGER.debug((Object)(this.getTerminalID() + " *Display* dpos:3 " + str));
        str = null;
        if (this.gs.isRunMesses()) {
            this.getDisplay().setEXPosition(this.getRestMess(1), 4);
            this.getDisplay().setEXPosition(this.getRestMess(2), 5);
        }
    }

    protected double getCredit(int idStravnik) {
        return this.getSelectDao().getCredit(idStravnik, this.gs.isUseDonation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createUser(int chipCode) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        LOGGER.debug((Object)"Vytvarim objekt uzivatele");
        try {
            stm.execute("SET NAMES 'utf8'");
            rs = stm.executeQuery("SELECT tstravnici.*, tstravnicistat.defaultVydejna, tstravnicistat.fixvyd, tstravnicistat.StravnikJmeno, tstravnicistat.StravnikPrijmeni,  tkategorie.specialniPravidlo, tstravnicistat.DefVlastChodu_id   FROM tstravnici JOIN tstravnicistat ON tstravnici.Stravnik_Id = tstravnicistat.Stravnik_Id  JOIN tkategorie ON tkategorie.kategorie_id = tstravnici.kategorie_id  WHERE Cip_Id = " + chipCode + " AND tstravnici.platnostOd <= CURDATE() AND (tstravnici.platnostDo >= CURDATE() OR " + " tstravnici.platnostDo = '0000-00-00' OR tstravnici.platnostDo IS null)");
            rs.beforeFirst();
            if (!rs.next()) {
                this.setUser(null);
                LOGGER.info((Object)(this.getTerminalID() + " " + "Neexistuje osoba s cipem cislo: " + chipCode));
                int n = -1;
                return n;
            }
            this.setUser(new User(StringConvertor.latin1ToUTF(rs.getString("StravnikJmeno")), StringConvertor.latin1ToUTF(rs.getString("StravnikPrijmeni")), rs.getInt("Stravnik_Id"), rs.getInt("Kategorie_Id"), rs.getBoolean("simulacekr"), rs.getDouble("limitkr"), rs.getInt("specialniPravidlo"), rs.getInt("DefVlastChodu_id"), rs.getBoolean("Hromadny"), rs.getBoolean("fixvyd"), rs.getInt("defaultVydejna")));
            LOGGER.info((Object)(this.getTerminalID() + " " + "Byl nalezen uzivatel s timto cipem UsrId: " + this.getUser().getId()));
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            LOGGER.error((Object)(this.getTerminalID() + "Nebyl nalezen zadny uzivatel s udanym cipem"), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rewritePrices(int userId, int interval) {
        int tmDat = -1;
        int tmTyp = -1;
        int mxKusuTyp = 0;
        int mxKusuDot = 0;
        int pocDot = 0;
        int pocDotTyp = 0;
        int kusu = 0;
        int resultKusuC1 = 0;
        int resultKusuC2 = 0;
        Statement stm = this.dbmanager.getStatement();
        Statement stm1 = this.dbmanager.getStatement();
        ResultSet rs = null;
        try {
            rs = stm.executeQuery("SELECT TObj.objednavka_id, TCen.dotchod,  TS.stravnik_id, extract(day from datum) as Day,tkategorie.pocetdot,  TCh.TypChodu, TCen.PocetKusuDo, TCh.ChodTxt, TObj.Kusu, TObj.KusuC1,  TObj.KusuC2, TCen.Cena1VcetneDPH, SUM(IFNULL(TObj.KusuC1,0) * TCen.Cena1VcetneDPH) AS Celkem FROM tcenik AS TCen  LEFT JOIN tobjednavky AS TObj  ON (TObj.Stravnik_Id = " + userId + ") AND (TCen.Chod_Id = TObj.Chod_Id)" + " LEFT JOIN tstravnici AS TS" + " ON (TS.Kategorie_Id = TCen.Kategorie_Id) AND (TCen.PocetKusu = 1) " + " and ((TCen.PlatnostCenyOd <= TObj.Datum) and  " + " ((TCen.PlatnostCenyDo >= TObj.Datum) or (TCen.PlatnostCenyDo is null ))) " + " and (TS.stravnik_id = " + userId + ")" + " LEFT JOIN tkategorie " + " on TS.kategorie_id = tkategorie.kategorie_id" + " LEFT JOIN tchody AS TCh" + " ON (TCh.Chod_Id = TObj.Chod_Id)" + " WHERE  (TObj.Datum = DATE_ADD(CURDATE(),INTERVAL " + interval + " DAY))" + " AND (((TObj.Datum <=TS.PlatnostDo) OR (TS.PlatnostDo IS NULL) OR " + "(TS.PlatnostDo = '0000-00-00') ) AND (TObj.Datum >=TS.PlatnostOd)) " + "AND TObj.platne >= 0 " + "GROUP BY TObj.Datum, TS.Kategorie_Id, TCh.Chod_id,TS.Stravnik_Id, TObj.vydejna_id " + "ORDER BY TS.Stravnik_Id, TObj.Datum, TCh.PrioritaC12, TObj.objednavka_id, TCh.TypChodu");
            rs.beforeFirst();
            int objednavka_id = 0;
            LOGGER.debug((Object)"Prepocet zahajen");
            while (rs.next()) {
                int dat = rs.getInt("Day");
                int typ = rs.getInt("TypChodu");
                kusu = rs.getInt("Kusu");
                if (tmDat != dat) {
                    mxKusuDot = rs.getInt("pocetDot");
                    mxKusuTyp = rs.getInt("pocetKusuDo");
                    pocDot = mxKusuDot;
                    pocDotTyp = mxKusuTyp;
                    tmTyp = typ;
                    tmDat = dat;
                }
                if (tmTyp != typ) {
                    pocDotTyp = rs.getInt("pocetKusuDo");
                    tmTyp = typ;
                }
                if (rs.getBoolean("DotChod") && kusu <= pocDot) {
                    if (pocDotTyp == 0 && mxKusuTyp == 0) {
                        resultKusuC1 = 0;
                        resultKusuC2 = kusu;
                    } else if (kusu <= pocDotTyp) {
                        resultKusuC1 = kusu;
                        resultKusuC2 = 0;
                        pocDotTyp -= kusu;
                    } else if (kusu > pocDotTyp) {
                        resultKusuC1 = pocDotTyp;
                        resultKusuC2 = kusu - pocDotTyp;
                        pocDotTyp = 0;
                    }
                    pocDot -= resultKusuC1;
                } else if (rs.getBoolean("DotChod")) {
                    if (pocDot == 0 && mxKusuDot == 0) {
                        resultKusuC1 = 0;
                        resultKusuC2 = kusu;
                    } else {
                        if (pocDotTyp > pocDot) {
                            resultKusuC1 = pocDot;
                            resultKusuC2 = kusu - pocDot;
                        } else {
                            resultKusuC1 = pocDotTyp;
                            resultKusuC2 = kusu - pocDotTyp;
                        }
                        pocDot = 0;
                    }
                } else {
                    resultKusuC1 = 0;
                    resultKusuC2 = kusu;
                }
                objednavka_id = rs.getInt("objednavka_id");
                stm1.execute("UPDATE tobjednavky SET KusuC1 = " + resultKusuC1 + ", " + "KusuC2 = " + resultKusuC2 + " WHERE objednavka_id =" + objednavka_id);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Chypa pri uprave poctu dotovanych kusu", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (SQLException e) {}
            }
            stm = null;
            if (stm1 != null) {
                try {
                    stm1.close();
                }
                catch (SQLException e) {}
                stm1 = null;
            }
        }
    }

    protected boolean rewritePrices(int interval) {
        return this.rewritePrices(this.getUser().getId(), interval);
    }

    protected void setInformationDisplayNM(boolean clear) {
        this.getDisplay().setClear(clear);
        if (this.getUser() != null) {
            this.getDisplay().setEXPosition(StringConvertor.addKredit("" + this.getCredit(this.getUser().getId())), 2);
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getUser().getName()), 1);
            LOGGER.debug((Object)(this.getTerminalID() + " *Display* dpos:1 " + this.getUser().getName()));
        }
        if (this.getTempDisplayText() != null) {
            this.getDisplay().setEXPosition(StringConvertor.addWhiteSpacesTo16(this.getTempDisplayText()), 6);
            LOGGER.debug((Object)(this.getTerminalID() + " *Display* dpos:6 " + this.getTempDisplayText()));
        }
    }

    protected boolean hasUserOrdered(int chipCode) {
        return this.hasUserOrdered(chipCode, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasUserOrdered(int chipCode, boolean timeLimited, int interval) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            String sql = timeLimited ? "select tobjednavky.vydejna_id, tobjednavky.objednavka_id, tobjednavky.stravnik_id, rtr_symbols.symbol as specialSymbol, tchody.cislochodu, tchody.chodTxt, tchody.ZkratkaChodu, tkategorie.velikostPorce, tstravnici.kategorie_id, tobjednavky.datum,TSab.priority,tobjednavky.kusu,tobjednavky.vydanokusu, tobjednavky.chod_id,tobjednavky.VydejPosledniCas,vydejod,vydejdo, offsetVelikosti, ZkratkaVlast from tobjednavky JOIN rtr_sablony TSab ON (tobjednavky.chod_id = TSab.variant and tobjednavky.vydejna_id = TSab.id_misto) LEFT JOIN tstravnici ON ((TSab.id_kategorie = 0) or (TSab.id_kategorie = tstravnici.kategorie_id)) LEFT JOIN tchody ON tobjednavky.Chod_Id = tchody.Chod_Id LEFT JOIN tkategorie ON tstravnici.kategorie_id = tkategorie.kategorie_id LEFT JOIN rtr_offsetvelikosti ON tkategorie.velikostPorce = rtr_offsetvelikosti.velikostPorce LEFT JOIN tvlastchodu ON tobjednavky.vlastchodu_id = tvlastchodu.vlastchodu_id LEFT JOIN rtr_symbols ON rtr_symbols.chod_id = tchody.chod_id AND (tkategorie.velikostPorce = rtr_symbols.velikostPorce or rtr_symbols.velikostPorce = 0) AND (rtr_symbols.VlastnostChodu_Id = tobjednavky.vlastChodu_id OR rtr_symbols.vlastnostChodu_Id = null) AND (indexCeny = 0 or rtr_symbols.indexCeny = IF((tobjednavky.kusuc1 = 1),1,2))where tobjednavky.stravnik_id = " + this.getUser().getId() + " and tobjednavky.datum = CURDATE() " + "and curtime() between time(TSab.vydejod) and time(TSab.vydejdo) " + "and (curdate() >= tstravnici.platnostod and (curdate() <= tstravnici.platnostdo) " + "or tstravnici.platnostdo = '00-00-00' or tstravnici.platnostdo is null) and tobjednavky.stravnik_id = tstravnici.stravnik_id " + "and tobjednavky.platne >= 0 " + "group by tobjednavky.chod_id ORDER BY priority desc, VydejPosledniCas DESC" : "select tobjednavky.vydejna_id, tobjednavky.objednavka_id, tobjednavky.stravnik_id, rtr_symbols.symbol as specialSymbol, tchody.cislochodu, tchody.chodTxt, tchody.ZkratkaChodu, tkategorie.velikostPorce, tstravnici.kategorie_id, tobjednavky.datum,TSab.priority,tobjednavky.kusu,tobjednavky.vydanokusu, tobjednavky.chod_id,tobjednavky.VydejPosledniCas,vydejod,vydejdo, offsetVelikosti, ZkratkaVlast from tobjednavky JOIN rtr_sablony TSab ON (tobjednavky.chod_id = TSab.variant and tobjednavky.vydejna_id = TSab.id_misto) LEFT JOIN tstravnici ON ((TSab.id_kategorie = 0) or (TSab.id_kategorie = tstravnici.kategorie_id)) LEFT JOIN tchody ON tobjednavky.Chod_Id = tchody.Chod_Id LEFT JOIN tkategorie ON tstravnici.kategorie_id = tkategorie.kategorie_id LEFT JOIN rtr_offsetvelikosti ON tkategorie.velikostPorce = rtr_offsetvelikosti.velikostPorce LEFT JOIN tvlastchodu ON tobjednavky.vlastchodu_id = tvlastchodu.vlastchodu_id LEFT JOIN rtr_symbols ON rtr_symbols.chod_id = tchody.chod_id AND (tkategorie.velikostPorce = rtr_symbols.velikostPorce or rtr_symbols.velikostPorce = 0) AND (rtr_symbols.VlastnostChodu_Id = tobjednavky.vlastChodu_id OR rtr_symbols.vlastnostChodu_Id = null) AND (indexCeny = 0 or rtr_symbols.indexCeny = IF((tobjednavky.kusuc1 = 1),1,2))where tobjednavky.stravnik_id = " + this.getUser().getId() + " and tobjednavky.datum = DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) " + "and (DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) >= tstravnici.platnostod and (DATE_ADD(CURDATE(), INTERVAL " + interval + " DAY) <= tstravnici.platnostdo) " + "and tobjednavky.platne >= 0 " + "or tstravnici.platnostdo = '00-00-00' or tstravnici.platnostdo is null) and tobjednavky.stravnik_id = tstravnici.stravnik_id " + "group by tobjednavky.chod_id ORDER BY priority desc, VydejPosledniCas DESC";
            rs = stm.executeQuery(sql);
            rs.beforeFirst();
            int pocetZaznamu = 0;
            String seznamObjednavek = "";
            while (rs.next()) {
                if (rs.getInt("Kusu") > rs.getInt("VydanoKusu")) {
                    ++pocetZaznamu;
                    seznamObjednavek = seznamObjednavek + " | Obj:" + rs.getInt("Objednavka_Id");
                    continue;
                }
                seznamObjednavek = seznamObjednavek + " | Vyd:" + rs.getInt("Objednavka_Id");
            }
            rs.beforeFirst();
            int hasOrdered = -1;
            int order = 0;
            this.getCredit(this.getUser().getId());
            while (rs.next()) {
                LOGGER.info((Object)(this.getTerminalID() + " " + "Objednavky UsrId:(" + this.getUser().getId() + "):" + seznamObjednavek));
                if (rs.getInt("Kusu") > rs.getInt("VydanoKusu")) {
                    LOGGER.info((Object)(this.getTerminalID() + " " + "Nalezena objednavka na den:" + rs.getString("Datum") + " ObjId: " + rs.getInt("Objednavka_Id") + " " + rs.getString("ChodTxt")));
                    if ((this.isTerminalMealAlowed(rs.getInt("Objednavka_Id"), this.getTerminalID()) == -1 || rs.getInt("vydejna_id") != this.placeID) && this.getType() != 31 && this.getType() != 32 && this.getType() != 3 && this.getType() != 311) {
                        if (hasOrdered == 1) continue;
                        LOGGER.info((Object)(this.getTerminalID() + " ObjId: " + rs.getInt("Objednavka_Id") + " neni povoleno na TermId:" + this.getTerminalID()));
                        this.setSegment((byte)11);
                        hasOrdered = -3;
                        order = rs.getInt("Objednavka_Id");
                        continue;
                    }
                    hasOrdered = 1;
                    order = rs.getInt("Objednavka_Id");
                    if (this.getType() == 13) {
                        this.setSegment(rs.getByte("CisloChodu"));
                        this.setTempDisplayText(rs.getString("ZkratkaChodu") + " " + StringConvertor.latin1ToUTF(rs.getString("ZkratkaVlast")));
                        LOGGER.debug((Object)"Nastavuji vlastnost vydavaneho chodu");
                        if (rs.getString("velikostPorce") != null && rs.getInt("velikostPorce") != 0) {
                            this.setSegment((byte)(this.getSegment() + rs.getInt("offsetVelikosti")));
                            LOGGER.debug((Object)("Nastavuji offset velikosti porce o " + rs.getInt("offsetVelikosti")));
                        }
                        if (rs.getObject("specialSymbol") == null) continue;
                        this.setSegment(rs.getByte("specialSymbol"));
                        LOGGER.debug((Object)("Nastavuji zvlastni symbol z rtr_symbols: " + rs.getInt("offsetVelikosti")));
                        continue;
                    }
                    if (this.getType() != 31 && this.getType() != 32 && this.getType() != 3 && this.getType() != 311 || pocetZaznamu == 1) {
                        this.setSegment(rs.getByte("CisloChodu"));
                        if (rs.getInt("Kusu") - rs.getInt("VydanoKusu") > 1) {
                            this.setTempDisplayText(StringConvertor.latin1ToUTF(rs.getString("ChodTxt")) + ":" + (rs.getInt("Kusu") - rs.getInt("VydanoKusu")) + "/" + rs.getInt("Kusu") + "ks");
                        } else if (rs.getString("velikostPorce") != null && rs.getInt("velikostPorce") != 0) {
                            this.setTempDisplayText("P>" + rs.getString("velikostPorce") + " " + StringConvertor.latin1ToUTF(rs.getString("ChodTxt")));
                            this.setSegment((byte)(this.getSegment() + rs.getInt("offsetVelikosti")));
                            LOGGER.debug((Object)("Nastavuji offset velikosti porce o " + rs.getInt("offsetVelikosti")));
                        } else {
                            this.setTempDisplayText(StringConvertor.latin1ToUTF(rs.getString("ChodTxt")));
                        }
                        if (rs.getObject("specialSymbol") == null) continue;
                        this.setSegment(rs.getByte("specialSymbol"));
                        LOGGER.debug((Object)("Nastavuji zvlastni symbol z rtr_symbols: " + rs.getInt("offsetVelikosti")));
                        continue;
                    }
                    this.setSegment((byte)29);
                    if (this.getTempDisplayText() == null) {
                        this.setTempDisplayText(rs.getString("ZkratkaChodu") + ":" + (rs.getInt("Kusu") - rs.getInt("VydanoKusu")));
                        continue;
                    }
                    this.setTempDisplayText(this.getTempDisplayText() + ";" + rs.getString("ZkratkaChodu") + ":" + (rs.getInt("Kusu") - rs.getInt("VydanoKusu")));
                    continue;
                }
                if (hasOrdered != -3 && hasOrdered != 1) {
                    hasOrdered = -2;
                    order = rs.getInt("Objednavka_Id");
                    this.getMealOrder().setMealName(rs.getString("VydejPosledniCas") + "--" + rs.getString("ZkratkaChodu") + ":" + rs.getInt("Kusu") + "ks");
                    this.getMealOrder().setRequestTime(rs.getString("VydejPosledniCas"));
                    LOGGER.debug((Object)(this.getTerminalID() + " " + "jen vydane: " + order));
                    continue;
                }
                LOGGER.debug((Object)(this.getTerminalID() + " " + "vydane, ale take v poradku: " + order));
            }
            LOGGER.info((Object)(this.getTerminalID() + " Vysledek = ObjId: " + order + " rsId:" + hasOrdered));
            this.getMealOrder().setOrder(order, hasOrdered);
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba v SQL dotazu. Prosim overte jeho spravnost.", (Throwable)ex);
            this.getMealOrder().setOrder(0, -99);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore) {}
            }
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isChipInDatabase(String chipCode) {
        ResultSet rs = null;
        LOGGER.debug((Object)this.dbmanager.toString());
        Statement stm = this.dbmanager.getStatement();
        LOGGER.debug((Object)"Hledam cip v databazi");
        try {
            rs = stm.executeQuery("SELECT * FROM tcipy WHERE CipKod = '" + chipCode + "' AND CipStav <> 2");
            rs.beforeFirst();
            if (!rs.next()) {
                int n = -1;
                return n;
            }
            int n = rs.getInt("Cip_Id");
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWatchDatabase(int terminalId) {
        Statement stm = this.dbmanager.getStatement();
        try {
            stm.execute("UPDATE rtr_terminals SET watchStamp=NOW() WHERE ID=" + terminalId);
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri ukladani updateWatch do databaze.", (Throwable)ex);
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException sQLException) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestMeal(int hasUserSpecifiedOrdered) {
        Statement stm = this.dbmanager.getStatement();
        try {
            LOGGER.debug((Object)("Stravnik jiz ma objednavku ObjednavkaId:" + hasUserSpecifiedOrdered));
            stm.executeUpdate("UPDATE tobjednavky SET VydanoKusu=VydanoKusu + 1, VydejPrvniDatum = CURDATE(), vydejPrvniCas = CURTIME(), VydejPosledniDatum = CURDATE(), vydejPosledniCas = CURTIME(), VydanoZdroj = 4 WHERE Objednavka_Id=" + hasUserSpecifiedOrdered);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Nepodarilo se oznacit ", (Throwable)e);
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException sQLException) {}
            stm = null;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isTerminalMealAlowed(int objednavkaId, int terminalId) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM rtr_meals, tobjednavky WHERE tobjednavky.objednavka_id =" + objednavkaId + " AND terminal_id = " + terminalId + " AND chod_id = meal_id " + " AND ((curtime() between time(vydejod) AND time(vydejdo)) OR vydejod IS NULL OR vydejdo IS NULL " + " OR time(vydejod)='00:00:00' OR time(vydejdo)='00:00:00')");
            rs.beforeFirst();
            if (!rs.next()) {
                LOGGER.debug((Object)(terminalId + " Objednavku: " + objednavkaId + " nelze vydat na tomto terminalu: " + terminalId));
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
            int n = -99;
            return n;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            rs = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRestMess(int terminalId, int placeId, int order) {
        ResultSet rs = null;
        Statement stm = this.dbmanager.getStatement();
        String restMess = "";
        try {
            String[] meals = order == 1 ? new String[]{"1", "5", "2", "6"} : new String[]{"3", "7", "4", "8"};
            LOGGER.debug((Object)(terminalId + " " + "Pocitam vydane kusy"));
            for (int i = 0; i < 4; ++i) {
                rs = stm.executeQuery("SELECT * FROM rtr_messes WHERE showposition=" + meals[i] + " AND terminal_id = " + terminalId + " AND (time(vydejod) < curtime() OR vydejod IS NULL) " + " AND (time(vydejdo) > curtime() OR vydejdo IS NULL)");
                rs.beforeFirst();
                if (rs.next()) {
                    int meal_id = rs.getInt("meal_id");
                    boolean showrest = rs.getBoolean("showrest");
                    String getRestMess = "select sum(tobjednavky.kusu) objednano, sum(tobjednavky.vydanokusu) vydano, sum(tobjednavky.kusu) - sum(tobjednavky.vydanokusu) zbyvavydat, tobjednavky.chod_id, tkategorie.velikostporce, tobjednavky.vydejna_Id from tobjednavky left join tstravnici on (tobjednavky.stravnik_id = tstravnici.stravnik_id) left join tkategorie on (tstravnici.kategorie_id = tkategorie.kategorie_id) left join tchody on (tobjednavky.chod_id=tchody.chod_id) where datum = CURDATE() AND tchody.chod_id = " + meal_id + " AND tobjednavky.Vydejna_Id = " + placeId + " " + "and (tkategorie.velikostporce = " + rs.getInt("velikostPorce") + " or " + rs.getInt("velikostPorce") + " = 0) " + "and (((tobjednavky.datum <=tstravnici.platnostdo) or " + "(tstravnici.platnostdo IS NULL) or (tstravnici.platnostdo = '0000-00-00')) and " + "(tobjednavky.datum >=tstravnici.platnostod)) " + "and tobjednavky.platne >= 0 " + "group by chod_id, vydejna_id";
                    if (rs.getInt("velikostPorce") != 0) {
                        getRestMess = getRestMess + ", tkategorie.velikostporce";
                    }
                    rs.close();
                    rs = stm.executeQuery(getRestMess);
                    rs.beforeFirst();
                    if (rs.next()) {
                        if (showrest) {
                            restMess = restMess + StringConvertor.addZerosToFourChars(rs.getString("zbyvavydat"));
                            continue;
                        }
                        restMess = restMess + StringConvertor.addZerosToFourChars(rs.getString("vydano"));
                        continue;
                    }
                    restMess = restMess + NON_MESSES;
                    continue;
                }
                restMess = restMess + NON_MESSES;
            }
            String i = restMess;
            return i;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Chyba pri pocitani poctu kusu.", (Throwable)ex);
            String string = "0000000000000000";
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {}
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public JdbcSelectDao getSelectDao() {
        if (this.applicationContext != null && this.selectDao == null) {
            this.setSelectDao((JdbcSelectDao)((Object)this.applicationContext.getBean("selectDao")));
        }
        return this.selectDao;
    }

    public void setSelectDao(JdbcSelectDao selectDao) {
        this.selectDao = selectDao;
    }

    public TerminalBaseDao getTerminalBaseDao() {
        return this.terminalBaseDao;
    }

    public void setTerminalBaseDao(TerminalBaseDao terminalBaseDao) {
        this.terminalBaseDao = terminalBaseDao;
    }

    public boolean isPrinteable() {
        return false;
    }
}

