/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.terminals;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcSelectDao
extends JdbcDaoSupport {
    public static final int BY_ID_OBJEDNAVKA = 1;
    public static final int BY_ID_CHOD = 2;

    public Double getCredit(int stravnikId, boolean useDonation) {
        String sql;
        Object[] args;
        if (useDonation) {
            args = new Object[]{stravnikId, stravnikId, stravnikId, stravnikId};
            sql = "SELECT ROUND(IFNULL(TPohled.Objed1DPH,0)*(-1) + IFNULL(TPlat.Castka,0) + IFNULL(TUzav.ZustatekKontaUz,0),1) AS ZustatekKonta FROM (SELECT DISTINCT TS.Stravnik_Id FROM tstravnici AS TS WHERE stravnik_id= ?) as TStrav LEFT JOIN (SELECT TS.Stravnik_Id, SUM(IFNULL(TObj.KusuC1,0) * TCen.Cena1VcetneDPH) + SUM(IFNULL(TObj.KusuC2,0) * TCen.Cena2VcetneDPH) AS Objed1DPH FROM tcenik AS TCen LEFT JOIN tobjednavky AS TObj ON (TObj.Stravnik_Id = ?) AND (TCen.Chod_Id = TObj.Chod_Id) LEFT JOIN tstravnici AS TS ON (TS.Kategorie_Id = TCen.Kategorie_Id) and ((TCen.PlatnostCenyOd <= TObj.Datum) and  ((TCen.PlatnostCenyDo >= TObj.Datum) or (TCen.PlatnostCenyDo is null ))) LEFT JOIN tchody AS TCh ON (TCh.Chod_Id = TObj.Chod_Id) WHERE TObj.Platne >= 0 AND (((TObj.Datum <=TS.PlatnostDo) OR (TS.PlatnostDo IS NULL) OR (TS.PlatnostDo = '0000-00-00')) AND (TObj.Datum >=TS.PlatnostOd))  AND TObj.ZdrojObj_Id <> 8 AND (TS.Stravnik_Id = ?) GROUP BY TS.Stravnik_Id ORDER BY TS.Stravnik_Id) AS TPohled ON (TStrav.Stravnik_Id = TPohled.Stravnik_Id) LEFT JOIN (SELECT TUz.Stravnik_Id, TUz.ZustatekKontaUz FROM tuzaverka AS TUz WHERE (TUz.DatumUzaverky <= current_date) ORDER BY TUz.DatumUzaverky DESC LIMIT 1) AS TUzav ON(TStrav.Stravnik_Id = TUzav.Stravnik_Id) LEFT JOIN (SELECT TPL.Stravnik_Id, SUM(TPL.Castka) AS Castka FROM tplatby AS TPL LEFT JOIN tdruhplatby AS TDP ON (TPL.DruhPLatby_Id = TDP.DruhPlatby_Id) AND TPL.Stravnik_Id = ? WHERE (TDP.DruhPlatbyKonto >0) GROUP BY TPL.Stravnik_Id) AS TPlat ON (TStrav.Stravnik_Id = TPlat.Stravnik_Id) ";
        } else {
            args = new Object[]{stravnikId, stravnikId, stravnikId};
            sql = "SELECT IFNULL(TPohled.Objed1DPH,0)*(-1) + IFNULL(TPlat.Castka,0) + IFNULL(TUzav.ZustatekKontaUz,0) AS ZustatekKonta FROM (SELECT DISTINCT TS.Stravnik_Id FROM tstravnici AS TS WHERE stravnik_id=?) as TStrav LEFT JOIN (SELECT TS.Stravnik_Id, SUM(IFNULL(TObj.Kusu,0) * TCen.Cena1VcetneDPH) AS Objed1DPH FROM tcenik AS TCen LEFT JOIN tstravnici AS TS ON (TS.Kategorie_Id = TCen.Kategorie_Id) LEFT JOIN tobjednavky AS TObj ON (TS.Stravnik_Id = TObj.Stravnik_Id) AND (TCen.Chod_Id = TObj.Chod_Id) LEFT JOIN tchody AS TCh ON (TCh.Chod_Id = TObj.Chod_Id) WHERE TObj.Platne >= 0 AND (((TObj.Datum <=TS.PlatnostDo) OR (TS.PlatnostDo IS NULL) OR (TS.PlatnostDo = \"0000-00-00\")) AND (TObj.Datum >=TS.PlatnostOd)) AND (TS.Stravnik_Id = ?) and ((TCen.PlatnostCenyOd <= TObj.Datum) and  ((TCen.PlatnostCenyDo >= TObj.Datum) or (TCen.PlatnostCenyDo is null ))) GROUP BY TS.Stravnik_Id ORDER BY TS.Stravnik_Id) AS TPohled ON (TStrav.Stravnik_Id = TPohled.Stravnik_Id) LEFT JOIN (SELECT TUz.Stravnik_Id, TUz.ZustatekKontaUz FROM tuzaverka AS TUz WHERE (TUz.DatumUzaverky <= now()) ORDER BY TUz.DatumUzaverky DESC LIMIT 1) AS TUzav ON(TStrav.Stravnik_Id = TUzav.Stravnik_Id) LEFT JOIN (SELECT TPL.Stravnik_Id, SUM(TPL.Castka) AS Castka FROM tplatby AS TPL LEFT JOIN tdruhplatby AS TDP ON (TPL.DruhPLatby_Id = TDP.DruhPlatby_Id) AND TPL.Stravnik_Id = ? WHERE (TDP.DruhPlatbyKonto >0) GROUP BY TPL.Stravnik_Id) AS TPlat ON (TStrav.Stravnik_Id = TPlat.Stravnik_Id)";
        }
        List temp = this.getJdbcTemplate().queryForList(sql, args);
        temp.size();
        return (Double)this.getJdbcTemplate().queryForObject(sql, args, Double.class);
    }

    public Double getMealPriceByChod(Date date, int stravnikId, int chodId, int numberOfMeals) {
        try {
            return this.getMealPriceBy(date, stravnikId, chodId, 2, numberOfMeals);
        }
        catch (EmptyResultDataAccessException ex) {
            this.logger.error((Object)("Nen\u00ed mo\u017en\u00e9 vypo\u010d\u00edtat cenu j\u00eddla pro stravnikId " + stravnikId + " chodId:" + chodId));
            return 99999.9;
        }
    }

    public Double getMealPriceByObjednavka(Date date, int stravnikId, int objednavkaId, int numberOfMeals) {
        try {
            return this.getMealPriceBy(date, stravnikId, objednavkaId, 1, numberOfMeals);
        }
        catch (EmptyResultDataAccessException ex) {
            this.logger.error((Object)("Nen\u00ed mo\u017en\u00e9 vypo\u010d\u00edtat cenu j\u00eddla pro stravnikId " + stravnikId + " chodId:" + objednavkaId));
            return 99999.9;
        }
    }

    private Double getMealPriceBy(Date date, int stravnikId, Integer id, int type, int numberOfMeals) {
        Validate.isTrue((type != 0 ? 1 : 0) != 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String datum = formatter.format(date);
        String sql = "SELECT IF (DotChod = 1,IF (ks1.kus+" + numberOfMeals + " > PocetKusuDo,Cena2VcetneDPH, " + "if (ks.kus+" + numberOfMeals + " > tkategorie.pocetdot,Cena2VcetneDPH,Cena1VcetneDPH)),Cena2VcetneDPH) as CenaVcetneDPH FROM tcenik " + "LEFT JOIN (SELECT SUM(Kusu) as kus, tcenik.kategorie_id FROM tobjednavky LEFT JOIN tstravnici ON tobjednavky.stravnik_id = tstravnici.stravnik_id " + "LEFT JOIN tcenik ON tobjednavky.chod_id  = tcenik.chod_id " + "WHERE tobjednavky.Platne >= 0 AND tobjednavky.stravnik_id = ? AND " + "(tobjednavky.datum BETWEEN '" + datum + "' AND '" + datum + "') " + "AND((tcenik.platnostcenydo >=  '" + datum + "') OR(tcenik.platnostcenydo IS NULL)) " + "AND tstravnici.platnostOd <= '" + datum + "' " + "AND((tstravnici.platnostdo >=  '" + datum + "') OR(tstravnici.platnostdo IS NULL) OR(tstravnici.platnostdo = '0000-00-00')) " + "AND tcenik.kategorie_id = tstravnici.kategorie_id " + "AND tcenik.dotchod = 1 " + "GROUP BY tcenik.dotChod) As ks " + "on(tcenik.kategorie_id = ks.kategorie_id) " + "LEFT JOIN tchody as tc ON(tcenik.chod_id = tc.chod_id) " + "LEFT JOIN (SELECT SUM(Kusu) as kus, tchody.symbolterminalu FROM tobjednavky LEFT JOIN tstravnici ON tobjednavky.stravnik_id = tstravnici.stravnik_id " + "LEFT JOIN tcenik ON tobjednavky.chod_id  = tcenik.chod_id " + "LEFT JOIN tchody ON tobjednavky.chod_id = tchody.chod_id " + "WHERE tobjednavky.stravnik_id = ? AND " + "(tobjednavky.datum BETWEEN '" + datum + "' AND '" + datum + "') " + "AND ((tcenik.platnostcenydo >=  '" + datum + "') OR(tcenik.platnostcenydo IS NULL)) " + "AND tobjednavky.Platne >= 0 " + "AND tstravnici.platnostOd <= '" + datum + "' " + "AND((tstravnici.platnostdo >=  '" + datum + "') OR(tstravnici.platnostdo IS NULL) OR(tstravnici.platnostdo = '0000-00-00')) " + "AND tcenik.kategorie_id = tstravnici.kategorie_id " + "AND tcenik.dotchod = 1 " + "AND tstravnici.Stravnik_id = tobjednavky.stravnik_id " + "AND(tobjednavky.datum BETWEEN '" + datum + "' AND '" + datum + "') " + "GROUP BY tchody.symbolterminalu) As ks1 " + "on(ks1.symbolterminalu = tc.symbolterminalu) " + "LEFT JOIN tkategorie ON tcenik.kategorie_ID = tkategorie.kategorie_id LEFT JOIN tchody ON tcenik.chod_id = tchody.chod_id " + "LEFT JOIN tstravnici  ON(tcenik.kategorie_id=tstravnici.kategorie_id) WHERE tcenik.chod_id =";
        sql = type == 1 ? sql + " (SELECT chod_id FROM tobjednavky WHERE Objednavka_Id = ?)" : sql + " ? ";
        sql = sql + "AND tstravnici.stravnik_id = ? " + "AND(tcenik.platnostcenyod <= '" + datum + "') " + "AND((tcenik.platnostcenydo >= '" + datum + "') OR(tcenik.platnostcenydo IS NULL))  " + "AND tstravnici.platnostOd <= '" + datum + "' " + "AND((tstravnici.platnostdo >=  '" + datum + "') OR(tstravnici.platnostdo IS NULL) OR(tstravnici.platnostdo = '0000-00-00')) " + "";
        Object[] args = new Object[]{stravnikId, stravnikId, id, stravnikId};
        return (Double)this.getJdbcTemplate().queryForObject(sql, args, Double.class);
    }

    public Double getMesicniSpotreba(int stravnikId) {
        String sql = "SELECT SUM(IFNULL(TObj.KusuC1,0) * TCen.Cena1VcetneDPH) + SUM(IFNULL(TObj.KusuC2,0) * TCen.Cena2VcetneDPH) AS CelkemCel FROM tcenik AS TCen LEFT JOIN tstravnici AS TS ON (TS.Kategorie_Id = TCen.Kategorie_Id) LEFT JOIN tobjednavky AS TObj ON (TS.Stravnik_Id = TObj.Stravnik_Id) AND (TCen.Chod_Id = TObj.Chod_Id) AND (TObj.Platne >= 0) AND (TObj.Datum BETWEEN DATE_ADD(CURDATE(), INTERVAL -DAY(NOW())+1 DAY) AND DATE_ADD(DATE_ADD(CURDATE(), INTERVAL -DAY(NOW()) DAY),INTERVAL 1 MONTH )) AND (((TObj.Datum <=TS.PlatnostDo) OR (TS.PlatnostDo IS NULL) OR (TS.PlatnostDo = '0000-00-00') ) AND (TObj.Datum >=TS.PlatnostOd))AND ((TCen.PlatnostCenyOd <= TObj.Datum) and  ((TCen.PlatnostCenyDo >= TObj.Datum) or (TCen.PlatnostCenyDo is null ))) WHERE (TS.Stravnik_Id = ?) group by TS.stravnik_id";
        Object[] args = new Object[]{stravnikId};
        return (Double)this.getJdbcTemplate().queryForObject(sql, args, Double.class);
    }
}

