/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import universalrouter.database.DBManager;
import universalrouter.terminals.TerminalClassical;
import universalrouter.terminals.TerminalClassicalAlternativeMask;
import universalrouter.terminals.TerminalClassicalBonap;
import universalrouter.terminals.TerminalClassicalBonapMundiBopak;
import universalrouter.terminals.TerminalClassicalMeals;
import universalrouter.terminals.TerminalClassicalServery;
import universalrouter.terminals.TerminalClassicalSpecial;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.terminals.TerminalDochazkaMarkTime;
import universalrouter.terminals.TerminalFake;
import universalrouter.terminals.TerminalInformacni;
import universalrouter.terminals.TerminalInformacniNoLimit;
import universalrouter.terminals.TerminalInformacniNoLimitPrivate;
import universalrouter.terminals.TerminalInformacniPrivate;
import universalrouter.terminals.TerminalMinutka;
import universalrouter.terminals.TerminalMinutkaPrivate;
import universalrouter.terminals.TerminalObjednavka;
import universalrouter.terminals.TerminalObjednavkaMoreMesses;
import universalrouter.terminals.TerminalObjednavkaPrinter;
import universalrouter.terminals.TerminalOrbisPristupAreal;
import universalrouter.terminals.TerminalOrbisPristupKlub;
import universalrouter.terminals.TerminalOrbisPristupOrganizatori;
import universalrouter.terminals.TerminalOrbisStrip2Chip;
import universalrouter.terminals.TerminalPevi;
import universalrouter.terminals.TerminalVydej;
import universalrouter.terminals.TerminalVydejPrint;
import universalrouter.terminals.TerminalVydejPrintNextDay;
import universalrouter.terminals.TerminalVydejPrivate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router {
    static Logger logger = Logger.getLogger(Router.class);
    private DBManager dbmanager;
    private int instanceNumber;
    private int resetAfter;
    private String volume;

    public Router(DBManager db, int instanceNumber, int ra, String vol) {
        this.dbmanager = db;
        this.instanceNumber = instanceNumber;
        this.resetAfter = ra;
        this.volume = vol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TerminalCommonInterface> getTerminalAdresses() {
        String configuration = "S,Sd,O,So,V";
        ArrayList<TerminalCommonInterface> adresses = new ArrayList<TerminalCommonInterface>();
        Statement stm = this.dbmanager.getStatement();
        try {
            ResultSet rs = stm.executeQuery("SELECT * FROM rtr_terminals WHERE instanceNumber = " + this.instanceNumber + " " + "ORDER BY Adress");
            rs.beforeFirst();
            while (rs.next()) {
                logger.info((Object)("Pridavam terminal s adresou: " + rs.getString("adress") + " - typ " + rs.getInt("Type")));
                switch (rs.getInt("Type")) {
                    case 0: {
                        adresses.add(new TerminalFake());
                        break;
                    }
                    case 1: {
                        adresses.add(new TerminalVydej(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 11: {
                        adresses.add(new TerminalVydejPrint(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 12: {
                        adresses.add(new TerminalVydejPrivate(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 13: {
                        adresses.add(new TerminalVydej(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 14: {
                        adresses.add(new TerminalVydejPrintNextDay(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 2: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassical(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 21: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassicalServery(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 22: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassicalAlternativeMask(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 23: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassicalMeals(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 24: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassicalBonap(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 25: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassicalSpecial(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 26: {
                        if (rs.getString("configuration") != null) {
                            configuration = rs.getString("configuration");
                        }
                        adresses.add(new TerminalClassicalBonapMundiBopak(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume, configuration));
                        break;
                    }
                    case 3: {
                        adresses.add(new TerminalInformacni(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 31: {
                        adresses.add(new TerminalInformacniNoLimit(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 32: {
                        adresses.add(new TerminalInformacniPrivate(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 311: {
                        adresses.add(new TerminalInformacniNoLimitPrivate(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 4: {
                        boolean orderType = true;
                        if (rs.getString("configuration") != null) {
                            orderType = rs.getBoolean("configuration");
                        }
                        adresses.add(new TerminalMinutka(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume, orderType));
                        break;
                    }
                    case 41: {
                        boolean orderTypePrivate = true;
                        if (rs.getString("configuration") != null) {
                            orderTypePrivate = rs.getBoolean("configuration");
                        }
                        adresses.add(new TerminalMinutkaPrivate(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume, orderTypePrivate));
                        break;
                    }
                    case 5: {
                        adresses.add(new TerminalObjednavka(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 6: {
                        adresses.add(new TerminalObjednavkaMoreMesses(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 7: {
                        adresses.add(new TerminalObjednavkaPrinter(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 100: {
                        adresses.add(new TerminalDochazkaMarkTime(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 1024: {
                        adresses.add(new TerminalPevi(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 1050: {
                        adresses.add(new TerminalOrbisPristupAreal(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 1051: {
                        adresses.add(new TerminalOrbisPristupOrganizatori(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 1052: {
                        adresses.add(new TerminalOrbisPristupKlub(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume));
                        break;
                    }
                    case 1053: {
                        adresses.add(new TerminalOrbisStrip2Chip(rs.getInt("adress"), rs.getInt("Type"), rs.getBoolean("hasGraphicalDisplay"), rs.getInt("place_id"), rs.getInt("Mode"), rs.getInt("ID"), this.resetAfter, this.volume));
                    }
                }
            }
            rs.close();
        }
        catch (SQLException ex) {
            logger.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
        }
        finally {
            Object rs = null;
            this.dbmanager = null;
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
        return adresses;
    }
}

