/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import universalrouter.database.SQLParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBManager {
    private DataSource dataSource;
    private Connection connection;
    static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(DBManager.class);

    public Statement getStatement() {
        try {
            return this.getConnection().createStatement();
        }
        catch (SQLException e) {
            logger.fatal((Object)"Nebylo mozne vratit statement", (Throwable)e);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String string) {
        try {
            return this.getConnection().prepareStatement(string);
        }
        catch (SQLException e) {
            logger.fatal((Object)"Nebylo mozne vratit prepared statement", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public int doPreparedStatement(String query, List<SQLParam> params) throws SQLException {
        PreparedStatement pstm = this.getConnection().prepareStatement(query);
        int paramIndex = 0;
        for (SQLParam actualParam : params) {
            ++paramIndex;
            String base = actualParam.getDataType();
            if (0 == base.compareTo("boolean")) {
                pstm.setBoolean(paramIndex, actualParam.getBooleanValue());
            } else if (0 == base.compareTo("byte")) {
                pstm.setByte(paramIndex, actualParam.getByteValue());
            } else if (0 == base.compareTo("char")) {
                pstm.setString(paramIndex, actualParam.getStringValue());
            } else if (0 == base.compareTo("short")) {
                pstm.setShort(paramIndex, actualParam.getShortValue());
            } else if (0 == base.compareTo("int")) {
                pstm.setInt(paramIndex, actualParam.getIntValue());
            } else if (0 == base.compareTo("long")) {
                pstm.setLong(paramIndex, actualParam.getLongValue());
            } else if (0 == base.compareTo("float")) {
                pstm.setFloat(paramIndex, actualParam.getFloatValue().floatValue());
            } else if (0 == base.compareTo("double")) {
                pstm.setDouble(paramIndex, actualParam.getDoubleValue());
            } else if (0 == base.compareTo("string")) {
                pstm.setString(paramIndex, actualParam.getStringValue());
            } else {
                throw new SQLException("Chybny typ promenne" + actualParam.getDataType());
            }
            base = null;
        }
        return pstm.executeUpdate();
    }

    public static int getResultSetSize(ResultSet resultSet) {
        int size = -1;
        try {
            resultSet.last();
            size = resultSet.getRow();
            resultSet.beforeFirst();
        }
        catch (SQLException e) {
            return size;
        }
        return size;
    }

    private Connection getConnection() {
        try {
            if (!this.connection.isClosed()) {
                return this.connection;
            }
            logger.warn((Object)"Spojeni bylo uzavreno, z\u00edsk\u00e1v\u00e1m nove");
            this.connection = this.dataSource.getConnection();
            return this.connection;
        }
        catch (SQLException ex) {
            Logger.getLogger(DBManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        try {
            this.connection = dataSource.getConnection();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

