/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.comm;

import cz.zware.universalrouter.utility.DateFunction;
import java.util.Calendar;
import java.util.Date;

public class OrderLimit {
    private int daysZrusit;
    private int daysObjednat;
    private Date makeOrderTimeTo;
    private Date cancelTimeTo;
    private boolean absoluteLimitObjednat;
    private boolean absoluteLimitZrusit;

    public OrderLimit(int daysObjednat, int daysZrusit, Date makeOrderTo, Date cancelTo, boolean absoluteLimitObjednat, boolean absoluteLimitZrusit) {
        this.setDaysObjednat(daysObjednat);
        this.setDaysZrusit(daysZrusit);
        this.setMakeOrderTimeTo(makeOrderTo);
        this.setCancelTimeTo(cancelTo);
        this.absoluteLimitObjednat = absoluteLimitObjednat;
        this.absoluteLimitZrusit = absoluteLimitZrusit;
    }

    public boolean isLimitTimeOrderExceeded(Date datumObjednavky, boolean saturdaySunday) {
        Date lastTimeOrder = this.isAbsoluteLimitObjednat() ? DateFunction.getLastTimeOrderAbsolute(this.getDaysObjednat(), this.getMakeOrderTimeTo(), datumObjednavky) : DateFunction.getLastTimeOrderRelative(this.getDaysObjednat(), this.getMakeOrderTimeTo(), datumObjednavky, saturdaySunday);
        return Calendar.getInstance().getTime().after(lastTimeOrder);
    }

    public boolean isLimitTimeCancelExceeded(Date datumZruseni, boolean saturdaySunday) {
        Date lastTimeOrder = this.isAbsoluteLimitZrusit() ? DateFunction.getLastTimeOrderAbsolute(this.getDaysZrusit(), this.getCancelTimeTo(), datumZruseni) : DateFunction.getLastTimeOrderRelative(this.getDaysZrusit(), this.getCancelTimeTo(), datumZruseni, saturdaySunday);
        return Calendar.getInstance().getTime().after(lastTimeOrder);
    }

    public int getDaysZrusit() {
        return this.daysZrusit;
    }

    public int getDaysObjednat() {
        return this.daysObjednat;
    }

    public Date getMakeOrderTimeTo() {
        return this.makeOrderTimeTo;
    }

    public Date getCancelTimeTo() {
        return this.cancelTimeTo;
    }

    public void setDaysZrusit(int daysZrusit) {
        this.daysZrusit = daysZrusit;
    }

    public void setDaysObjednat(int daysObjednat) {
        this.daysObjednat = daysObjednat;
    }

    public void setMakeOrderTimeTo(Date makeOrderTimeTo) {
        this.makeOrderTimeTo = makeOrderTimeTo;
    }

    public void setCancelTimeTo(Date cancelTimeTo) {
        this.cancelTimeTo = cancelTimeTo;
    }

    public boolean isAbsoluteLimitObjednat() {
        return this.absoluteLimitObjednat;
    }

    public void setAbsoluteLimitObjednat(boolean absoluteLimitObjednat) {
        this.absoluteLimitObjednat = absoluteLimitObjednat;
    }

    public boolean isAbsoluteLimitZrusit() {
        return this.absoluteLimitZrusit;
    }

    public void setAbsoluteLimitZrusit(boolean absoluteLimitZrusit) {
        this.absoluteLimitZrusit = absoluteLimitZrusit;
    }
}

