/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.comm;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import universalrouter.comm.GlobalSetting;
import universalrouter.comm.Order;
import universalrouter.comm.PortConfiguration;
import universalrouter.comm.SerialPortCommunicator;
import universalrouter.comm.ServerConfiguration;
import universalrouter.database.DBManager;
import universalrouter.database.Router;
import universalrouter.terminals.TerminalCommonInterface;
import universalrouter.terminals.TerminalVydej;
import universalrouter.terminals.TerminalVydejPrintNextDay;
import universalrouter.termutils.Display;
import universalrouter.util.CrcUtils;
import universalrouter.util.StringConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainPort
implements SerialPortEventListener,
Runnable {
    public static final String VERSION = "G1.8.10";
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(MainPort.class);
    private static CommPortIdentifier portId;
    private static Enumeration portList;
    private SerialPort serialPort;
    private final PortConfiguration portConfigurator;
    private String defaultPort;
    private boolean doCommunication = true;
    private final DBManager dbmanager;
    private Order composeOrder;
    private final Router router;
    private SerialPortCommunicator spc;
    private List<TerminalCommonInterface> terminals = new ArrayList<TerminalCommonInterface>();
    private int maxIncommingLength = 30;
    private int afterSendTime;
    private int afterRTSTrueTime = 2;
    private int afterRTSFalseTime = 2;
    private int afterCallSendTime = 3;
    private int afterDataSendTime = 35;
    private int beforeReadTime = 5;
    private int cycleTime = 35;
    private final int afterDisplaySet = 35;
    private final int afterPrintSet = 60;
    private InputStream inputStream;
    private final boolean debug;
    private final boolean localChars;
    private long timeSetInterval;
    private boolean test = false;

    public MainPort(String comPort, ServerConfiguration sConf, String volume, boolean guiTool, ApplicationContext ctx, boolean debug, boolean localChars) {
        this.debug = debug;
        this.localChars = localChars;
        this.timeSetInterval = sConf.getTimeSetInterval();
        this.defaultPort = sConf.getDefaultPort();
        if (comPort != null && (comPort.startsWith("com") || comPort.startsWith("COM") || comPort.startsWith("/dev/"))) {
            this.defaultPort = comPort;
        }
        comPort = null;
        this.afterRTSTrueTime = sConf.getAfterRTSTrueTime();
        this.afterRTSFalseTime = sConf.getAfterRTSFalseTime();
        this.afterCallSendTime = sConf.getAfterCallSendTime();
        this.afterDataSendTime = sConf.getAfterDataSendTime();
        this.beforeReadTime = sConf.getBeforeReadTime();
        this.cycleTime = sConf.getCycleTime();
        LOGGER.info((Object)"Vytvarim komponenetu odpovednou za komunikaci s databazi");
        this.dbmanager = (DBManager)ctx.getBean("DBManager");
        LOGGER.info((Object)("Pouzivam casovani: " + this.afterRTSTrueTime + "_" + this.afterRTSFalseTime + "_" + this.afterCallSendTime + "_" + this.afterDataSendTime + "_" + this.beforeReadTime + "_" + this.cycleTime));
        LOGGER.info((Object)"Nacitam adresy terminalu z databaze");
        this.router = new Router(this.dbmanager, sConf.getInstanceNumber(), sConf.getResetAfter(), volume);
        this.terminals = this.router.getTerminalAdresses();
        LOGGER.info((Object)"Staruji odesilatele pozadavku...");
        this.portConfigurator = new PortConfiguration();
        this.composeOrder = new Order(sConf.getserverAddress());
        LOGGER.info((Object)"Nacitam globalni nastaveni programu...");
        GlobalSetting gs = new GlobalSetting(this.dbmanager);
        for (TerminalCommonInterface tci : this.terminals) {
            tci.setApplicationContext(ctx);
            tci.setDBManager(this.dbmanager);
            tci.setGlobalSetting(gs);
            tci.init();
            tci.setPrinter(sConf.getPrinter(), "/dev/lp0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void communicate() {
        Statement stm = this.dbmanager.getStatement();
        try {
            stm.executeUpdate("UPDATE verze set ur = + 'G1.8.10'");
        }
        catch (SQLException e) {
            LOGGER.debug((Object)"Neni spojeni s databazi", (Throwable)e);
        }
        finally {
            try {
                stm.close();
            }
            catch (SQLException e) {}
            stm = null;
        }
        if (this.createPort()) {
            this.spc = new SerialPortCommunicator(this.getSerialPort());
            this.spc.setDebug(this.debug);
            try {
                this.getSerialPort().addEventListener((SerialPortEventListener)this);
            }
            catch (TooManyListenersException e) {
                LOGGER.error((Object)"Prilis mnoho posluchacu");
            }
            Calendar cal = Calendar.getInstance();
            int cycle = 0;
            while (this.doCommunication) {
                long isConnected = 1L;
                if (++cycle % 100 == 0) {
                    stm = this.dbmanager.getStatement();
                    ResultSet rs = null;
                    try {
                        rs = stm.executeQuery("SELECT NOW() as now");
                        rs.first();
                        isConnected = rs.getDate("now").getTime() + rs.getTime("now").getTime();
                        cycle = 1;
                    }
                    catch (SQLException e) {
                        LOGGER.warn((Object)"Neni spojeni s databazi");
                        isConnected = 0L;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception ignore) {}
                        }
                        rs = null;
                        if (stm != null) {
                            try {
                                stm.close();
                            }
                            catch (SQLException e) {}
                        }
                        stm = null;
                    }
                }
                for (TerminalCommonInterface tci : this.getTerminals()) {
                    if (isConnected == 0L && tci.getHasTerminalDisplay()) {
                        tci.getDisplay().setEXPosition("Neni databaze", 1);
                        tci.getDisplay().setEXPosition("Neni databaze", 3);
                    }
                    if (tci.isSendVersion()) {
                        if (tci.getHasTerminalDisplay()) {
                            tci.getDisplay().setEXPosition("T: " + StringConvertor.addSpecifiedChars(tci.getTerminalName(), 12, ""), 1);
                            tci.getDisplay().setEXPosition("V: " + StringConvertor.addSpecifiedChars(VERSION, 12, " "), 3);
                        }
                        tci.setHasAnswer(true);
                        tci.setSendVersion(false);
                    }
                    this.getSerialPort().setRTS(true);
                    try {
                        Thread.sleep(this.afterRTSTrueTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (tci.getHasAnswer()) {
                        this.afterSendTime = this.afterDataSendTime;
                        if (tci.getHasTerminalDisplay()) {
                            byte[] bt;
                            if (tci.getDisplay().getLogout()) {
                                bt = new byte[]{4};
                                this.composeOrder.setOrder(tci.getAdress(), "Ek", bt);
                                tci.getDisplay().setLogout(false);
                                tci.getDisplay().nullDisplay();
                                this.spc.sendMessage(this.composeOrder.getByteOrder());
                                bt = null;
                                try {
                                    Thread.sleep(35L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (tci.getDisplay().getClear()) {
                                bt = new byte[]{4};
                                this.composeOrder.setOrder(tci.getAdress(), "Ec", bt);
                                tci.getDisplay().setClear(false);
                                this.spc.sendMessage(this.composeOrder.getByteOrder());
                                bt = null;
                                try {
                                    Thread.sleep(35L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            for (int i = 1; i <= tci.getDisplay().getDisplaySize(); ++i) {
                                if (tci.getDisplay().getEXPosition(i) == null) continue;
                                byte[] bt2 = tci.getDisplay().getFinalizedEXPosition(i, this.localChars);
                                this.composeOrder.setOrder(tci.getAdress(), "E", bt2);
                                bt2 = null;
                                this.spc.sendMessage(this.composeOrder.getByteOrder());
                                LOGGER.info((Object)(tci.getTerminalID() + " Odes\u00edl\u00e1m odpov\u011b\u010f: " + StringConvertor.hexToString(this.composeOrder.getByteOrder())));
                                try {
                                    Thread.sleep(35L);
                                    continue;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (tci.isPrinteable()) {
                            this.printableTerminal(tci);
                        }
                        if (this.debug) {
                            LOGGER.debug((Object)(tci.getTerminalID() + " Posilam potvrzeni do terminal"));
                        }
                        byte[] b1 = new byte[]{1, tci.getSegment(), 1, 5};
                        int numberBeeps = tci.getSegment() > 0 && tci.getSegment() < 10 ? (tci.getMealBeep() == 'F' ? 1 : Character.getNumericValue(tci.getMealBeep())) : 1;
                        byte[] returnOrder = new byte[14];
                        System.arraycopy(b1, 0, returnOrder, 0, b1.length);
                        byte[] b2 = new byte[2];
                        b2[1] = 1;
                        for (int bIn = 0; bIn < numberBeeps; ++bIn) {
                            b2[0] = tci.getBeepLength();
                            System.arraycopy(b2, 0, returnOrder, b1.length + bIn * 2, 2);
                            LOGGER.debug((Object)(tci.getTerminalID() + " Pridavam piskani"));
                        }
                        this.composeOrder.setOrder(tci.getAdress(), "I", returnOrder);
                        tci.setHasAnswer(false);
                        b1 = null;
                        b2 = null;
                        returnOrder = null;
                    } else if (!tci.getLock()) {
                        if (tci.getVolume().compareTo("-1") != 0) {
                            LOGGER.info((Object)(tci.getTerminalID() + " Nastavuji hlasitost piskani"));
                            try {
                                this.composeOrder.setOrder(tci.getAdress(), "Eh", Display.finalizeByteArray(tci.getVolume().getBytes("Windows-1250")));
                            }
                            catch (UnsupportedEncodingException ex) {
                                Logger.getLogger(MainPort.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            tci.setVolume("-1");
                            this.spc.sendMessage(this.composeOrder.getByteOrder());
                            try {
                                Thread.sleep(this.afterDataSendTime);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        TimeZone tz = TimeZone.getDefault();
                        cal.setTimeInMillis(isConnected + (long)tz.getRawOffset());
                        if (tci.getLastClockSetTime() + this.timeSetInterval < cal.getTimeInMillis()) {
                            byte[] bt;
                            int dayOfWeek = cal.get(7) == 1 ? 7 : cal.get(7) - 1;
                            String timeSet = ("" + cal.get(1)).substring(2, 4) + StringConvertor.addZerosTo2("" + (cal.get(2) + 1)) + StringConvertor.addZerosTo2("" + cal.get(5)) + StringConvertor.addZerosTo2("" + dayOfWeek) + StringConvertor.addZerosTo2("" + cal.get(11)) + StringConvertor.addZerosTo2("" + cal.get(12)) + StringConvertor.addZerosTo2("" + cal.get(13));
                            tci.setLastClockSetTime(cal.getTimeInMillis());
                            LOGGER.debug((Object)(tci.getTerminalID() + " Cekam, nez nastavim cas"));
                            try {
                                bt = Display.finalizeByteArray(timeSet.getBytes("Windows-1250"));
                            }
                            catch (UnsupportedEncodingException ex) {
                                Logger.getLogger(MainPort.class.getName()).log(Level.SEVERE, null, ex);
                                bt = null;
                            }
                            this.composeOrder.setOrder(tci.getAdress(), "ET", bt);
                            bt = null;
                            this.afterSendTime = this.afterDataSendTime;
                        } else {
                            byte[] bt = new byte[]{0};
                            this.composeOrder.setOrder(tci.getAdress(), "U", bt);
                            bt = null;
                            this.afterSendTime = this.afterCallSendTime;
                        }
                    } else {
                        try {
                            if (tci.getHasTerminalDisplay()) {
                                this.composeOrder.setOrder(tci.getAdress(), "Er", Display.finalizeByteArray("Na\u010d\u00edt\u00e1m data...".getBytes("Windows-1250")));
                            }
                        }
                        catch (UnsupportedEncodingException ex) {
                            Logger.getLogger(MainPort.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.afterSendTime = this.afterDataSendTime;
                        tci.addCycles();
                    }
                    if (tci.getRequestOldData()) {
                        this.spc.sendMessage(tci.getCommByte());
                        LOGGER.info((Object)(tci.getTerminalID() + " Odes\u00edl\u00e1m odpov\u011b\u010f: " + StringConvertor.hexToString(tci.getCommByte())));
                        if (tci.isPrinteable()) {
                            LOGGER.debug((Object)(tci.getTerminalID() + " Pokus o opakovan\u00fd tisk"));
                            this.printableTerminal(tci);
                        }
                        tci.setRequestOldData(false);
                    } else {
                        this.spc.sendMessage(this.composeOrder.getByteOrder());
                        if (this.composeOrder.getByteOrder()[2] != 85 && this.composeOrder.getByteOrder()[2] != 69) {
                            tci.setCommByte(this.composeOrder.getByteOrder());
                            LOGGER.debug((Object)(tci.getTerminalID() + " Ukl\u00e1d\u00e1m star\u00e1 data pro p\u0159\u00edpad chyby: " + StringConvertor.hexToString(this.composeOrder.getByteOrder())));
                        }
                    }
                    try {
                        Thread.sleep(this.afterSendTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.getSerialPort().setRTS(false);
                    try {
                        Thread.sleep(this.afterRTSFalseTime);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!this.isTest()) {
                        try {
                            this.inputStream = this.getSerialPort().getInputStream();
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"Chyba pri vytvareni input streamu");
                        }
                    }
                    this.getSerialPort().notifyOnDataAvailable(true);
                    try {
                        this.getInputStream().close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Nepodarilo se uzavrit input stream");
                    }
                    try {
                        Thread.sleep(this.cycleTime);
                    }
                    catch (Exception e) {}
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            LOGGER.info((Object)"Zaviram seriovy port");
            this.getSerialPort().close();
        }
    }

    private boolean createPort() {
        boolean portFound = false;
        portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(this.defaultPort)) continue;
            portFound = true;
            LOGGER.info((Object)("Nalezen port: " + this.defaultPort));
            portFound = true;
            try {
                this.serialPort = (SerialPort)portId.open("UniversalRouter", 2000);
            }
            catch (PortInUseException e) {
                LOGGER.error((Object)"Bohuzel port je jiz vyuzivan.");
                continue;
            }
            try {
                this.getSerialPort().setSerialPortParams(this.portConfigurator.getBaud(), this.portConfigurator.getDataBits(), this.portConfigurator.getStopBits(), this.portConfigurator.getParity());
            }
            catch (UnsupportedCommOperationException e) {
                LOGGER.error((Object)"Chyba pri nastavovani portu. Port takovou hodnotu nepodporuje", (Throwable)e);
            }
        }
        if (!portFound) {
            LOGGER.error((Object)("port " + this.defaultPort + " nebyl nalezen, nebo je zablokovan. " + "Overte take, zda mate na port prava. Pokud jste je nenastavovali " + "zkuste chmod 777 /dev/ttyS0 (resp. jiny port)."));
        }
        return portFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printableTerminal(TerminalCommonInterface tci) {
        TerminalVydej terminalVydej = (TerminalVydej)tci;
        if (tci.getUser() == null) {
            return;
        }
        SimpleDateFormat formatterDate = new SimpleDateFormat("EEEE dd.MM.yy");
        SimpleDateFormat parserDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatterTime = new SimpleDateFormat("kk:mm dd.MM.");
        String date = formatterDate.format(Calendar.getInstance().getTime());
        if (terminalVydej instanceof TerminalVydejPrintNextDay) {
            try {
                String dateNext = ((TerminalVydejPrintNextDay)terminalVydej).getDateNext();
                date = formatterDate.format(parserDate.parse(dateNext));
            }
            catch (ParseException ex) {
                LOGGER.warn((Object)(tci.getTerminalID() + " Nepoda\u0159ilo se zform\u00e1tovat datum"), (Throwable)ex);
            }
        }
        String time = formatterTime.format(Calendar.getInstance().getTime());
        byte[] bt = new byte[20];
        try {
            bt[0] = 1;
            bt[1] = 27;
            bt[2] = 87;
            bt[3] = 49;
            System.arraycopy(StringConvertor.internationalToEnglish(StringUtils.rightPad((String)date, (int)15)).getBytes(), 0, bt, 4, 15);
            bt[19] = 36;
            this.composeOrder.setOrder(tci.getAdress(), "i", bt);
            this.spc.sendMessage(this.composeOrder.getByteOrder());
            try {
                Thread.sleep(60L);
            }
            catch (Exception e) {
                // empty catch block
            }
            bt[0] = 1;
            bt[1] = 13;
            bt[2] = 10;
            System.arraycopy(StringConvertor.internationalToEnglish(StringUtils.rightPad((String)terminalVydej.getTempDisplayText(), (int)14)).getBytes(), 0, bt, 3, 14);
            bt[17] = 13;
            bt[18] = 10;
            bt[19] = 36;
            this.composeOrder.setOrder(tci.getAdress(), "i", bt);
            this.spc.sendMessage(this.composeOrder.getByteOrder());
            try {
                Thread.sleep(60L);
            }
            catch (Exception e) {
                // empty catch block
            }
            bt[0] = 1;
            System.arraycopy(StringConvertor.internationalToEnglish(StringUtils.rightPad((String)terminalVydej.getUser().getName(), (int)17)).getBytes(), 0, bt, 1, 17);
            bt[18] = 13;
            bt[19] = 36;
            this.composeOrder.setOrder(tci.getAdress(), "i", bt);
            this.spc.sendMessage(this.composeOrder.getByteOrder());
            try {
                Thread.sleep(60L);
            }
            catch (Exception e) {
                // empty catch block
            }
            bt[0] = 1;
            bt[1] = 10;
            System.arraycopy(StringUtils.rightPad((String)time, (int)12).getBytes(), 0, bt, 2, 12);
            bt[14] = 13;
            bt[15] = 10;
            bt[16] = 13;
            bt[17] = 10;
            bt[18] = 10;
            bt[19] = 36;
            this.composeOrder.setOrder(tci.getAdress(), "i", bt);
            this.spc.sendMessage(this.composeOrder.getByteOrder());
            try {
                Thread.sleep(60L);
            }
            catch (Exception e) {
                // empty catch block
            }
            bt[0] = 1;
            bt[1] = 10;
            System.arraycopy(StringUtils.rightPad((String)"", (int)12).getBytes(), 0, bt, 2, 8);
            bt[10] = 10;
            bt[11] = 10;
            bt[12] = 10;
            bt[13] = 10;
            bt[14] = 10;
            bt[15] = 10;
            bt[16] = 27;
            bt[17] = 100;
            bt[18] = 49;
            bt[19] = 36;
            this.composeOrder.setOrder(tci.getAdress(), "i", bt);
            this.spc.sendMessage(this.composeOrder.getByteOrder());
            try {
                Thread.sleep(60L);
            }
            catch (Exception e) {
                // empty catch block
            }
            LOGGER.debug((Object)(tci.getTerminalID() + "TISK: " + terminalVydej.getTempDisplayText() + ", " + terminalVydej.getUser().getName()));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
        }
        finally {
            bt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent event) throws RuntimeException {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                byte[] readBuffer = new byte[this.maxIncommingLength];
                try {
                    Thread.sleep(this.beforeReadTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.getInputStream().read(readBuffer);
                    int length = new Integer(readBuffer[1]);
                    if (length < 2) break;
                    byte[] b3 = new byte[length];
                    System.arraycopy(readBuffer, 0, b3, 0, length);
                    String ord = StringConvertor.hexToString(b3);
                    if (!CrcUtils.isCorrect(ord)) {
                        LOGGER.error((Object)("CRC kod nesouhlasi. Prikaz byl pravdepodobne poskozen pri prenosu nebo je neuplny. Zkontrolujte linku, prevodnik a predevsim casovani: " + ord + " [" + ord.length() + "]"));
                        break;
                    }
                    LOGGER.info((Object)("CRC kod souhlasi. Prikaz byl prijat a bude zpracovavan. Prijato " + ord));
                    if (ord.length() < 20) {
                        LOGGER.debug((Object)("Prikaz ma delku jen: " + ord.length()));
                    }
                    int sourceAdress = Integer.parseInt(ord.substring(16, 18), 16);
                    TerminalCommonInterface tempTerminal = this.getTerminals().get(sourceAdress - 17);
                    if (tempTerminal.getAdress() != sourceAdress) {
                        LOGGER.fatal((Object)"Nesouhlasi adresy terminalu. Kriticka chyba.");
                    } else {
                        LOGGER.debug((Object)"Rovnaji se");
                    }
                    tempTerminal.setStrReader(ord.substring(14, 16));
                    tempTerminal.setLock(true);
                    int orderResult = -1;
                    tempTerminal.setRequestOldData(false);
                    orderResult = tempTerminal.doAction(readBuffer);
                    switch (orderResult) {
                        case 1: {
                            LOGGER.debug((Object)"Signal rozpoznan jako prikaz a uspesne zpracovan");
                            tempTerminal.setBeepLength((byte)-126);
                            tempTerminal.setHasAnswer(true);
                            break;
                        }
                        case 0: {
                            LOGGER.debug((Object)"Signal rozpoznan jako prikaz, ale cip nenalezen v databazi, nebo nema uzivatel platnou objednavku");
                            tempTerminal.setBeepLength((byte)-120);
                            tempTerminal.setHasAnswer(true);
                            break;
                        }
                        case -1: {
                            LOGGER.warn((Object)"Prikaz byl pravdepodobne poskozen. Pro vice informaci prepnete logger do modu debug");
                            tempTerminal.setHasAnswer(true);
                            if (!tempTerminal.getHasTerminalDisplay()) break;
                            tempTerminal.getDisplay().nullDisplay();
                            tempTerminal.getDisplay().setEXPosition("Chyba dat", 3);
                            tempTerminal.getDisplay().setEXPosition("Chyba dat", 1);
                            break;
                        }
                        case -2: {
                            LOGGER.debug((Object)"Sberac chybovych hlaseni pro vypis na terminal - obvykle pri tlacitku");
                            tempTerminal.setBeepLength((byte)-120);
                            tempTerminal.setHasAnswer(true);
                            break;
                        }
                        default: {
                            break;
                        }
                        case -4: {
                            LOGGER.info((Object)"Zadost o poslani starych dat");
                            tempTerminal.setRequestOldData(true);
                            tempTerminal.setHasAnswer(true);
                        }
                    }
                    tempTerminal.setLock(false);
                    tempTerminal = null;
                    b3 = null;
                    ord = null;
                }
                catch (IOException e) {
                    LOGGER.fatal((Object)"Chyba pri nacitani prikazu.", (Throwable)e);
                }
                catch (ArrayIndexOutOfBoundsException ignore) {
                    LOGGER.debug((Object)"Chyba pri zpracovani prikazu.", (Throwable)ignore);
                }
                catch (Exception e) {
                    LOGGER.fatal((Object)"Chyba pri zpracovani prikazu.", (Throwable)e);
                }
                Object var2_2 = null;
            }
        }
    }

    public List<TerminalCommonInterface> getTerminals() {
        return this.terminals;
    }

    public void setTerminals(List<TerminalCommonInterface> terminals) {
        this.terminals = terminals;
    }

    @Override
    public void run() {
        this.communicate();
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }
}

