/*
 * Decompiled with CFR 0.152.
 */
package universalrouter.comm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import universalrouter.database.DBManager;

public class GlobalSetting {
    static Logger LOGGER = Logger.getLogger(GlobalSetting.class);
    public static final int SPEC_JEN_JEDNO_JIDLO_DENNE = 1;
    public static final int SPEC_JEN_JEDNO_JIDLO_ALL = 2;
    public static final int SPEC_PEVNE_OBJEDNAVKY = 7;
    public static final int SPEC_CELY_DEN = 8;
    public static final int SPEC_NEMOZNOST_ODHLASEK = 9;
    private boolean checkJidelnicek = true;
    private boolean weekends = false;
    private boolean showWeekends = true;
    private boolean useDonation = false;
    private boolean useRelations = false;
    private boolean runMesses = false;
    private boolean watchTerminals = false;
    private boolean burzaAvailable = false;
    private boolean mesicniAvailable = false;
    private boolean tydenniAvailable = false;
    private boolean denniAvailable = true;
    private boolean platbyAvailable = true;
    private boolean historieAvailable = true;
    private boolean objednavkyAvailable = true;
    private boolean kreditAvailable = true;
    private boolean kreditAutomate = true;
    private boolean usePlatne = false;
    private boolean spotrebaAvailable = true;
    private boolean ratingAvailable = false;
    private boolean messagingAvailable = false;
    private boolean picturesAvailable = true;
    private boolean alergensAvailable = true;
    private boolean flipCode = false;
    private boolean tiskAvailable = false;
    private State showLastOrder = State.disabled;
    private boolean showLastLogin = false;
    private boolean allowMultipleIncrement = false;
    private boolean useIps = false;
    private String infoUzivatele;
    private String driverClassName;
    private int initialDateIncrement = 0;
    private boolean localeAvailable = false;
    private boolean terminalLoginNameAvailable = false;
    private static final String SQL_DRIVER_MSSQL = "net.sourceforge.jtds.jdbc.JtdsDatabaseMetaData";

    public GlobalSetting(DBManager db) {
        this.initPojo(db);
    }

    public GlobalSetting() {
        this.initWeb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPojo(DBManager dbManager) {
        ResultSet rs = null;
        Statement stm = dbManager.getStatement();
        try {
            rs = stm.executeQuery("SELECT * FROM rtr_setting");
            this.init(rs);
        }
        catch (SQLException ex) {
            LOGGER.error((Object)"Neznama chyba pri vyhledavani prikazu v databazi.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
            try {
                stm.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWeb() {
        Context cntx = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            InitialContext init_con = new InitialContext();
            cntx = (Context)init_con.lookup("java:comp/env");
            DataSource ds = (DataSource)cntx.lookup("jdbc/CustomersDB");
            con = ds.getConnection();
            stm = con.createStatement();
            this.setDriverClassName(con.getMetaData().getClass().getName());
            rs = stm.executeQuery("SELECT * FROM rtr_setting");
            this.init(rs);
        }
        catch (NamingException e) {
            System.out.println(e);
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (SQLException ignore) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ignore) {}
            }
            if (cntx != null) {
                try {
                    cntx.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private void init(ResultSet rs) throws SQLException {
        LOGGER.debug((Object)"------------------ Nastavuje z rtr_setting ------------------");
        while (rs.next()) {
            if (rs.getString("settingKey") == null) continue;
            if (rs.getString("settingKey").equalsIgnoreCase("checkJidelnicek")) {
                this.checkJidelnicek = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Kontrolovat schvaleny jidelnicek (checkJidelnicek) -- " + this.isCheckJidelnicek()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useWeekends")) {
                this.weekends = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Povoleny jidla o vikendech (useWeekends) -- " + this.isWeekends()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("showWeekends")) {
                this.showWeekends = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Zobrazovat vikendy v kalend\u00e1\u0159i (showWeekends) -- " + this.isWeekends()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useDonation")) {
                this.useDonation = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Pouzivat dotace (useDonation) -- " + this.isUseDonation()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useRelations")) {
                this.useRelations = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Pouzivat relace mezi chody (useRelations) -- " + this.isUseRelations()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("runMesses")) {
                this.runMesses = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Prubezne posilani poctu porci (runMesses) -- " + this.isRunMesses()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("watchTerminals")) {
                this.watchTerminals = rs.getBoolean("settingValue");
                LOGGER.debug((Object)("Sledovani dostupnosti terminalu (watchTerminals) -- " + this.isWatchTerminals()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useBurza")) {
                this.setBurzaAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povolena burza (useBurza) -- " + this.isBurzaAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("mesicniAvailable")) {
                this.setMesicniAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povolen zobrazovat menu mesicni (mesicniAvailable) -- " + this.isMesicniAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("platbyAvailable")) {
                this.setPlatbyAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno zobrazovat platby (platbyAvailable) -- " + this.isPlatbyAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("historieAvailable")) {
                this.setHistorieAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno zobrazovat historii (historieAvailable) -- " + this.isHistorieAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("tydenniAvailable")) {
                this.setTydenniAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno zobrazovat menu tydenni (tydenniAvailable) -- " + this.isTydenniAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("denniAvailable")) {
                this.setDenniAvailable(rs.getBoolean("settingValue"));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("messagingAvailable")) {
                this.setMessagingAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno p\u0159ij\u00edm\u00e1n\u00ed zpr\u00e1v od j\u00eddelny (messagingAvailable) -- " + this.isMessagingAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("picturesAvailable")) {
                this.setPicturesAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno zobrazovat fotografie j\u00eddel (picturesAvailable) -- " + this.isPicturesAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("alergensAvailable")) {
                this.setAlergensAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Zobrazovat alergeny (alergensAvailable) -- " + this.isAlergensAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("objednavkyAvailable")) {
                this.setObjednavkyAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno zobrazovat menu objednavky (objednavkyAvailable) -- " + this.isObjednavkyAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("kreditAvailable")) {
                this.setKreditAvailable(rs.getInt("settingValue") > 0);
                this.setKreditAutomate(rs.getInt("settingValue") == 1);
                LOGGER.debug((Object)("Zobrazovat kredit (kreditAvailable) -- " + this.isKreditAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useValidity")) {
                this.setUsePlatne(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Pouzivat platnost (useValidity) -- " + this.isUsePlatne()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useIps")) {
                this.setUseIps(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Je povoleno propojen\u00ed na IPS (useIps) -- " + this.isUseIps()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("spotrebaAvailable")) {
                this.setSpotrebaAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Zobrazovat spotrebu (spotrebaAvailable) -- " + this.isSpotrebaAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("ratingAvailable")) {
                this.setRatingAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Zobrazovat rating (ratingAvailable) -- " + this.isRatingAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("tiskAvailable")) {
                this.setTiskAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povolen tisk v\u00fddejky (tiskAvailable) -- " + this.isTiskAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("localeAvailable")) {
                this.setLocaleAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno p\u0159ep\u00edn\u00e1n\u00ed jazyk\u016f (localeAvailable) -- " + this.isLocaleAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("terminalLoginNameAvailable")) {
                this.setTerminalLoginNameAvailable(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Povoleno p\u0159ihla\u0161ov\u00e1n\u00ed na termin\u00e1lu (terminalLoginNameAvailable) -- " + this.isTerminalLoginNameAvailable()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("lastLoginAvailable")) {
                this.setShowLastLogin(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Zobrazovat datum posledn\u00edho p\u0159ihl\u00e1\u0161en\u00ed (lastLoginAvailable) -- " + this.isShowLastLogin()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("lastOrderAvailable")) {
                switch (rs.getInt("settingValue")) {
                    case 0: {
                        this.setShowLastOrder(State.disabled);
                    }
                    case 1: {
                        this.setShowLastOrder(State.online);
                    }
                    case 2: {
                        this.setShowLastOrder(State.offline);
                    }
                }
                LOGGER.debug((Object)("Zobrazovat datum posledn\u00ed objedn\u00e1vky (lastOrderAvailable) -- " + this.isShowLastOrder()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("useMultipleIncrement")) {
                this.setAllowMultipleIncrement(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Je povoleno propojen\u00ed na IPS (useMultipleIncrement) -- " + this.isAllowMultipleIncrement()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("initialDayIncrement")) {
                this.setInitialDateIncrement(rs.getInt("settingValue"));
                LOGGER.debug((Object)("Posun dn\u00ed o X (initialDayIncrement) -- " + this.getInitialDateIncrement()));
                continue;
            }
            if (rs.getString("settingKey").equalsIgnoreCase("flipCode")) {
                this.setFlipCode(rs.getBoolean("settingValue"));
                LOGGER.debug((Object)("Je nastaveno obracen\u00ed k\u00f3du \u010dipu (flipCode) -- " + this.isFlipCode()));
                continue;
            }
            if (!rs.getString("settingKey").equalsIgnoreCase("infoUzivatele")) continue;
            try {
                this.setInfoUzivatele(rs.getString("settingDescription"));
            }
            catch (Exception ignore) {
                this.setInfoUzivatele(null);
            }
        }
        LOGGER.info((Object)"------------------ Program setting ------------------");
        LOGGER.info((Object)("Kontrolovat schvaleny jidelnicek (checkJidelnicek) -- " + this.isCheckJidelnicek()));
        LOGGER.info((Object)("Povoleny jidla o vikendech (useWeekends) -- " + this.isWeekends()));
        LOGGER.info((Object)("Zobrazovat vikendy v kalend\u00e1\u0159i (showWeekends) -- " + this.isWeekends()));
        LOGGER.info((Object)("Pouzivat dotace (useDonation) -- " + this.isUseDonation()));
        LOGGER.info((Object)("Pouzivat relace mezi chody (useRelations) -- " + this.isUseRelations()));
        LOGGER.info((Object)("Prubezne posilani poctu porci (runMesses) -- " + this.isRunMesses()));
        LOGGER.info((Object)("Sledovani dostupnosti terminalu (watchTerminals) -- " + this.isWatchTerminals()));
        LOGGER.info((Object)("Povolena burza (useBurza) -- " + this.isBurzaAvailable()));
        LOGGER.info((Object)("Povolen zobrazovat menu mesicni (mesicniAvailable) -- " + this.isMesicniAvailable()));
        LOGGER.info((Object)("Povoleno zobrazovat platby (platbyAvailable) -- " + this.isPlatbyAvailable()));
        LOGGER.info((Object)("Povoleno zobrazovat historii (historieAvailable) -- " + this.isHistorieAvailable()));
        LOGGER.info((Object)("Povoleno zobrazovat menu tydenni (tydenniAvailable) -- " + this.isTydenniAvailable()));
        LOGGER.info((Object)("Povoleno zobrazovat menu denni (denniAvailable) -- " + this.isDenniAvailable()));
        LOGGER.info((Object)("Povoleno p\u0159ij\u00edm\u00e1n\u00ed zpr\u00e1v od j\u00eddelny (messagingAvailable) -- " + this.isMessagingAvailable()));
        LOGGER.info((Object)("Povoleno zobrazovat fotografie j\u00eddel (picturesAvailable) -- " + this.isPicturesAvailable()));
        LOGGER.info((Object)("Zobrazovat alergeny (alergensAvailable) -- " + this.isAlergensAvailable()));
        LOGGER.info((Object)("Povoleno zobrazovat menu objednavky (objednavkyAvailable) -- " + this.isObjednavkyAvailable()));
        LOGGER.info((Object)("Zobrazovat kredit (kreditAvailable) -- " + this.isKreditAvailable()));
        LOGGER.info((Object)("Pouzivat platnost (useValidity) -- " + this.isUsePlatne()));
        LOGGER.info((Object)("Je povoleno propojen\u00ed na IPS (useIps) -- " + this.isUseIps()));
        LOGGER.info((Object)("Zobrazovat spotrebu (spotrebaAvailable) -- " + this.isSpotrebaAvailable()));
        LOGGER.info((Object)("Zobrazovat rating (ratingAvailable) -- " + this.isRatingAvailable()));
        LOGGER.info((Object)("Povolen tisk v\u00fddejky (tiskAvailable) -- " + this.isTiskAvailable()));
        LOGGER.info((Object)("Povoleno p\u0159ep\u00edn\u00e1n\u00ed jazyk\u016f (localeAvailable) -- " + this.isLocaleAvailable()));
        LOGGER.info((Object)("Povoleno p\u0159ihla\u0161ov\u00e1n\u00ed na termin\u00e1lu (terminalLoginNameAvailable) -- " + this.isTerminalLoginNameAvailable()));
        LOGGER.info((Object)("Zobrazovat datum posledn\u00edho p\u0159ihl\u00e1\u0161en\u00ed (lastLoginAvailable) -- " + this.isShowLastLogin()));
        LOGGER.info((Object)("Zobrazovat datum posledn\u00ed objedn\u00e1vky (lastOrderAvailable) -- " + this.isShowLastOrder()));
        LOGGER.info((Object)("Je povoleno propojen\u00ed na IPS (useMultipleIncrement) -- " + this.isAllowMultipleIncrement()));
        LOGGER.info((Object)("Posun dn\u00ed o X (initialDayIncrement) -- " + this.getInitialDateIncrement()));
        LOGGER.info((Object)("Je nastaveno obracen\u00ed k\u00f3du \u010dipu (flipCode) -- " + this.isFlipCode()));
        LOGGER.info((Object)"-------------------------------------------------------");
    }

    public void setWatchTerminals(boolean watchTerminals) {
        this.watchTerminals = watchTerminals;
    }

    public boolean isWatchTerminals() {
        return this.watchTerminals;
    }

    public boolean isRunMesses() {
        return this.runMesses;
    }

    public boolean isWeekends() {
        return this.weekends;
    }

    public void setWeekends(boolean weekends) {
        this.weekends = weekends;
    }

    public boolean isUseDonation() {
        return this.useDonation;
    }

    public void setUseDonation(boolean useDonation) {
        this.useDonation = useDonation;
    }

    public boolean isCheckJidelnicek() {
        return this.checkJidelnicek;
    }

    public void setCheckJidelnicek(boolean checkJidelnicek) {
        this.checkJidelnicek = checkJidelnicek;
    }

    public boolean isUseRelations() {
        return this.useRelations;
    }

    public void setUseRelations(boolean useRelations) {
        this.useRelations = useRelations;
    }

    public boolean isBurzaAvailable() {
        return this.burzaAvailable;
    }

    public void setBurzaAvailable(boolean burzaAvailable) {
        this.burzaAvailable = burzaAvailable;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public boolean isMssqlDriver() {
        return this.driverClassName.equals(SQL_DRIVER_MSSQL);
    }

    public String getNowFunction() {
        if (this.isMssqlDriver()) {
            return "getDate()";
        }
        return "NOW()";
    }

    public boolean isMesicniAvailable() {
        return this.mesicniAvailable;
    }

    public void setMesicniAvailable(boolean mesicniAvailable) {
        this.mesicniAvailable = mesicniAvailable;
    }

    public boolean isTydenniAvailable() {
        return this.tydenniAvailable;
    }

    public void setTydenniAvailable(boolean tydenniAvailable) {
        this.tydenniAvailable = tydenniAvailable;
    }

    public boolean isDenniAvailable() {
        return this.denniAvailable;
    }

    public void setDenniAvailable(boolean denniAvailable) {
        this.denniAvailable = denniAvailable;
    }

    public boolean isPlatbyAvailable() {
        return this.platbyAvailable;
    }

    public void setPlatbyAvailable(boolean platbyAvailable) {
        this.platbyAvailable = platbyAvailable;
    }

    public boolean isObjednavkyAvailable() {
        return this.objednavkyAvailable;
    }

    public void setObjednavkyAvailable(boolean objednavkyAvailable) {
        this.objednavkyAvailable = objednavkyAvailable;
    }

    public boolean isUsePlatne() {
        return this.usePlatne;
    }

    public void setUsePlatne(boolean usePlatne) {
        this.usePlatne = usePlatne;
    }

    public boolean isSpotrebaAvailable() {
        return this.spotrebaAvailable;
    }

    public void setSpotrebaAvailable(boolean spotrebaAvailable) {
        this.spotrebaAvailable = spotrebaAvailable;
    }

    public boolean isKreditAvailable() {
        return this.kreditAvailable;
    }

    public void setKreditAvailable(boolean kreditAvailable) {
        this.kreditAvailable = kreditAvailable;
    }

    public boolean isKreditAutomate() {
        return this.kreditAutomate;
    }

    public void setKreditAutomate(boolean kreditAutomate) {
        this.kreditAutomate = kreditAutomate;
    }

    public boolean isFlipCode() {
        return this.flipCode;
    }

    public void setFlipCode(boolean flipCode) {
        this.flipCode = flipCode;
    }

    public boolean isHistorieAvailable() {
        return this.historieAvailable;
    }

    public void setHistorieAvailable(boolean historieAvailable) {
        this.historieAvailable = historieAvailable;
    }

    public String getInfoUzivatele() {
        return this.infoUzivatele;
    }

    public void setInfoUzivatele(String infoUzivatele) {
        this.infoUzivatele = infoUzivatele;
    }

    public boolean isTiskAvailable() {
        return this.tiskAvailable;
    }

    public void setTiskAvailable(boolean tiskAvailable) {
        this.tiskAvailable = tiskAvailable;
    }

    public boolean isShowLastOrder() {
        return this.isShowLastOrderOffline() || this.isShowLastOrderOnline();
    }

    public boolean isShowLastOrderOnline() {
        return this.showLastOrder.equals((Object)State.online);
    }

    public boolean isShowLastOrderOffline() {
        return this.showLastOrder.equals((Object)State.offline);
    }

    public void setShowLastOrder(State showLastOrder) {
        this.showLastOrder = showLastOrder;
    }

    public boolean isAllowMultipleIncrement() {
        return this.allowMultipleIncrement;
    }

    public void setAllowMultipleIncrement(boolean allowMultipleIncrement) {
        this.allowMultipleIncrement = allowMultipleIncrement;
    }

    public boolean isUseIps() {
        return this.useIps;
    }

    public void setUseIps(boolean useIps) {
        this.useIps = useIps;
    }

    public int getSPEC_JEN_JEDNO_JIDLO_DENNE() {
        return 1;
    }

    public int getSPEC_PEVNE_OBJEDNAVKY() {
        return 7;
    }

    public int getSPEC_CELY_DEN() {
        return 8;
    }

    public int getSPEC_NEMOZNOST_ODHLASEK() {
        return 9;
    }

    public int getInitialDateIncrement() {
        return this.initialDateIncrement;
    }

    public void setInitialDateIncrement(int initialDateIncrement) {
        this.initialDateIncrement = initialDateIncrement;
    }

    public boolean isLocaleAvailable() {
        return this.localeAvailable;
    }

    public void setLocaleAvailable(boolean localeAvailable) {
        this.localeAvailable = localeAvailable;
    }

    public boolean isTerminalLoginNameAvailable() {
        return this.terminalLoginNameAvailable;
    }

    public void setTerminalLoginNameAvailable(boolean terminalLoginNameAvailable) {
        this.terminalLoginNameAvailable = terminalLoginNameAvailable;
    }

    public boolean isShowWeekends() {
        return this.showWeekends;
    }

    public void setShowWeekends(boolean showWeekends) {
        this.showWeekends = showWeekends;
    }

    public boolean isShowLastLogin() {
        return this.showLastLogin;
    }

    public void setShowLastLogin(boolean showLastLogin) {
        this.showLastLogin = showLastLogin;
    }

    public boolean isRatingAvailable() {
        return this.ratingAvailable;
    }

    public void setRatingAvailable(boolean ratingAvailable) {
        this.ratingAvailable = ratingAvailable;
    }

    public boolean isMessagingAvailable() {
        return this.messagingAvailable;
    }

    public void setMessagingAvailable(boolean messagingAvailable) {
        this.messagingAvailable = messagingAvailable;
    }

    public boolean isPicturesAvailable() {
        return this.picturesAvailable;
    }

    public void setPicturesAvailable(boolean picturesAvailable) {
        this.picturesAvailable = picturesAvailable;
    }

    public boolean isAlergensAvailable() {
        return this.alergensAvailable;
    }

    public void setAlergensAvailable(boolean alergensAvailable) {
        this.alergensAvailable = alergensAvailable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        disabled,
        online,
        offline;

    }
}

