/*
 * Decompiled with CFR 0.152.
 */
package universalrouter;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import universalrouter.comm.MainPort;
import universalrouter.comm.ServerConfiguration;
import universalrouter.gui.GUITool;

public class Main {
    private static Logger logger = Logger.getLogger(Main.class);
    private static String comPort;
    private static String volume;

    public static void main(String[] args) throws IOException {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:beans.xml");
        logger.info((Object)"Startuji Universal Router ve verzi G1.8.10 ...");
        try {
            comPort = args[0];
        }
        catch (Exception e) {
            System.out.println("-----------------------------");
            System.out.println("Pro spusteni programu zadejte port '/dev/ttySO','COM1'");
            System.out.println("-h --help                   napoveda ke spusteni programu UniversalRouter");
            System.out.println("-v --version                vypsani verze programu");
            System.out.println("-n --nocomm                 spusteni bez vlastni komunikace");
            System.out.println("-g --guitool                spusteni UR v grafickem modu (GUITool)");
            System.out.println("-d --debug                  Krome systemovych debug hlasek se loguji take vsechny vyzvy");
            System.out.println("--nolocal                   Vypne posilani cestiny do vsech terminalu");
            System.out.println("-s=[0-9] --setvol=[0-9]     nastaveni hlasitosti na vsech terminalech");
            System.out.println("-----------------------------");
            logger.warn((Object)"Nebyl definovan zadny komunikacni port. Pouziji vychozi nastaveni");
        }
        if (Main.findArgs(args, "--help") > -1 || Main.findArgs(args, "-h") > -1) {
            System.exit(0);
        }
        if (Main.findArgs(args, "--version") > -1 || Main.findArgs(args, "-g") > -1) {
            logger.info((Object)"Program UniversalRouter ve verzi G1.8.10");
            logger.info((Object)"Koncim program UniversalRouter...");
            System.exit(0);
        }
        if (Main.findArgs(args, "--setvol=") > -1 || Main.findArgs(args, "-s=") > -1) {
            int ind = Main.findArgs(args, "--setvol=");
            volume = args[ind].substring(6, args[ind].length());
        } else {
            volume = "-1";
        }
        boolean urComm = true;
        boolean guiTool = false;
        boolean debug = false;
        boolean localChars = true;
        if (Main.findArgs(args, "--guitool") > -1 || Main.findArgs(args, "-g") > -1) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception e) {
                logger.debug((Object)"WindowsLookAndFeel neni k dispozici, zustane metal");
            }
            guiTool = true;
        }
        if (Main.findArgs(args, "--nocomm") > -1 || Main.findArgs(args, "-n") > -1) {
            logger.info((Object)"********Bez komunikace********");
            urComm = false;
        }
        if (Main.findArgs(args, "--nolocal") > -1 || Main.findArgs(args, "-l") > -1) {
            logger.info((Object)"********Bez cestiny********");
            localChars = false;
        }
        if (Main.findArgs(args, "--debug") > -1 || Main.findArgs(args, "-d") > -1) {
            logger.info((Object)"Zap\u00edn\u00e1m debugov\u00e1n\u00ed v\u0161ech ud\u00e1lost\u00ed");
            debug = true;
        }
        logger.debug((Object)"Zaciname prenaset");
        SAXReader confReader = new SAXReader(false);
        confReader.setIgnoreComments(true);
        confReader.setStripWhitespaceText(true);
        InputStream inputStream = Main.class.getClassLoader().getResourceAsStream("conf.xml");
        try {
            Document confXML = confReader.read(inputStream);
            ServerConfiguration sConf = new ServerConfiguration(Integer.valueOf(confXML.getRootElement().element("afterRTSTrueTime").getText()), Integer.valueOf(confXML.getRootElement().element("afterRTSFalseTime").getText()), Integer.valueOf(confXML.getRootElement().element("afterCallSendTime").getText()), Integer.valueOf(confXML.getRootElement().element("afterDataSendTime").getText()), Integer.valueOf(confXML.getRootElement().element("beforeReadTime").getText()), Integer.valueOf(confXML.getRootElement().element("cycleTime").getText()), Integer.valueOf(confXML.getRootElement().element("printer").getText()), Integer.valueOf(confXML.getRootElement().element("resetAfter").getText()), Integer.valueOf(confXML.getRootElement().element("maxIncommingLength").getText()), confXML.getRootElement().element("defaultPort").getText(), Integer.valueOf(confXML.getRootElement().attributeValue("instanceNumber")), Long.valueOf(confXML.getRootElement().element("timeSetInterval").getText()), Byte.valueOf(confXML.getRootElement().attributeValue("serverAddress")));
            logger.info((Object)("Nastaveno cislo instance na " + sConf.getInstanceNumber()));
            confReader = null;
            confXML = null;
            if (guiTool) {
                new Thread(new GUITool()).start();
            }
            if (urComm) {
                MainPort runnable = new MainPort(comPort, sConf, volume, guiTool, (ApplicationContext)ctx, debug, localChars);
                Thread thread = new Thread(runnable);
                thread.start();
                thread.join();
            }
        }
        catch (InterruptedException ex) {
            logger.info((Object)"Ukon\u010deno komunika\u010dn\u00ed vl\u00e1kno", (Throwable)ex);
        }
        catch (DocumentException e) {
            logger.error((Object)"Chyba pri nacitani nastaveni", (Throwable)e);
        }
    }

    private static int findArgs(String[] args, String arg) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(arg) && !args[i].startsWith(arg)) continue;
            return i;
        }
        return -1;
    }

    static {
        volume = "-1";
    }
}

