/*
 * Decompiled with CFR 0.152.
 */
package cz.zware.universalrouter.utility;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateFunction {
    private static final long msPerDay = 86400000L;
    public static final String dateFormat = "dd.MM.yyyy HH:mm:ss";

    public static String getLastTimeOrderAsString(Date orderDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(orderDate);
    }

    public static String getLastTimeOrderAsString(int days, Date limitTime, Date orderDate, boolean useSaturdaySunday) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(DateFunction.getLastTimeOrderRelative(days, limitTime, orderDate, useSaturdaySunday));
    }

    public static String getLastTimeOrderAbsoluteAsString(int days, Date limitTime, Date orderDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(DateFunction.getLastTimeOrderAbsolute(days, limitTime, orderDate));
    }

    public static Date getLastTimeOrderRelative(int days, Date limitTime, Date orderDate, boolean useSaturdaySunday) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(orderDate);
        calendar.set(11, limitTime.getHours());
        calendar.set(12, limitTime.getMinutes());
        calendar.set(13, 0);
        Calendar orderCalendar = Calendar.getInstance();
        orderCalendar.setTime(orderDate);
        int minusDays = 0;
        if (useSaturdaySunday) {
            calendar.add(7, -days);
            return calendar.getTime();
        }
        calendar.add(7, -(days / 5 * 2));
        calendar.add(7, -days);
        if (calendar.get(7) == 1) {
            minusDays += 2;
        } else if (calendar.get(7) == 7) {
            minusDays = orderCalendar.get(7) == 7 ? ++minusDays : (minusDays += 2);
        } else if (calendar.get(7) == 6 && days % 5 > 0) {
            minusDays = orderCalendar.get(7) == 7 ? ++minusDays : (minusDays += 2);
        } else if (calendar.get(7) == 5 && days % 5 > 1) {
            minusDays = orderCalendar.get(7) == 7 ? ++minusDays : (minusDays += 2);
        } else if (calendar.get(7) == 4 && days % 5 > 2) {
            minusDays = orderCalendar.get(7) == 7 ? ++minusDays : (minusDays += 2);
        } else if (calendar.get(7) == 3 && days % 5 > 3) {
            minusDays = orderCalendar.get(7) == 7 ? ++minusDays : (minusDays += 2);
        } else if (calendar.get(7) == 2 && days % 5 > 4) {
            minusDays = orderCalendar.get(7) == 7 ? ++minusDays : (minusDays += 2);
        }
        calendar.add(7, -minusDays);
        calendar.get(7);
        return calendar.getTime();
    }

    public static Date getLastTimeOrderAbsolute(int days, Date limitTime, Date orderDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(orderDate);
        calendar.set(11, limitTime.getHours());
        calendar.set(12, limitTime.getMinutes());
        calendar.set(13, 0);
        int denVTydnu = -1;
        switch (days % 7) {
            case 1: {
                denVTydnu = 2;
                break;
            }
            case 2: {
                denVTydnu = 3;
                break;
            }
            case 3: {
                denVTydnu = 4;
                break;
            }
            case 4: {
                denVTydnu = 5;
                break;
            }
            case 5: {
                denVTydnu = 6;
                break;
            }
            case 6: {
                denVTydnu = 7;
                break;
            }
            case 7: {
                denVTydnu = 1;
            }
        }
        calendar.add(7, -7);
        calendar.set(7, denVTydnu);
        return calendar.getTime();
    }

    @Deprecated
    public static String toDate(int m, int d, int y) {
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.set(y, --m, d);
        String str = Integer.toString(c.get(1)) + "-";
        str = str + Integer.toString(c.get(2) + 1) + "-";
        str = str + Integer.toString(c.get(5));
        return str;
    }

    @Deprecated
    public static boolean isDate(int m, int d, int y) {
        --m;
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        try {
            c.set(y, m, d);
            Date dt = c.getTime();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

